/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.machine;

import edu.mayo.bmi.fsm.condition.TextSetCondition;
import edu.mayo.bmi.fsm.condition.TextValueCondition;
import edu.mayo.bmi.fsm.output.StatusIndicator;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.state.NonTerminalEndState;
import edu.mayo.bmi.fsm.token.BaseToken;
import edu.mayo.bmi.fsm.token.TextToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class StatusIndicatorFSM {
    private Set<String> iv_probableSet = new HashSet<String>();
    private Set<String> iv_historySet = new HashSet<String>();
    private Set<String> iv_familyHistorySet = new HashSet<String>();
    private Machine iv_probableMachine;
    private Machine iv_historyMachine;
    private Machine iv_familyHistoryMachine;
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public StatusIndicatorFSM() {
        this.iv_probableSet.add("possible");
        this.iv_probableSet.add("possibly");
        this.iv_probableSet.add("probable");
        this.iv_probableSet.add("likely");
        this.iv_historySet.add("hx");
        this.iv_historySet.add("history");
        this.iv_familyHistorySet.add("fx");
        this.iv_familyHistorySet.add("fh");
        this.iv_historyMachine = this.getHistoryMachine();
        this.iv_probableMachine = this.getProbableMachine();
        this.iv_familyHistoryMachine = this.getFamilyHistoryMachine();
        this.iv_machineSet.add(this.iv_historyMachine);
        this.iv_machineSet.add(this.iv_probableMachine);
        this.iv_machineSet.add(this.iv_familyHistoryMachine);
    }

    private Machine getProbableMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition probableC = new TextSetCondition(this.iv_probableSet, false);
        startState.addTransition(probableC, endState);
        startState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getHistoryMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState hAbbrState = new NamedState("HISTORY_ABBR");
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition historyC = new TextSetCondition(this.iv_historySet, false);
        startState.addTransition(historyC, endState);
        startState.addTransition(new TextValueCondition("h", false), hAbbrState);
        startState.addTransition(new AnyCondition(), startState);
        hAbbrState.addTransition(new TextValueCondition("/", false), fslashState);
        hAbbrState.addTransition(new AnyCondition(), startState);
        fslashState.addTransition(new TextValueCondition("o", false), endState);
        fslashState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getFamilyHistoryMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState familyState = new NamedState("FAMILY");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition familyHistoryC = new TextSetCondition(this.iv_familyHistorySet, false);
        startState.addTransition(familyHistoryC, endState);
        startState.addTransition(new TextValueCondition("family", false), familyState);
        startState.addTransition(new AnyCondition(), startState);
        familyState.addTransition(new TextValueCondition("history", false), endState);
        familyState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set<StatusIndicator> execute(List<TextToken> tokens) throws Exception {
        HashSet<StatusIndicator> outSet = new HashSet<StatusIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = tokens.get(i);
            for (Machine m : this.iv_machineSet) {
                int tokenStartIndex;
                m.input(token);
                State currentState = m.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(m, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(m);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? (BaseToken)tokens.get(i - 1) : token;
                BaseToken startToken = tokens.get(tokenStartIndex);
                StatusIndicator si = null;
                if (m.equals(this.iv_historyMachine)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 1);
                } else if (m.equals(this.iv_probableMachine)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 3);
                } else if (m.equals(this.iv_familyHistoryMachine)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 2);
                }
                outSet.add(si);
                m.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine m : this.iv_machineSet) {
            m.reset();
        }
        return outSet;
    }
}

