/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.lookup.algorithms;

import edu.mayo.bmi.dictionary.DictionaryEngine;
import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.lookup.algorithms.LookupAlgorithm;
import edu.mayo.bmi.lookup.phrasebuilder.PhraseBuilder;
import edu.mayo.bmi.lookup.vo.LookupHit;
import edu.mayo.bmi.lookup.vo.LookupToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DirectPassThroughImpl
implements LookupAlgorithm {
    private DictionaryEngine iv_dictEngine;
    private PhraseBuilder iv_phrBuilder;

    public DirectPassThroughImpl(DictionaryEngine dictEngine, PhraseBuilder phraseBuilder) {
        this.iv_dictEngine = dictEngine;
        this.iv_phrBuilder = phraseBuilder;
    }

    @Override
    public Collection lookup(List ltList, Map ctxMap) throws Exception {
        ArrayList<LookupHit> lhList = new ArrayList<LookupHit>();
        int tokenIdx = 0;
        while (tokenIdx < ltList.size()) {
            LookupToken lt = (LookupToken)ltList.get(tokenIdx);
            ArrayList<LookupToken> singleLtList = new ArrayList<LookupToken>();
            singleLtList.add(lt);
            String[] strArr = this.iv_phrBuilder.getPhrases(singleLtList);
            Collection mdhCol = this.getHits(strArr);
            if (mdhCol != null && mdhCol.size() > 0) {
                for (MetaDataHit mdh : mdhCol) {
                    LookupHit lh = new LookupHit(mdh, lt.getStartOffset(), lt.getEndOffset());
                    lhList.add(lh);
                }
            }
            ++tokenIdx;
        }
        return lhList;
    }

    private Collection getHits(String[] phrases) throws Exception {
        ArrayList mdhCol = new ArrayList();
        int i = 0;
        while (i < phrases.length) {
            Collection curMdhCol = this.iv_dictEngine.metaLookup(phrases[i]);
            if (curMdhCol.size() > 0) {
                mdhCol.addAll(curMdhCol);
            }
            ++i;
        }
        return mdhCol;
    }
}

