/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.lookup.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class PermutationUtil {
    public static List getPermutationList(int maxLevel) {
        ArrayList<List> permList = new ArrayList<List>();
        int levelIdx = maxLevel;
        while (levelIdx >= 0) {
            ArrayList<Integer> baseNumList = new ArrayList<Integer>();
            int j = 1;
            while (j <= levelIdx) {
                baseNumList.add(new Integer(j));
                ++j;
            }
            ArrayList<ArrayList<Integer>> numListCol = new ArrayList<ArrayList<Integer>>();
            if (levelIdx != maxLevel) {
                numListCol.addAll(PermutationUtil.getNumLists(maxLevel, baseNumList));
            } else {
                numListCol.add(baseNumList);
            }
            for (List list : numListCol) {
                Collection pCol = PermutationUtil.getLinearPermutations(list);
                for (List permutation : pCol) {
                    permList.add(permutation);
                }
            }
            if (levelIdx == 0) {
                permList.add(new ArrayList());
            }
            --levelIdx;
        }
        return permList;
    }

    private static Collection getNumLists(int maxLevel, List baseNumList) {
        ArrayList numListCol = new ArrayList();
        PermutationUtil.buildPermutations(maxLevel, baseNumList, numListCol, new ArrayList(), 0);
        PermutationUtil.filterNonIncreasingLists(numListCol);
        return numListCol;
    }

    private static void filterNonIncreasingLists(Collection numListCol) {
        HashSet<List> removalSet = new HashSet<List>();
        for (List numList : numListCol) {
            Integer largestNum = null;
            for (Integer num : numList) {
                if (largestNum == null) {
                    largestNum = num;
                    continue;
                }
                int comparison = largestNum.compareTo(num);
                if (comparison == 1) {
                    removalSet.add(numList);
                    continue;
                }
                largestNum = num;
            }
        }
        numListCol.removeAll(removalSet);
    }

    private static void buildPermutations(int maxLevel, List baseNumList, Collection numListCol, List residualList, int residualCount) {
        if (residualCount > baseNumList.size()) {
            return;
        }
        if (residualCount == baseNumList.size()) {
            numListCol.add(new ArrayList(residualList));
            return;
        }
        int num = (Integer)baseNumList.get(residualCount);
        ++residualCount;
        int i = num;
        while (i <= maxLevel) {
            ArrayList<Integer> tempList = new ArrayList<Integer>(residualList);
            if (!tempList.contains(new Integer(i))) {
                tempList.add(new Integer(i));
                PermutationUtil.buildPermutations(maxLevel, baseNumList, numListCol, tempList, residualCount);
            }
            ++i;
        }
    }

    public static Collection getLinearPermutations(List numList) {
        ArrayList permutations = new ArrayList();
        PermutationUtil.getLinearPermutations(permutations, new ArrayList(), numList);
        return permutations;
    }

    private static void getLinearPermutations(Collection permutations, List plusList, List numList) {
        for (Integer num : numList) {
            ArrayList subList = new ArrayList();
            subList.addAll(numList);
            subList.remove(num);
            plusList.add(num);
            if (subList.size() > 0) {
                PermutationUtil.getLinearPermutations(permutations, plusList, subList);
            } else {
                ArrayList<Integer> permutation = new ArrayList<Integer>();
                int i = 0;
                while (i < plusList.size()) {
                    Integer n = (Integer)plusList.get(i);
                    permutation.add(n);
                    ++i;
                }
                permutations.add(permutation);
            }
            plusList.remove(num);
        }
    }
}

