/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.nlp.parser;

import edu.mayo.bmi.nlp.parser.type.ConllDependencyNode;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class DependencyNodeWriter
extends CasConsumer_ImplBase {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private String iv_outputDir = null;
    private String iv_outputFormat = null;
    private int iv_procCount = 0;

    @Override
    public void initialize() throws ResourceInitializationException {
        this.iv_outputDir = (String)this.getConfigParameterValue("outputDir");
        this.iv_outputFormat = (String)this.getConfigParameterValue("outputFormat");
    }

    private void processView(JCas jCas) throws Exception {
        String docName = DocumentIDAnnotationUtil.getDocumentID(jCas);
        docName = docName == null ? "doc" + this.iv_procCount + "." + this.iv_outputFormat.toLowerCase() : String.valueOf(docName) + "." + this.iv_outputFormat.toLowerCase();
        try {
            File outputDir = new File(this.iv_outputDir);
            outputDir.mkdirs();
            File outputFile = new File(String.valueOf(this.iv_outputDir) + File.separatorChar + docName);
            outputFile.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            AnnotationIndex nodeIndex = jCas.getAnnotationIndex(ConllDependencyNode.type);
            FSIterator sentences = jCas.getAnnotationIndex(Sentence.type).iterator();
            while (sentences.hasNext()) {
                Sentence sentence = (Sentence)sentences.next();
                ConllDependencyNode node = null;
                FSIterator nodeIterator = nodeIndex.subiterator(sentence);
                while (nodeIterator.hasNext()) {
                    node = (ConllDependencyNode)nodeIterator.next();
                    if (node.getID() == 0) continue;
                    if (this.iv_outputFormat.toLowerCase().contains("min")) {
                        bw.write(String.valueOf(node.getID()) + "\t");
                        bw.write(String.valueOf(node.getFORM()) + "\t");
                        bw.write((node.getHEAD() == null ? "_" : Integer.valueOf(node.getHEAD().getID())) + "\t");
                        bw.write(String.valueOf(node.getDEPREL()) + "\n");
                        continue;
                    }
                    if (this.iv_outputFormat.toLowerCase().contains("mpos")) {
                        bw.write(String.valueOf(node.getID()) + "\t");
                        bw.write(String.valueOf(node.getFORM()) + "\t");
                        bw.write(String.valueOf(node.getPOSTAG()) + "\t");
                        bw.write((node.getHEAD() == null ? "_" : Integer.valueOf(node.getHEAD().getID())) + "\t");
                        bw.write(String.valueOf(node.getDEPREL()) + "\n");
                        continue;
                    }
                    if (this.iv_outputFormat.toLowerCase().contains("mlem")) {
                        bw.write(String.valueOf(node.getID()) + "\t");
                        bw.write(String.valueOf(node.getFORM()) + "\t");
                        bw.write(String.valueOf(node.getLEMMA()) + "\t");
                        bw.write((node.getHEAD() == null ? "_" : Integer.valueOf(node.getHEAD().getID())) + "\t");
                        bw.write(String.valueOf(node.getDEPREL()) + "\n");
                        continue;
                    }
                    if (this.iv_outputFormat.toLowerCase().contains("dep")) {
                        bw.write(String.valueOf(node.getID()) + "\t");
                        bw.write(String.valueOf(node.getFORM()) + "\t");
                        bw.write(String.valueOf(node.getLEMMA()) + "\t");
                        bw.write(String.valueOf(node.getPOSTAG()) + "\t");
                        bw.write((node.getHEAD() == null ? "_" : Integer.valueOf(node.getHEAD().getID())) + "\t");
                        bw.write(String.valueOf(node.getDEPREL()) + "\n");
                        continue;
                    }
                    bw.write(String.valueOf(node.getID()) + "\t");
                    bw.write(String.valueOf(node.getFORM()) + "\t");
                    bw.write(String.valueOf(node.getLEMMA()) + "\t");
                    bw.write(String.valueOf(node.getCPOSTAG()) + "\t");
                    bw.write(String.valueOf(node.getPOSTAG()) + "\t");
                    bw.write(String.valueOf(node.getFEATS()) + "\t");
                    bw.write((node.getHEAD() == null ? "_" : Integer.valueOf(node.getHEAD().getID())) + "\t");
                    bw.write(String.valueOf(node.getDEPREL()) + "\t");
                    bw.write((node.getPHEAD() == null ? "_" : Integer.valueOf(node.getPHEAD().getID())) + "\t");
                    bw.write(String.valueOf(node.getPDEPREL()) + "\n");
                }
                bw.write("\n");
            }
            bw.flush();
        }
        finally {
            ++this.iv_procCount;
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        this.iv_logger.info("Started");
        try {
            JCas currentView = cas.getCurrentView().getJCas();
            this.processView(currentView);
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }
}

