/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.nlp.parser;

import edu.mayo.bmi.nlp.parser.type.ConllDependencyNode;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class LemAssigner
extends JCasAnnotator_ImplBase {
    public Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.logger.info(" process(JCas)");
        ArrayList<ConllDependencyNode> nodes = new ArrayList<ConllDependencyNode>();
        ArrayList<BaseToken> tokens = new ArrayList<BaseToken>();
        AnnotationIndex nodeIndex = jCas.getAnnotationIndex(ConllDependencyNode.type);
        AnnotationIndex tokenIndex = jCas.getAnnotationIndex(BaseToken.type);
        FSIterator sentences = jCas.getAnnotationIndex(Sentence.type).iterator();
        while (sentences.hasNext()) {
            Sentence sentence = (Sentence)sentences.next();
            tokens.clear();
            nodes.clear();
            FSIterator tokenIterator = tokenIndex.subiterator(sentence);
            while (tokenIterator.hasNext()) {
                tokens.add((BaseToken)tokenIterator.next());
            }
            FSIterator nodeIterator = nodeIndex.subiterator(sentence);
            while (nodeIterator.hasNext()) {
                ConllDependencyNode node = (ConllDependencyNode)nodeIterator.next();
                if (node.getID() == 0) continue;
                nodes.add(node);
            }
            ListIterator itt = tokens.listIterator();
            ListIterator itn = nodes.listIterator();
            BaseToken bt = null;
            ConllDependencyNode dn = null;
            if (tokens.size() <= 0 || nodes.size() <= 0) continue;
            if (itt.hasNext()) {
                bt = (BaseToken)itt.next();
            }
            if (itn.hasNext()) {
                dn = (ConllDependencyNode)itn.next();
            }
            if (dn != null && dn.getID() == 0 && itn.hasNext()) {
                dn = (ConllDependencyNode)itn.next();
            }
            while (itt.hasNext() || itn.hasNext()) {
                if (bt.getBegin() == dn.getBegin()) {
                    dn.setLEMMA(bt.getNormalizedForm());
                    if (dn.getLEMMA() == null) {
                        dn.setLEMMA(dn.getFORM().toLowerCase());
                    }
                    dn.addToIndexes();
                    if (itt.hasNext()) {
                        bt = (BaseToken)itt.next();
                    }
                    if (!itn.hasNext()) continue;
                    dn = (ConllDependencyNode)itn.next();
                    continue;
                }
                if (bt.getBegin() < dn.getBegin()) {
                    if (!itt.hasNext()) break;
                    bt = (BaseToken)itt.next();
                    continue;
                }
                if (bt.getBegin() <= dn.getBegin()) continue;
                if (!itn.hasNext()) break;
                dn.setLEMMA(dn.getFORM().toLowerCase());
                dn.addToIndexes();
                dn = (ConllDependencyNode)itn.next();
            }
            if (bt.getBegin() != dn.getBegin() || bt.getEnd() != dn.getEnd()) continue;
            dn.setLEMMA(bt.getNormalizedForm());
            dn.addToIndexes();
        }
    }
}

