/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.nlp.parser.ae;

import clear.dep.DepNode;
import clear.dep.DepParser;
import clear.dep.DepTree;
import edu.mayo.bmi.nlp.parser.type.ConllDependencyNode;
import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.io.File;
import java.util.ArrayList;
import liblinear.Linear;
import liblinear.Model;
import liblinear.Parameter;
import liblinear.Problem;
import liblinear.SolverType;
import liblinear.Train;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class ClearTrainerAE
extends JCasAnnotator_ImplBase {
    public Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String DEPENDENCY_MODEL_FILE_PARAM = "DependencyModelFile";
    public static final String LEXICON_DIR_PARAM = "LexiconDirectory";
    public static final String FEATURE_TEMPLATE_PARAM = "FeatureTemplateFile";
    public static final String LIBLINEAR_PATH_PARAM = "TrainerPath";
    public static final String LIBLINEAR_SOLVER_PARAM = "TrainerSolver";
    public static final String LIBLINEAR_COST_PARAM = "TrainerCost";
    public static final String LIBLINEAR_EPSILON_PARAM = "TrainerEpsilon";
    public static final String LIBLINEAR_BIAS_PARAM = "TrainerBias";
    protected DepParser parser;
    private int parseFailureCount = 0;
    private int sentenceCount = 0;
    private String absParserModelPath = null;
    private String absLexiconDirectoryPath = null;
    private String absFeatureTemplateFile = null;
    private String absFeatureDataFile = null;
    private String trainerPath = null;
    private int trainerSolver = 3;
    private double trainerCost = 0.1;
    private double trainerEpsilon = 0.1;
    private double trainerBias = -1.0;
    StringBuilder liblinearCommand = new StringBuilder();

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        try {
            String parserModelPath = (String)uimaContext.getConfigParameterValue(DEPENDENCY_MODEL_FILE_PARAM);
            File parserModelFile = FileLocator.locateFile(parserModelPath);
            this.absParserModelPath = parserModelFile.getAbsolutePath();
            this.logger.info("parser model file: " + this.absParserModelPath);
            this.absFeatureDataFile = String.valueOf(this.absParserModelPath) + ".ftr";
            String lexiconDirectoryPath = (String)uimaContext.getConfigParameterValue(LEXICON_DIR_PARAM);
            File lexiconDirectoryFile = FileLocator.locateFile(lexiconDirectoryPath);
            this.absLexiconDirectoryPath = lexiconDirectoryFile.getAbsolutePath();
            this.logger.info("lexicon directory: " + this.absLexiconDirectoryPath);
            String featureTemplatePath = (String)uimaContext.getConfigParameterValue(FEATURE_TEMPLATE_PARAM);
            File featureTemplateFile = FileLocator.locateFile(featureTemplatePath);
            this.absFeatureTemplateFile = featureTemplateFile.getAbsolutePath();
            this.logger.info("feature template file: " + this.absFeatureTemplateFile);
            if (uimaContext.getConfigParameterValue(LIBLINEAR_PATH_PARAM) != null) {
                this.trainerPath = (String)uimaContext.getConfigParameterValue(LIBLINEAR_PATH_PARAM);
            }
            if (uimaContext.getConfigParameterValue(LIBLINEAR_SOLVER_PARAM) != null) {
                this.trainerSolver = (Integer)uimaContext.getConfigParameterValue(LIBLINEAR_SOLVER_PARAM);
            }
            if (uimaContext.getConfigParameterValue(LIBLINEAR_COST_PARAM) != null) {
                this.trainerCost = ((Float)uimaContext.getConfigParameterValue(LIBLINEAR_COST_PARAM)).floatValue();
            }
            if (uimaContext.getConfigParameterValue(LIBLINEAR_EPSILON_PARAM) != null) {
                this.trainerEpsilon = ((Float)uimaContext.getConfigParameterValue(LIBLINEAR_EPSILON_PARAM)).floatValue();
            }
            if (uimaContext.getConfigParameterValue(LIBLINEAR_BIAS_PARAM) != null) {
                this.trainerBias = ((Float)uimaContext.getConfigParameterValue(LIBLINEAR_BIAS_PARAM)).floatValue();
            }
            System.out.print("starting Clear parser trainer ... ");
            System.out.println("done.");
        }
        catch (Exception e) {
            this.logger.info("Error initializing parser model: " + this.absParserModelPath);
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.logger.info(" process(JCas)");
        ArrayList<ConllDependencyNode> nodes = new ArrayList<ConllDependencyNode>();
        int i = 0;
        while (i < 2) {
            AnnotationIndex nodeIndex = jCas.getAnnotationIndex(ConllDependencyNode.type);
            FSIterator sentences = jCas.getAnnotationIndex(Sentence.type).iterator();
            this.parser = i == 0 ? new DepParser(this.absLexiconDirectoryPath, this.absFeatureDataFile, this.absFeatureTemplateFile, 0) : new DepParser(this.absLexiconDirectoryPath, this.absFeatureDataFile, this.absFeatureTemplateFile, 1);
            while (sentences.hasNext()) {
                Sentence sentence = (Sentence)sentences.next();
                nodes.clear();
                FSIterator nodeIterator = nodeIndex.subiterator(sentence);
                while (nodeIterator.hasNext()) {
                    ConllDependencyNode node = (ConllDependencyNode)nodeIterator.next();
                    if (node.getID() == 0) continue;
                    nodes.add(node);
                }
                DepTree tree = new DepTree();
                for (ConllDependencyNode cNode : nodes) {
                    DepNode node = new DepNode();
                    node.id = cNode.getID();
                    node.form = cNode.getFORM();
                    node.lemma = cNode.getLEMMA();
                    node.pos = cNode.getPOSTAG();
                    node.headId = cNode.getHEAD().getID();
                    node.deprel = cNode.getDEPREL();
                    tree.add(node);
                }
                this.parser.parse(tree);
            }
            if (i == 0) {
                this.parser.saveTags(this.absLexiconDirectoryPath);
            }
            ++i;
        }
        if (new File(this.trainerPath).exists()) {
            this.liblinearCommand.append(this.trainerPath);
            this.liblinearCommand.append(" -s " + this.trainerSolver);
            this.liblinearCommand.append(" -c " + this.trainerCost);
            this.liblinearCommand.append(" -e " + this.trainerEpsilon);
            this.liblinearCommand.append(" -B " + this.trainerBias);
            this.liblinearCommand.append(" " + this.absFeatureDataFile);
            this.liblinearCommand.append(" " + this.absParserModelPath);
            String cmd = this.liblinearCommand.toString();
            System.out.println("- Command : " + cmd);
            try {
                Runtime rt = Runtime.getRuntime();
                long st = System.currentTimeMillis();
                Process ps = rt.exec(cmd);
                ps.waitFor();
                long time = System.currentTimeMillis() - st;
                System.out.printf("- Duration: %d hours, %d minutes\n", time / 3600000L, time / 60000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Train trainer = new Train();
            System.out.println("- Training with Java liblinear...");
            try {
                Problem prob = Train.readProblem(new File(this.absFeatureDataFile), this.trainerBias);
                Parameter param = new Parameter(SolverType.values()[this.trainerSolver], this.trainerCost, this.trainerEpsilon);
                Model model = Linear.train(prob, param);
                Linear.saveModel(new File(this.absParserModelPath), model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        System.out.println("total number of sentences that were not parsed was: " + this.parseFailureCount + " out of " + this.sentenceCount);
    }
}

