/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.nlp.parser.util;

import clear.dep.DepNode;
import clear.dep.DepTree;
import edu.mayo.bmi.nlp.parser.type.ConllDependencyNode;
import edu.mayo.bmi.nlp.parser.util.DependencyUtility;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class ClearDependencyUtility
extends DependencyUtility {
    public Logger logger = Logger.getLogger(this.getClass().getName());

    public static ArrayList<ConllDependencyNode> convert(JCas jcas, DepTree clearTree, Sentence sentence, List<BaseToken> tokens) {
        ArrayList<ConllDependencyNode> uimaNodes = new ArrayList<ConllDependencyNode>(tokens.size() + 1);
        int rootBegin = tokens.get(0).getBegin();
        int rootEnd = tokens.get(tokens.size() - 1).getEnd();
        uimaNodes.add(0, new ConllDependencyNode(jcas, rootBegin, rootEnd));
        int i = 1;
        while (i < clearTree.size()) {
            int nodeBegin = tokens.get(i - 1).getBegin();
            int nodeEnd = tokens.get(i - 1).getEnd();
            ConllDependencyNode uimaNode = new ConllDependencyNode(jcas, nodeBegin, nodeEnd);
            uimaNodes.add(i, uimaNode);
            ++i;
        }
        i = 1;
        while (i < clearTree.size()) {
            DepNode clearNode = (DepNode)clearTree.get(i);
            ConllDependencyNode uimaNode = uimaNodes.get(i);
            uimaNode.setID(clearNode.id);
            uimaNode.setFORM(clearNode.form);
            uimaNode.setLEMMA(clearNode.lemma);
            uimaNode.setCPOSTAG(clearNode.pos);
            uimaNode.setPOSTAG(clearNode.pos);
            uimaNode.setFEATS("_");
            uimaNode.setHEAD(uimaNodes.get(clearNode.headId));
            uimaNode.setDEPREL(clearNode.deprel);
            uimaNode.setPHEAD(null);
            uimaNode.setPDEPREL("_");
            ++i;
        }
        return uimaNodes;
    }

    public static boolean equalCoverage(Annotation annot1, Annotation annot2) {
        return annot1.getBegin() == annot2.getBegin() && annot1.getEnd() == annot2.getEnd() && annot1.getCoveredText() == annot2.getCoveredText();
    }
}

