/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.nlp.parser.util;

import edu.mayo.bmi.nlp.parser.type.ConllDependencyNode;
import edu.mayo.bmi.nlp.parser.util.DependencyPath;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public abstract class DependencyUtility {
    public static void addToIndexes(JCas jcas, ArrayList<ConllDependencyNode> nodes) {
        int i = 0;
        while (i < nodes.size()) {
            nodes.get(i).addToIndexes(jcas);
            ++i;
        }
    }

    public static boolean equalCoverage(Annotation annot1, Annotation annot2) {
        return annot1.getBegin() == annot2.getBegin() && annot1.getEnd() == annot2.getEnd() && annot1.getCoveredText().equals(annot2.getCoveredText());
    }

    public static ArrayList<ConllDependencyNode> getConllNodesFromCas(JCas jCas, Sentence sentence) {
        ArrayList<ConllDependencyNode> nodes = new ArrayList<ConllDependencyNode>();
        AnnotationIndex nodeIndex = jCas.getAnnotationIndex(ConllDependencyNode.type);
        FSIterator nodeIterator = nodeIndex.subiterator(sentence);
        while (nodeIterator.hasNext()) {
            ConllDependencyNode node = (ConllDependencyNode)nodeIterator.next();
            if (node.getID() == 0) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static DependencyPath getPath(ConllDependencyNode node1, ConllDependencyNode node2, List<ConllDependencyNode> nodes) {
        DependencyPath pathUp1 = new DependencyPath();
        DependencyPath pathUp2 = new DependencyPath();
        DependencyPath pathLtoR = new DependencyPath();
        DependencyPath pathRtoL = new DependencyPath();
        if (node1 == null || node2 == null) {
            System.err.println(" WARNING: looking for path between null nodes.");
            return null;
        }
        pathUp1.add(node1);
        while (node1.getHEAD() != null) {
            node1 = node1.getHEAD();
            pathUp1.add(node1);
        }
        pathUp2.add(node2);
        while (node2.getHEAD() != null) {
            node2 = node2.getHEAD();
            pathUp2.add(node2);
        }
        pathLtoR.clear();
        boolean foundMatch = false;
        int i = 0;
        while (i < pathUp1.size()) {
            ConllDependencyNode nodeUp1 = (ConllDependencyNode)pathUp1.get(i);
            pathLtoR.add(nodeUp1);
            pathRtoL.clear();
            int j = 0;
            while (j < pathUp2.size()) {
                ConllDependencyNode nodeUp2 = (ConllDependencyNode)pathUp2.get(j);
                if (DependencyUtility.equalCoverage(nodeUp1, nodeUp2)) {
                    pathLtoR.setCommonNode(nodeUp1);
                    pathLtoR.addAll(pathRtoL);
                    foundMatch = true;
                    break;
                }
                pathRtoL.push(nodeUp2);
                ++j;
            }
            if (foundMatch) break;
            ++i;
        }
        return pathLtoR;
    }

    public static List<ConllDependencyNode> getRightSibs(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        ConllDependencyNode parent = refNode.getHEAD();
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        for (ConllDependencyNode node : tree.subList(tree.indexOf(refNode) + 1, tree.size())) {
            if (!node.getHEAD().equals(parent)) continue;
            out.add(node);
        }
        return out;
    }

    public static List<ConllDependencyNode> getLeftSibs(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        ConllDependencyNode parent = refNode.getHEAD();
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        List<ConllDependencyNode> lSide = tree.subList(0, tree.indexOf(refNode));
        int i = tree.indexOf(refNode) - 1;
        while (i >= 0) {
            ConllDependencyNode node = lSide.get(i);
            if (node.getHEAD().equals(parent)) {
                out.add(node);
            }
            --i;
        }
        return out;
    }

    public static List<ConllDependencyNode> getProgeny(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        block0: for (ConllDependencyNode node : tree) {
            if (node.equals(refNode)) {
                out.add(node);
                continue;
            }
            ConllDependencyNode upNode = node;
            while (upNode.getHEAD() != null) {
                if (!(upNode = upNode.getHEAD()).equals(refNode)) continue;
                out.add(node);
                continue block0;
            }
        }
        return out;
    }

    public static List<ConllDependencyNode> getProgeny(List<ConllDependencyNode> refNodes, List<ConllDependencyNode> tree) {
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        block0: for (ConllDependencyNode node : tree) {
            if (refNodes.contains(node)) {
                out.add(node);
                continue;
            }
            ConllDependencyNode upNode = node;
            while (upNode.getHEAD() != null) {
                if (!refNodes.contains(upNode = upNode.getHEAD())) continue;
                out.add(node);
                continue block0;
            }
        }
        return out;
    }

    public static List<ConllDependencyNode> getRightSibProgeny(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        return DependencyUtility.getProgeny(DependencyUtility.getRightSibs(refNode, tree), tree);
    }

    public static List<ConllDependencyNode> getLeftSibProgeny(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        return DependencyUtility.getProgeny(DependencyUtility.getLeftSibs(refNode, tree), tree);
    }
}

