/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.nlp.test;

import edu.mayo.bmi.nlp.preprocessor.ClinicalNotePreProcessor;
import edu.mayo.bmi.nlp.preprocessor.DocumentMetaData;
import edu.mayo.bmi.nlp.preprocessor.SegmentMetaData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class TestDriver {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: TestDriver <input file> [<dtd file>]");
            System.exit(1);
        }
        try {
            File dtdFile;
            String hl7Text = TestDriver.load(args[0]);
            String dtdFilename = "resources/cda/NotesIIST_RTF.DTD";
            if (args.length > 1) {
                dtdFilename = args[1];
            }
            if (!TestDriver.exists(dtdFile = new File(dtdFilename))) {
                System.exit(-1);
            }
            ClinicalNotePreProcessor pp = new ClinicalNotePreProcessor(dtdFile, false);
            long timestamp = System.currentTimeMillis();
            DocumentMetaData dmd = pp.process(hl7Text);
            long elapsedTime = System.currentTimeMillis() - timestamp;
            System.out.println("PreProcessor Took " + elapsedTime + "ms");
            System.out.println("Plain Text Start");
            System.out.println(dmd.getText());
            System.out.println("Plain Text End");
            Set<String> sectionNames = dmd.getSegmentIdentifiers();
            for (String sectionId : sectionNames) {
                SegmentMetaData smd = dmd.getSegment(sectionId);
                System.out.println("SECTION=" + sectionId + "\tSTART_OFFSET=" + smd.span.start + "\tEND_OFFSET=" + smd.span.end);
            }
            Map metaDataMap = dmd.getMetaData();
            for (Object key : metaDataMap.keySet()) {
                Object value = metaDataMap.get(key);
                System.out.println("MetaData KEY=" + key.toString() + " VALUE=" + value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String load(String filename) throws FileNotFoundException, IOException {
        String msg = "";
        File f = new File(filename);
        TestDriver.exists(f);
        BufferedReader br = new BufferedReader(new FileReader(f));
        String line = br.readLine();
        while (line != null) {
            msg = String.valueOf(msg) + line + "\n";
            line = br.readLine();
        }
        br.close();
        return msg;
    }

    public static boolean exists(File f) {
        if (f.exists()) {
            return true;
        }
        System.out.println("cwd = " + new File(".").getAbsolutePath());
        System.out.println("File " + f + " does not exist.");
        return false;
    }
}

