/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.smoking.ae;

import edu.mayo.bmi.uima.SmokingStatus.type.UnknownSmokerNamedEntityAnnotation;
import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.libsvm.type.NominalAttributeValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;

public class KuRuleBasedClassifierAnnotator
extends JCasAnnotator_ImplBase {
    Set<String> smokingWords;
    Set<String> unknownWords;
    String classAttributeName;
    boolean caseSensitive = true;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.smokingWords = new HashSet<String>();
        this.unknownWords = new HashSet<String>();
        try {
            Object paramValue = aContext.getConfigParameterValue("CaseSensitive");
            if (paramValue != null) {
                this.caseSensitive = (Boolean)paramValue;
            }
            this.classAttributeName = (String)aContext.getConfigParameterValue("classAttribute");
            String smokingWordsFileName = (String)aContext.getConfigParameterValue("SmokingWordsFile");
            this.smokingWords = this.readLinesFromFile(FileLocator.locateFile(smokingWordsFileName).getAbsolutePath());
            String unknownWordsFileName = (String)aContext.getConfigParameterValue("UnknownWordsFile");
            this.unknownWords = this.readLinesFromFile(FileLocator.locateFile(unknownWordsFileName).getAbsolutePath());
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator tokenItr = indexes.getAnnotationIndex(WordToken.type).iterator();
        String classVal = "UNKNOWN";
        while (tokenItr.hasNext()) {
            WordToken token = (WordToken)tokenItr.next();
            String strToken = token.getCoveredText();
            if (strToken == null) continue;
            if (!this.caseSensitive) {
                strToken = strToken.toLowerCase();
            }
            if (!this.smokingWords.contains(strToken)) continue;
            classVal = "KNOWN";
            break;
        }
        if (classVal.equals("KNOWN")) {
            String sen = jcas.getDocumentText();
            for (String s : this.unknownWords) {
                if (!sen.toLowerCase().trim().matches(".*" + s + ".*")) continue;
                classVal = "UNKNOWN";
                break;
            }
        }
        FSIterator neItr = indexes.getAnnotationIndex(UnknownSmokerNamedEntityAnnotation.type).iterator();
        while (neItr.hasNext()) {
            UnknownSmokerNamedEntityAnnotation neAnn = (UnknownSmokerNamedEntityAnnotation)neItr.next();
            System.out.println("***UnknownNamedEntity|" + neAnn.getCoveredText());
            classVal = "UNKNOWN";
        }
        NominalAttributeValue nominalAttributeValue = new NominalAttributeValue(jcas);
        nominalAttributeValue.setAttributeName(this.classAttributeName);
        nominalAttributeValue.setNominalValue(classVal);
        nominalAttributeValue.addToIndexes();
    }

    private Set<String> readLinesFromFile(String fileName) throws IOException {
        String line;
        HashSet<String> returnValues = new HashSet<String>();
        File file = new File(fileName);
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            if (!this.caseSensitive) {
                line = line.toLowerCase().trim();
            }
            returnValues.add(line);
        }
        return returnValues;
    }
}

