/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.smoking.ae;

import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;

public class SentenceAdjuster
extends JCasAnnotator_ImplBase {
    public static final String PARAM_IGNORE_WORDS = "WordsToIgnore";
    public static final String PARAM_WORDS_IN_PATTERN = "WordsInPattern";
    public Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private UimaContext context;
    private HashSet<String> wordsToIgnore;
    private HashSet<String> wordsInPattern;
    private boolean useSegments;
    private Set<String> skipSegmentsSet;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.context = aContext;
        try {
            this.configInit();
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
        }
    }

    private void configInit() throws AnnotatorContextException {
        String[] ignoreWords = (String[])this.context.getConfigParameterValue(PARAM_IGNORE_WORDS);
        this.wordsToIgnore = new HashSet();
        int i = 0;
        while (i < ignoreWords.length) {
            this.wordsToIgnore.add(ignoreWords[i]);
            ++i;
        }
        if (this.iv_logger.isInfoEnabled()) {
            this.iv_logger.info("Loaded list of " + ignoreWords.length + " words to ignore during adjustment.");
        }
        String[] patternWords = (String[])this.context.getConfigParameterValue(PARAM_WORDS_IN_PATTERN);
        this.wordsInPattern = new HashSet();
        int i2 = 0;
        while (i2 < patternWords.length) {
            this.wordsInPattern.add(patternWords[i2]);
            ++i2;
        }
        if (this.iv_logger.isInfoEnabled()) {
            this.iv_logger.info("Loaded list of " + patternWords.length + " pattern words for adjustment.");
        }
        this.useSegments = (Boolean)this.context.getConfigParameterValue("UseSegments");
        String[] skipSegmentIDs = (String[])this.context.getConfigParameterValue("SegmentsToSkip");
        this.skipSegmentsSet = new HashSet<String>();
        int i3 = 0;
        while (i3 < skipSegmentIDs.length) {
            this.skipSegmentsSet.add(skipSegmentIDs[i3]);
            ++i3;
        }
        if (this.iv_logger.isInfoEnabled()) {
            this.iv_logger.info("List of words to ignore during adjustment:");
        }
        Object[] o = this.wordsToIgnore.toArray();
        if (this.iv_logger.isInfoEnabled()) {
            int i4 = 0;
            while (i4 < ignoreWords.length) {
                this.iv_logger.info("  " + o[i4]);
                ++i4;
            }
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String text = jcas.getDocumentText();
        try {
            System.out.println(" jcas " + jcas.getViewName());
            if (!this.useSegments) {
                this.annotateRange(jcas, text, 0, text.length());
            } else {
                JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
                while (segmentItr.hasNext()) {
                    Segment segmentAnnotation = (Segment)segmentItr.next();
                    String segmentID = segmentAnnotation.getId();
                    if (this.skipSegmentsSet.contains(segmentID)) continue;
                    int start = segmentAnnotation.getBegin();
                    int end = segmentAnnotation.getEnd();
                    this.annotateRange(jcas, text, start, end);
                }
            }
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
        }
    }

    protected void annotateRange(JCas jcas, String text, int rangeBegin, int rangeEnd) throws AnnotatorContextException {
        if (this.iv_logger.isInfoEnabled()) {
            this.iv_logger.info("started Sentence merging process.");
        }
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator sentItr = indexes.getAnnotationIndex(Sentence.type).iterator();
        Sentence prevSent = null;
        Sentence currSent = null;
        Map<Integer, Sentence> sentences = this.getSentencesOrderById(sentItr);
        int i = 0;
        while (i < sentences.size()) {
            prevSent = currSent;
            currSent = sentences.get(new Integer(i));
            if (currSent == null) {
                this.iv_logger.error("Wow! some sentence is null");
            }
            if (prevSent != null && prevSent.getCoveredText().endsWith(":") && currSent != null) {
                int newEnd = -1;
                if (currSent.getSentenceNumber() - 1 == prevSent.getSentenceNumber()) {
                    String textSent2 = currSent.getCoveredText().toLowerCase();
                    for (String word : this.wordsInPattern) {
                        if (!textSent2.startsWith(word)) continue;
                        newEnd = currSent.getEnd();
                        prevSent.setEnd(newEnd);
                        currSent.removeFromIndexes();
                    }
                }
            }
            ++i;
        }
    }

    private Map<Integer, Sentence> getSentencesOrderById(Iterator<?> sentItr) {
        HashMap<Integer, Sentence> sentences = new HashMap<Integer, Sentence>();
        while (sentItr.hasNext()) {
            Sentence sa = (Sentence)sentItr.next();
            int snum = sa.getSentenceNumber();
            sentences.put(new Integer(snum), sa);
        }
        return sentences;
    }
}

