/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.smoking.patientLevel;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class PatientLevelSmokingStatus {
    private static String inputFile = "R:/Dept/projects/Text/NHGRI/October2010/smokingstatus/data/record_resolution.txt";
    private static String outputFile = "R:/Dept/projects/Text/NHGRI/October2010/smokingstatus/data/record_resolution_patient.txt";
    private static HashMap<String, Vector<Integer>> patientsStatuses = new HashMap();
    private static HashMap<String, String> finalAssignment = new HashMap();
    private static String delimiter = "\\,";

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Using input file " + inputFile + " and output file " + outputFile + ".  These values can be overridden by providing the input file and output file parameters, respectively, " + " when deploying this application.  By default the delimiter used to split out the patient information from the classification is ',', but a third parameter can be used to set this character value.");
        } else {
            inputFile = args[0];
            outputFile = args[1];
        }
        if (args.length == 3) {
            delimiter = args[2];
        }
        PatientLevelSmokingStatus.collectCounts(delimiter);
        PatientLevelSmokingStatus.assignPatientLevelSmokingStatus();
        PatientLevelSmokingStatus.printToFile();
    }

    public void setInputFile(String fileName) {
        inputFile = fileName;
    }

    public void setOutputFile(String fileName) {
        outputFile = fileName;
    }

    public static void collectCounts(String delim) {
        try {
            FileReader fr = new FileReader(inputFile);
            BufferedReader reader = new BufferedReader(fr);
            String line = null;
            try {
                boolean currentSmoker = false;
                boolean nonSmoker = false;
                boolean pastSmoker = false;
                boolean smoker = false;
                while ((line = reader.readLine()) != null) {
                    Vector<Object> smokingStatusElements;
                    if (line.length() < 1) continue;
                    line = line.trim();
                    System.out.println("Line: " + line);
                    String[] parts = line.split(delim);
                    String[] parts1 = parts[0].split("_");
                    String clinicNumber = parts1[1].substring(0, 8);
                    System.out.println(parts[1]);
                    if (parts[1].equals("PAST_SMOKER")) {
                        pastSmoker = true;
                        System.out.println("past smoker doc");
                    }
                    if (parts[1].equals("NON_SMOKER")) {
                        nonSmoker = true;
                        System.out.println("non smoker doc");
                    }
                    if (parts[1].equals("CURRENT_SMOKER")) {
                        currentSmoker = true;
                        System.out.println("current smoker doc");
                    }
                    if (parts[1].equals("SMOKER")) {
                        smoker = true;
                        System.out.println("smoker doc");
                    }
                    if (!patientsStatuses.containsKey(clinicNumber)) {
                        smokingStatusElements = new Vector(4);
                        if (currentSmoker) {
                            smokingStatusElements.insertElementAt(new Integer(1), 0);
                            smokingStatusElements.insertElementAt(new Integer(0), 1);
                            smokingStatusElements.insertElementAt(new Integer(0), 2);
                            smokingStatusElements.insertElementAt(new Integer(0), 3);
                            System.out.println("incrementing current");
                        } else if (nonSmoker) {
                            smokingStatusElements.insertElementAt(new Integer(0), 0);
                            smokingStatusElements.insertElementAt(new Integer(1), 1);
                            smokingStatusElements.insertElementAt(new Integer(0), 2);
                            smokingStatusElements.insertElementAt(new Integer(0), 3);
                            System.out.println("incrementing non");
                        } else if (pastSmoker) {
                            smokingStatusElements.insertElementAt(new Integer(0), 0);
                            smokingStatusElements.insertElementAt(new Integer(0), 1);
                            smokingStatusElements.insertElementAt(new Integer(1), 2);
                            smokingStatusElements.insertElementAt(new Integer(0), 3);
                            System.out.println("incrementing past");
                        } else if (smoker) {
                            smokingStatusElements.insertElementAt(new Integer(0), 0);
                            smokingStatusElements.insertElementAt(new Integer(0), 1);
                            smokingStatusElements.insertElementAt(new Integer(0), 2);
                            smokingStatusElements.insertElementAt(new Integer(1), 3);
                            System.out.println("incrementing past");
                        } else {
                            smokingStatusElements.insertElementAt(new Integer(0), 0);
                            smokingStatusElements.insertElementAt(new Integer(0), 1);
                            smokingStatusElements.insertElementAt(new Integer(0), 2);
                            smokingStatusElements.insertElementAt(new Integer(0), 3);
                        }
                        patientsStatuses.put(clinicNumber, smokingStatusElements);
                    } else {
                        int currentValue;
                        smokingStatusElements = patientsStatuses.get(clinicNumber);
                        if (currentSmoker) {
                            currentValue = (Integer)smokingStatusElements.elementAt(0);
                            smokingStatusElements.setElementAt(new Integer(++currentValue), 0);
                            System.out.println("incrementing current: " + currentValue);
                            patientsStatuses.put(clinicNumber, smokingStatusElements);
                        } else if (nonSmoker) {
                            currentValue = (Integer)smokingStatusElements.elementAt(1);
                            smokingStatusElements.setElementAt(new Integer(++currentValue), 1);
                            System.out.println("incrementing non: " + currentValue);
                            patientsStatuses.put(clinicNumber, smokingStatusElements);
                        } else if (pastSmoker) {
                            currentValue = (Integer)smokingStatusElements.elementAt(2);
                            smokingStatusElements.setElementAt(new Integer(++currentValue), 2);
                            System.out.println("incrementing past: " + currentValue);
                            patientsStatuses.put(clinicNumber, smokingStatusElements);
                        } else if (smoker) {
                            currentValue = (Integer)smokingStatusElements.elementAt(3);
                            smokingStatusElements.setElementAt(new Integer(++currentValue), 3);
                            System.out.println("incrementing smoker: " + currentValue);
                            patientsStatuses.put(clinicNumber, smokingStatusElements);
                        }
                    }
                    currentSmoker = false;
                    nonSmoker = false;
                    pastSmoker = false;
                    smoker = false;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                reader.close();
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static void assignPatientLevelSmokingStatus() {
        Set<String> clinicNumbers = patientsStatuses.keySet();
        for (String clinicNumber : clinicNumbers) {
            Vector<Integer> smokingStatuses = patientsStatuses.get(clinicNumber);
            int current = smokingStatuses.elementAt(0);
            int non = smokingStatuses.elementAt(1);
            int past = smokingStatuses.elementAt(2);
            int smoker = smokingStatuses.elementAt(3);
            if (current == 0 && non == 0 && past == 0 && smoker == 0) {
                finalAssignment.put(clinicNumber, "UNKNOWN");
                continue;
            }
            if (non > 0 && past == 0 && current == 0 && smoker == 0) {
                finalAssignment.put(clinicNumber, "NON_SMOKER");
                continue;
            }
            if (smoker > 0 && past == 0 && current == 0) {
                finalAssignment.put(clinicNumber, "SMOKER");
                continue;
            }
            if (past > 0 || current > 0) {
                if (past > 0 && current == 0) {
                    finalAssignment.put(clinicNumber, "PAST_SMOKER");
                    continue;
                }
                if (past == 0 && current > 0) {
                    finalAssignment.put(clinicNumber, "CURRENT_SMOKER");
                    continue;
                }
                if (past <= 0 || current <= 0) continue;
                if (past <= current) {
                    finalAssignment.put(clinicNumber, "CURRENT_SMOKER");
                    continue;
                }
                finalAssignment.put(clinicNumber, "PAST_SMOKER");
                continue;
            }
            System.out.println("Undefined case");
            System.exit(1);
        }
    }

    public static void printToFile() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputFile, false));
            Set<String> clinicNumbers = finalAssignment.keySet();
            for (String clinicNumber : clinicNumbers) {
                String smokingStatus = finalAssignment.get(clinicNumber);
                out.write("\n" + clinicNumber + "|" + smokingStatus);
            }
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

