/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.cni.ae;

import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.IdentifiedAnnotation;
import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.OntologyConcept;
import edu.mayo.bmi.uima.core.type.Properties;
import edu.mayo.bmi.uima.core.type.Property;
import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.type.WordToken;
import java.util.HashSet;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;

public class ExtractionPrepAnnotator
extends JTextAnnotator_ImplBase {
    private String iv_annotVerPropKey;
    private int iv_annotVer;

    @Override
    public void initialize(AnnotatorContext aCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(aCtx);
        try {
            this.iv_annotVer = (Integer)aCtx.getConfigParameterValue("AnnotationVersion");
            this.iv_annotVerPropKey = (String)aCtx.getConfigParameterValue("AnnotationVersionPropKey");
        }
        catch (Exception e) {
            throw new AnnotatorInitializationException(e);
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification rs) throws AnnotatorProcessException {
        this.generateUidValues(jcas);
        this.generateTokenNormForms(jcas);
        this.assignNamedEntityFeats(jcas);
        this.storeAnnotationVersion(jcas);
    }

    private void storeAnnotationVersion(JCas jcas) {
        FSIterator itr = jcas.getJFSIndexRepository().getAnnotationIndex(Properties.type).iterator();
        if (itr == null || !itr.hasNext()) {
            return;
        }
        Properties props = (Properties)itr.next();
        FSArray propArr = props.getPropArr();
        FSArray newPropArr = new FSArray(jcas, propArr.size() + 1);
        int i = 0;
        while (i < propArr.size()) {
            newPropArr.set(i, propArr.get(i));
            ++i;
        }
        Property annotVerProp = new Property(jcas);
        annotVerProp.setKey(this.iv_annotVerPropKey);
        annotVerProp.setValue(String.valueOf(this.iv_annotVer));
        newPropArr.set(newPropArr.size() - 1, annotVerProp);
        props.setPropArr(newPropArr);
    }

    private void generateUidValues(JCas jcas) {
        int uid = 0;
        FSIterator itr = jcas.getJFSIndexRepository().getAnnotationIndex(IdentifiedAnnotation.type).iterator();
        while (itr.hasNext()) {
            IdentifiedAnnotation idAnnot = (IdentifiedAnnotation)itr.next();
            idAnnot.setUid(uid);
            ++uid;
        }
    }

    private void generateTokenNormForms(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator btaItr = indexes.getAnnotationIndex(BaseToken.type).iterator();
        while (btaItr.hasNext()) {
            WordToken wta;
            String canonicalForm;
            BaseToken bta = (BaseToken)btaItr.next();
            String normForm = null;
            normForm = !(bta instanceof WordToken) ? bta.getCoveredText() : ((canonicalForm = (wta = (WordToken)bta).getCanonicalForm()) != null && canonicalForm.length() > 0 ? canonicalForm : wta.getCoveredText());
            bta.setNormalizedForm(normForm);
        }
    }

    private void assignNamedEntityFeats(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        HashSet segmentSet = new HashSet();
        FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
        while (segmentItr.hasNext()) {
            segmentSet.add(segmentItr.next());
        }
        FSIterator neItr = indexes.getAnnotationIndex(NamedEntity.type).iterator();
        while (neItr.hasNext()) {
            NamedEntity neAnnot = (NamedEntity)neItr.next();
            for (Segment seg : segmentSet) {
                if (neAnnot.getBegin() < seg.getBegin() || neAnnot.getEnd() > seg.getEnd()) continue;
                neAnnot.setSegmentID(seg.getId());
                break;
            }
            FSArray ocArr = neAnnot.getOntologyConceptArr();
            if (ocArr == null) continue;
            int i = 0;
            while (i < ocArr.size()) {
                OntologyConcept oc = (OntologyConcept)ocArr.get(i);
                String code = oc.getCode();
                String scheme = oc.getCodingScheme();
                StringBuffer oid = new StringBuffer();
                oid.append(code);
                oid.append("#");
                oid.append(scheme);
                oc.setOid(oid.toString());
                ++i;
            }
        }
    }
}

