/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.ae;

import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;

public class SimpleSegmentWithTagsAnnotator
extends JTextAnnotator_ImplBase {
    private String segmentId;

    @Override
    public void initialize(AnnotatorContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(aContext);
        try {
            this.segmentId = (String)aContext.getConfigParameterValue("SegmentID");
            if (this.segmentId == null) {
                this.segmentId = "SIMPLE_SEGMENT";
            }
        }
        catch (AnnotatorContextException ace) {
            throw new AnnotatorConfigurationException(ace);
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        String text = jcas.getDocumentText();
        if (text == null) {
            System.out.println("text == null in Segmentannotator");
            String docID = DocumentIDAnnotationUtil.getDocumentID(jcas);
            System.out.println(" \t\tdocID=" + docID);
        }
        if (this.segmentId.compareTo("parseSectionTag") != 0) {
            Segment sa = new Segment(jcas);
            sa.setBegin(0);
            sa.setEnd(jcas.getDocumentText().length());
            sa.setId(this.segmentId);
            sa.addToIndexes();
        } else {
            BufferedReader fileReader = new BufferedReader(new StringReader(text));
            int charNum = 0;
            int charPos = 0;
            char[] sectIdArr = new char[5];
            int endStartSegment = 0;
            int beginEndSegment = 0;
            try {
                while ((charNum = fileReader.read()) != -1) {
                    String segId = "";
                    if (charNum == 91) {
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum != 115 && charNum != 101) continue;
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum != 116 && charNum != 110) continue;
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum != 97 && charNum != 100) continue;
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum == 114) {
                            endStartSegment = charPos + 24;
                            fileReader.skip(14L);
                            fileReader.read(sectIdArr, 0, 5);
                            charPos += 19;
                        } else if (charNum == 32) {
                            beginEndSegment = charPos - 5;
                            Segment sa = new Segment(jcas);
                            sa.setBegin(endStartSegment);
                            sa.setEnd(beginEndSegment);
                            sa.setId(String.copyValueOf(sectIdArr));
                            int i = 0;
                            while (i < sectIdArr.length) {
                                sectIdArr[i] = 32;
                                ++i;
                            }
                            sa.addToIndexes();
                        }
                        ++charPos;
                        continue;
                    }
                    ++charPos;
                }
            }
            catch (Exception e) {
                throw new AnnotatorProcessException(e);
            }
        }
    }
}

