/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.cc;

import edu.mayo.bmi.uima.core.util.JCasUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class HtmlTableCasConsumer
extends CasConsumer_ImplBase {
    private File iv_outputDir;
    private int iv_tableSpanType;
    private int[] iv_nestedAnnTypeArr;
    private Map iv_getterMethMap = new HashMap();
    private int iv_count;
    private String[] iv_tdStyleArr = new String[]{"I", "B"};

    @Override
    public void initialize() throws ResourceInitializationException {
        try {
            this.iv_outputDir = new File((String)this.getConfigParameterValue("OutputDir"));
            String classname = (String)this.getConfigParameterValue("TableSpanAnnotation");
            this.iv_tableSpanType = JCasUtil.getType(classname);
            String[] strArr = (String[])this.getConfigParameterValue("NestedAnnotations");
            this.iv_nestedAnnTypeArr = new int[strArr.length];
            int i = 0;
            while (i < strArr.length) {
                StringTokenizer st = new StringTokenizer(strArr[i], "|");
                classname = st.nextToken().trim();
                this.iv_nestedAnnTypeArr[i] = JCasUtil.getType(classname);
                if (st.countTokens() == 1) {
                    String methName = st.nextToken().trim();
                    Class<?> c = Class.forName(classname);
                    Method meth = c.getMethod(methName, null);
                    this.iv_getterMethMap.put(new Integer(this.iv_nestedAnnTypeArr[i]), meth);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            StringBuffer htmlSB = new StringBuffer();
            htmlSB.append("<HTML>");
            htmlSB.append("<TITLE>?</TITLE>");
            htmlSB.append("<BODY>");
            FSIterator tSpanItr = jcas.getJFSIndexRepository().getAnnotationIndex(this.iv_tableSpanType).iterator();
            while (tSpanItr.hasNext()) {
                Annotation tSpanAnn = (Annotation)tSpanItr.next();
                String tSpanText = tSpanAnn.getCoveredText();
                htmlSB.append("<TABLE border=1>");
                htmlSB.append("<TR bordercolor=\"white\">");
                int i = 0;
                while (i < tSpanText.length()) {
                    htmlSB.append("<TD width=10>");
                    htmlSB.append(tSpanText.charAt(i));
                    htmlSB.append("</TD>");
                    ++i;
                }
                htmlSB.append("</TR>");
                int tdStyleIdx = 0;
                int nestIdx = 0;
                while (nestIdx < this.iv_nestedAnnTypeArr.length) {
                    List nestedAnnList = this.getAnnotations(jcas, this.iv_nestedAnnTypeArr[nestIdx], tSpanAnn.getBegin(), tSpanAnn.getEnd());
                    Collections.sort(nestedAnnList, new AnnotationLengthComparator());
                    List annotsAtRowList = this.arrangeIntoRows(tSpanAnn, nestedAnnList);
                    Iterator trAnnItr = annotsAtRowList.iterator();
                    while (trAnnItr.hasNext()) {
                        htmlSB.append("<TR>");
                        int cursor = tSpanAnn.getBegin();
                        List annList = (List)trAnnItr.next();
                        Collections.sort(annList, new AnnotationPositionComparator());
                        for (Annotation ann : annList) {
                            int delta = ann.getBegin() - cursor;
                            if (delta > 0) {
                                htmlSB.append("<TD width=10 colspan=" + delta + ">");
                                String whitespaceStr = "";
                                int i2 = 0;
                                while (i2 < delta) {
                                    whitespaceStr = String.valueOf(whitespaceStr) + ' ';
                                    ++i2;
                                }
                                htmlSB.append(whitespaceStr);
                                htmlSB.append("</TD>");
                            }
                            cursor = ann.getEnd();
                            htmlSB.append("<TD width=10 align=\"center\" colspan=" + ann.getCoveredText().length() + ">");
                            htmlSB.append("<");
                            htmlSB.append(this.iv_tdStyleArr[tdStyleIdx]);
                            htmlSB.append(">");
                            htmlSB.append(this.getDisplayValue(this.iv_nestedAnnTypeArr[nestIdx], ann));
                            htmlSB.append("</");
                            htmlSB.append(this.iv_tdStyleArr[tdStyleIdx]);
                            htmlSB.append(">");
                            htmlSB.append("</TD>");
                        }
                        htmlSB.append("</TR>");
                    }
                    if (++tdStyleIdx == this.iv_tdStyleArr.length) {
                        tdStyleIdx = 0;
                    }
                    ++nestIdx;
                }
                htmlSB.append("</BR>");
                htmlSB.append("</BR>");
                htmlSB.append("</TABLE>");
            }
            htmlSB.append("</BODY>");
            htmlSB.append("</HTML>");
            File f = new File(String.valueOf(this.iv_outputDir.getAbsolutePath()) + File.separator + "doc" + this.iv_count + ".html");
            f.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write(htmlSB.toString());
            bw.close();
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
        ++this.iv_count;
    }

    private String getDisplayValue(int annType, Annotation ann) throws IllegalAccessException, InvocationTargetException {
        Integer key = new Integer(annType);
        if (this.iv_getterMethMap.containsKey(key)) {
            Method meth = (Method)this.iv_getterMethMap.get(key);
            Object val = meth.invoke((Object)ann, null);
            if (val != null) {
                return String.valueOf(val);
            }
            return "";
        }
        String typeName = ann.getType().getShortName();
        return typeName.substring(0, typeName.indexOf("Annotation"));
    }

    private List arrangeIntoRows(Annotation tSpanAnn, List nestedAnnList) {
        int tSpanSize = tSpanAnn.getCoveredText().length();
        ArrayList<BitSet> maskAtRowList = new ArrayList<BitSet>();
        maskAtRowList.add(new BitSet(tSpanSize));
        ArrayList annotsAtRowList = new ArrayList();
        while (nestedAnnList.size() != 0) {
            Annotation ann = (Annotation)nestedAnnList.remove(0);
            BitSet annBitSet = new BitSet(tSpanSize);
            annBitSet.set(ann.getBegin() - tSpanAnn.getBegin(), ann.getEnd() - tSpanAnn.getBegin());
            int idx = 0;
            boolean rowFound = false;
            while (!rowFound) {
                BitSet trBitSet = (BitSet)maskAtRowList.get(idx);
                while (trBitSet.intersects(annBitSet)) {
                    if (++idx + 1 > maskAtRowList.size()) {
                        trBitSet = new BitSet(tSpanSize);
                        maskAtRowList.add(trBitSet);
                        continue;
                    }
                    trBitSet = (BitSet)maskAtRowList.get(idx);
                }
                trBitSet.or(annBitSet);
                rowFound = true;
            }
            List<Annotation> annList = null;
            if (idx + 1 > annotsAtRowList.size()) {
                annList = new ArrayList<Annotation>();
                annList.add(ann);
                annotsAtRowList.add(annList);
                continue;
            }
            annList = (List)annotsAtRowList.get(idx);
            annList.add(ann);
        }
        return annotsAtRowList;
    }

    private List getAnnotations(JCas jcas, int annType, int begin, int end) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        FSIterator itr = jcas.getJFSIndexRepository().getAnnotationIndex(annType).iterator();
        while (itr.hasNext()) {
            Annotation ann = (Annotation)itr.next();
            if (ann.getBegin() < begin || ann.getEnd() > end) continue;
            list.add(ann);
        }
        return list;
    }

    class AnnotationLengthComparator
    implements Comparator {
        AnnotationLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer len2;
            Annotation a1 = (Annotation)o1;
            Annotation a2 = (Annotation)o2;
            Integer len1 = new Integer(a1.getCoveredText().length());
            if (len1.equals(len2 = new Integer(a2.getCoveredText().length()))) {
                if (a1.getBegin() < a2.getBegin()) {
                    return -1;
                }
                if (a1.getBegin() > a2.getBegin()) {
                    return 1;
                }
                if (a1.getEnd() < a2.getEnd()) {
                    return 1;
                }
                if (a1.getEnd() > a2.getEnd()) {
                    return -1;
                }
                return 0;
            }
            return len1.compareTo(len2);
        }
    }

    class AnnotationPositionComparator
    implements Comparator {
        AnnotationPositionComparator() {
        }

        public int compare(Object o1, Object o2) {
            Annotation a1 = (Annotation)o1;
            Annotation a2 = (Annotation)o2;
            if (a1.getBegin() < a2.getBegin()) {
                return -1;
            }
            if (a1.getBegin() > a2.getBegin()) {
                return 1;
            }
            if (a1.getEnd() < a2.getEnd()) {
                return 1;
            }
            if (a1.getEnd() > a2.getEnd()) {
                return -1;
            }
            return 0;
        }
    }
}

