/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.cc;

import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class NormalizedFilesInDirectoryCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    File iv_outputDirectory;

    @Override
    public void initialize() throws ResourceInitializationException {
        String outputDirectoryName = (String)this.getConfigParameterValue(PARAM_OUTPUTDIR);
        this.iv_outputDirectory = new File(outputDirectoryName);
        if (!this.iv_outputDirectory.exists() || !this.iv_outputDirectory.isDirectory()) {
            throw new ResourceInitializationException(new Exception("Parameter setting 'OutputDirectory' does not point to an existing directory."));
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            StringBuffer normalizedText = new StringBuffer();
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator tokenItr = indexes.getAnnotationIndex(WordToken.type).iterator();
            while (tokenItr.hasNext()) {
                WordToken token = (WordToken)tokenItr.next();
                String tokenNormText = token.getCanonicalForm();
                normalizedText.append(String.valueOf(tokenNormText) + " ");
            }
            String documentID = DocumentIDAnnotationUtil.getDocumentID(jcas);
            this.writeToFile(documentID, normalizedText.toString());
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }

    private void writeToFile(String documentID, String documentText) throws IOException {
        File outputFile = new File(this.iv_outputDirectory, documentID);
        outputFile.createNewFile();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        ((OutputStream)out).write(documentText.getBytes());
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }
}

