/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.cr;

import edu.mayo.bmi.uima.core.resource.FileResource;
import edu.mayo.bmi.uima.core.resource.JdbcConnectionResource;
import edu.mayo.bmi.uima.core.type.DocumentID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class JdbcCollectionReader
extends CollectionReader_ImplBase {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String PARAM_SQL = "SqlStatement";
    public static final String PARAM_DOCTEXT_COL = "DocTextColName";
    public static final String PARAM_DB_CONN_RESRC = "DbConnResrcName";
    public static final String PARAM_DOCID_COLS = "DocIdColNames";
    public static final String PARAM_DOCID_DELIMITER = "DocIdDelimiter";
    public static final String PARAM_VALUE_FILE_RESRC = "ValueFileResrcName";
    private PreparedStatement queryPrepStmt;
    private ResultSet rs;
    private String docTextColName;
    private int docColType;
    private String docColTypeName;
    private String[] docIdColNames = null;
    private String docIdDelimiter = "_";
    private int totalRowCount = 0;
    private int currRowCount = 0;
    private List[] prepStmtValArr = null;
    private int prepStmtValArrIdx = 0;
    private boolean usePrepStmtVals = false;

    @Override
    public void initialize() throws ResourceInitializationException {
        try {
            String sql = (String)this.getConfigParameterValue(PARAM_SQL);
            this.docTextColName = (String)this.getConfigParameterValue(PARAM_DOCTEXT_COL);
            String resrcName = (String)this.getConfigParameterValue(PARAM_DB_CONN_RESRC);
            JdbcConnectionResource resrc = (JdbcConnectionResource)this.getUimaContext().getResourceObject(resrcName);
            this.docIdColNames = (String[])this.getConfigParameterValue(PARAM_DOCID_COLS);
            if (this.getConfigParameterValue(PARAM_DOCID_DELIMITER) != null) {
                this.docIdDelimiter = (String)this.getConfigParameterValue(PARAM_DOCID_DELIMITER);
            }
            Connection conn = resrc.getConnection();
            this.queryPrepStmt = conn.prepareStatement(sql);
            String fileResrcName = (String)this.getConfigParameterValue(PARAM_VALUE_FILE_RESRC);
            if (fileResrcName != null && fileResrcName.trim().length() > 0) {
                FileResource fileResrc = (FileResource)this.getUimaContext().getResourceObject(fileResrcName);
                if (fileResrc != null) {
                    this.loadValueFile(fileResrc.getFile());
                    this.usePrepStmtVals = true;
                } else {
                    throw new Exception("Failed to get " + fileResrcName + " from ResourceManager");
                }
            }
            this.totalRowCount = this.getRowCount(conn, sql);
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    private void loadValueFile(File valueFile) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(valueFile));
        String line = br.readLine();
        while (line != null) {
            lineList.add(line);
            line = br.readLine();
        }
        br.close();
        this.prepStmtValArr = new List[lineList.size()];
        int i = 0;
        while (i < lineList.size()) {
            String currLine = (String)lineList.get(i);
            ArrayList<String> valList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(currLine, "\t");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                valList.add(token);
            }
            this.prepStmtValArr[i] = valList;
            ++i;
        }
        this.logger.info("Loaded " + lineList.size() + " lines from value file: " + valueFile.getAbsolutePath());
    }

    private int getRowCount(Connection conn, String querySql) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(*) ");
        int idx = querySql.indexOf("FROM");
        sb.append(querySql.subSequence(idx, querySql.length()));
        PreparedStatement cntStmt = conn.prepareStatement(sb.toString());
        if (this.usePrepStmtVals) {
            int totalCnt = 0;
            int i = 0;
            while (i < this.prepStmtValArr.length) {
                List valList = this.prepStmtValArr[i];
                this.setPrepStmtValues(cntStmt, valList);
                ResultSet rs = cntStmt.executeQuery();
                rs.next();
                totalCnt += rs.getInt(1);
                ++i;
            }
            return totalCnt;
        }
        ResultSet rs = cntStmt.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    private void setPrepStmtValues(PreparedStatement prepStmt, List valList) throws SQLException {
        prepStmt.clearParameters();
        int i = 0;
        while (i < valList.size()) {
            Object valObj = valList.get(i);
            prepStmt.setObject(i + 1, valObj);
            ++i;
        }
    }

    @Override
    public void getNext(CAS cas) throws IOException, CollectionException {
        ++this.currRowCount;
        try {
            String document = null;
            if (this.docColType == 1 || this.docColType == 12) {
                document = this.rs.getString(this.docTextColName);
            } else if (this.docColType == 2005) {
                document = this.convertToString(this.rs.getClob(this.docTextColName));
            } else {
                throw new Exception("Unsupported document text column type: " + this.docColTypeName);
            }
            try {
                if (this.getCasInitializer() != null) {
                    StringReader reader = new StringReader(document);
                    this.getCasInitializer().initializeCas(reader, cas);
                } else {
                    cas.getJCas().setDocumentText(document);
                }
                DocumentID docIdAnnot = new DocumentID(cas.getJCas());
                docIdAnnot.setDocumentID(this.getDocumentID(this.rs));
                docIdAnnot.addToIndexes();
                this.logger.info("Reading document with ID=" + docIdAnnot.getDocumentID());
            }
            catch (Exception e) {
                this.logger.error("CasInitializer failed to process document: ");
                this.logger.error(document);
                throw e;
            }
        }
        catch (Exception e) {
            throw new CollectionException(e);
        }
    }

    private String getDocumentID(ResultSet rs) throws SQLException {
        if (this.docIdColNames != null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.docIdColNames.length) {
                String val = rs.getObject(this.docIdColNames[i]).toString();
                sb.append(val);
                if (i != this.docIdColNames.length - 1) {
                    sb.append(this.docIdDelimiter);
                }
                ++i;
            }
            return sb.toString();
        }
        return String.valueOf(this.currRowCount);
    }

    private String convertToString(Clob clob) throws SQLException, IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(clob.getCharacterStream());
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append('\n');
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    @Override
    public boolean hasNext() throws IOException, CollectionException {
        try {
            boolean hasAnotherRow;
            if (this.rs == null) {
                if (this.usePrepStmtVals) {
                    List valList = this.prepStmtValArr[this.prepStmtValArrIdx];
                    this.setPrepStmtValues(this.queryPrepStmt, valList);
                    ++this.prepStmtValArrIdx;
                }
                this.rs = this.queryPrepStmt.executeQuery();
                ResultSetMetaData rsMetaData = this.rs.getMetaData();
                int colIdx = this.rs.findColumn(this.docTextColName);
                this.docColType = rsMetaData.getColumnType(colIdx);
                this.docColTypeName = rsMetaData.getColumnTypeName(1);
            }
            if (!(hasAnotherRow = this.rs.next())) {
                this.rs.close();
            }
            if (this.usePrepStmtVals && !hasAnotherRow && this.prepStmtValArrIdx < this.prepStmtValArr.length) {
                this.rs = null;
                return this.hasNext();
            }
            return hasAnotherRow;
        }
        catch (Exception e) {
            throw new CollectionException(e);
        }
    }

    @Override
    public Progress[] getProgress() {
        ProgressImpl p = new ProgressImpl(this.currRowCount, this.totalRowCount, "entities");
        return new Progress[]{p};
    }

    @Override
    public void close() throws IOException {
        try {
            this.queryPrepStmt.close();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

