/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.core.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class FileLocator {
    public static File locateFile(String location) throws FileNotFoundException {
        try {
            return FileLocator.locateOnClasspath(location);
        }
        catch (Exception e) {
            return FileLocator.locateExplicitly(location);
        }
    }

    private static File locateOnClasspath(String cpLocation) throws FileNotFoundException, URISyntaxException {
        ClassLoader cl = FileLocator.class.getClassLoader();
        URL indexUrl = cl.getResource(cpLocation);
        if (indexUrl == null) {
            throw new FileNotFoundException(cpLocation);
        }
        URI indexUri = new URI(indexUrl.toExternalForm());
        File f = new File(indexUri);
        return f;
    }

    private static File locateExplicitly(String explicitLocation) throws FileNotFoundException {
        File f = new File(explicitLocation);
        if (!f.exists()) {
            throw new FileNotFoundException(explicitLocation);
        }
        return f;
    }
}

