/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.drugner;

import edu.mayo.bmi.fsm.output.DateToken;
import edu.mayo.bmi.uima.cdt.type.DateAnnotation;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.drugner.DrugModel;
import edu.mayo.bmi.uima.drugner.elements.AssociatedPrimaryCodeElement;
import edu.mayo.bmi.uima.drugner.elements.ConfidenceScoreElement;
import edu.mayo.bmi.uima.drugner.elements.DosageElement;
import edu.mayo.bmi.uima.drugner.elements.DrugChangeStatusElement;
import edu.mayo.bmi.uima.drugner.elements.DurationElement;
import edu.mayo.bmi.uima.drugner.elements.FormElement;
import edu.mayo.bmi.uima.drugner.elements.FrequencyElement;
import edu.mayo.bmi.uima.drugner.elements.FrequencyUnitElement;
import edu.mayo.bmi.uima.drugner.elements.RouteElement;
import edu.mayo.bmi.uima.drugner.elements.StartDateElement;
import edu.mayo.bmi.uima.drugner.elements.StrengthElement;
import edu.mayo.bmi.uima.drugner.elements.TextMentionElement;
import edu.mayo.bmi.uima.drugner.type.DosagesAnnotation;
import edu.mayo.bmi.uima.drugner.type.DrugChangeStatusAnnotation;
import edu.mayo.bmi.uima.drugner.type.DurationAnnotation;
import edu.mayo.bmi.uima.drugner.type.FormAnnotation;
import edu.mayo.bmi.uima.drugner.type.FrequencyAnnotation;
import edu.mayo.bmi.uima.drugner.type.FrequencyUnitAnnotation;
import edu.mayo.bmi.uima.drugner.type.RouteAnnotation;
import edu.mayo.bmi.uima.drugner.type.StrengthAnnotation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;

public class DrugMention
implements DrugModel {
    public TextMentionElement drugMentionText;
    public AssociatedPrimaryCodeElement associatedCodePrimary;
    public AssociatedPrimaryCodeElement associatedCodeSecondary;
    public StartDateElement startDate;
    public DateToken endDate;
    public DosageElement dosage;
    public FrequencyElement frequency;
    public FrequencyUnitElement frequencyUnit;
    public DurationElement duration;
    public RouteElement route;
    public StrengthElement strength;
    public FormElement form;
    public DrugChangeStatusElement changeStatus;
    public ConfidenceScoreElement confidence;
    public boolean findMaxValue = true;
    private static final Pattern lookForAlpha = Pattern.compile("[a-zA-Z]+");
    private static final Pattern lookForPercent = Pattern.compile("[%]");
    private double holdLargestPeriod = -1.0;

    public DrugMention(JCas jcas, int beginPos, int endPos) {
        FSIterator drugStatusTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DrugChangeStatusAnnotation.type, beginPos, endPos);
        while (drugStatusTokenItr.hasNext()) {
            DrugChangeStatusAnnotation focusToken = (DrugChangeStatusAnnotation)drugStatusTokenItr.next();
            String localStatus = null;
            localStatus = this.findDrugChangeStatusElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localStatus == null) {
                this.changeStatus = new DrugChangeStatusElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setDrugChangeStatusElement(localStatus, focusToken.getBegin(), focusToken.getEnd());
        }
        if (this.changeStatus != null && (this.changeStatus.getDrugChangeStatus().equals("increasefrom") || this.changeStatus.getDrugChangeStatus().equals("decrease"))) {
            this.findMaxValue = false;
        }
        FSIterator dateTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DateAnnotation.type, beginPos, endPos);
        while (dateTokenItr.hasNext()) {
            DateAnnotation focusToken = (DateAnnotation)dateTokenItr.next();
            String localDate = null;
            localDate = this.findStartDateElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localDate == null) {
                this.startDate = new StartDateElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setStartDateElement(localDate, focusToken.getBegin(), focusToken.getEnd());
        }
        FSIterator doseTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DosagesAnnotation.type, beginPos, endPos);
        while (doseTokenItr.hasNext()) {
            DosagesAnnotation focusToken = (DosagesAnnotation)doseTokenItr.next();
            String localDose = null;
            localDose = this.findDosageElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localDose == null) {
                this.dosage = new DosageElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setDosageElement(localDose, focusToken.getBegin(), focusToken.getEnd());
        }
        FSIterator frequencyTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FrequencyAnnotation.type, beginPos, endPos);
        while (frequencyTokenItr.hasNext()) {
            FrequencyAnnotation focusToken = (FrequencyAnnotation)frequencyTokenItr.next();
            String localFreq = null;
            localFreq = this.findFrequencyElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localFreq == null) {
                this.frequency = new FrequencyElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            if (this.frequency != null && localFreq != null && this.frequency.getFrequencyMention().compareTo("") != 0 && localFreq.compareTo("") != 0 && this.parseIntValue(localFreq) > this.parseIntValue(this.frequency.getFrequencyMention()) && this.findMaxValue) {
                this.setFrequencyElement(localFreq, focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setFrequencyElement(localFreq, focusToken.getBegin(), focusToken.getEnd());
        }
        FSIterator frequencyUnitTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FrequencyUnitAnnotation.type, beginPos, endPos);
        while (frequencyUnitTokenItr.hasNext()) {
            FrequencyUnitAnnotation focusToken = (FrequencyUnitAnnotation)frequencyUnitTokenItr.next();
            String localFreq = null;
            localFreq = this.findFrequencyUnitElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localFreq == null) {
                this.frequencyUnit = new FrequencyUnitElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            if (this.frequencyUnit != null || !this.findMaxValue) continue;
            this.setFrequencyUnitElement(localFreq, focusToken.getBegin(), focusToken.getEnd());
        }
        FSIterator dosageTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, StrengthAnnotation.type, beginPos, endPos);
        while (dosageTokenItr.hasNext()) {
            StrengthAnnotation focusToken = (StrengthAnnotation)dosageTokenItr.next();
            String localStrength = null;
            localStrength = this.findStrengthElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localStrength == null) {
                this.strength = new StrengthElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            if (this.strength != null) {
                int spacePosition = this.strength.getStrengthMention().indexOf(" ");
                int spacePos = localStrength.indexOf(" ");
                if (spacePosition > 0 && spacePos > 0 && this.parseDoubleValue(this.strength.getStrengthMention().substring(0, spacePosition)) < this.parseDoubleValue(localStrength.substring(0, localStrength.indexOf(" "))) && this.findMaxValue) {
                    this.setStrengthElement(localStrength, focusToken.getBegin(), focusToken.getEnd());
                    continue;
                }
                String stringRange = this.strength.getStrengthMention();
                int hyphPosition = 0;
                if (stringRange.length() <= 0 || stringRange.indexOf(45) <= 0) continue;
                hyphPosition = stringRange.indexOf(45);
                Double firstValue = new Double(this.parseDoubleValue(stringRange.subSequence(0, hyphPosition)));
                Double secondValue = new Double(this.parseDoubleValue(stringRange.substring(hyphPosition + 2)));
                if (firstValue >= secondValue && this.findMaxValue) {
                    this.setStrengthElement(firstValue.toString(), focusToken.getBegin(), focusToken.getEnd());
                    continue;
                }
                this.setStrengthElement(firstValue.toString(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            if (localStrength.length() > 0 && localStrength.indexOf(45) > 0) {
                int hyphPosition = 0;
                hyphPosition = localStrength.indexOf(45);
                Double firstValue = new Double(this.parseDoubleValue(localStrength.subSequence(0, hyphPosition)));
                Double secondValue = new Double(this.parseDoubleValue(localStrength.substring(hyphPosition + 2)));
                if (firstValue >= secondValue && this.findMaxValue) {
                    this.setStrengthElement(firstValue.toString(), focusToken.getBegin(), focusToken.getEnd());
                } else {
                    this.setStrengthElement(firstValue.toString(), focusToken.getBegin(), focusToken.getEnd());
                }
                this.setStrengthElement(localStrength, focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setStrengthElement(localStrength, focusToken.getBegin(), focusToken.getEnd());
        }
        FSIterator formTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FormAnnotation.type, beginPos, endPos);
        while (formTokenItr.hasNext()) {
            FormAnnotation focusToken = (FormAnnotation)formTokenItr.next();
            String localForm = null;
            localForm = this.findFormElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localForm == null) {
                this.form = new FormElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setFormElement(localForm, focusToken.getBegin(), focusToken.getEnd());
        }
        FSIterator routeTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, RouteAnnotation.type, beginPos, endPos);
        while (routeTokenItr.hasNext()) {
            RouteAnnotation focusToken = (RouteAnnotation)routeTokenItr.next();
            String localRoute = null;
            localRoute = this.findRouteElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localRoute == null) {
                this.route = new RouteElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setRouteElement(localRoute, focusToken.getBegin(), focusToken.getEnd());
        }
        FSIterator durationTokenItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DurationAnnotation.type, beginPos, endPos);
        while (durationTokenItr.hasNext()) {
            DurationAnnotation focusToken = (DurationAnnotation)durationTokenItr.next();
            String localDuration = null;
            localDuration = this.findDurationElement(jcas, focusToken.getBegin(), focusToken.getEnd());
            if (localDuration == null) {
                this.duration = new DurationElement(focusToken.getCoveredText(), focusToken.getBegin(), focusToken.getEnd());
                continue;
            }
            this.setDurationElement(localDuration, focusToken.getBegin(), focusToken.getEnd());
        }
    }

    @Override
    public void setPrimaryAssociatedCodeElement(String name, int beginOffset, int endOffset) {
        this.associatedCodePrimary = new AssociatedPrimaryCodeElement(name, beginOffset, endOffset);
    }

    @Override
    public void setSecondaryAssociatedCodeElement(String name, int beginOffset, int endOffset) {
        this.associatedCodeSecondary = new AssociatedPrimaryCodeElement(name, beginOffset, endOffset);
    }

    @Override
    public void setStartDateElement(String date, int beginOffset, int endOffset) {
        this.startDate = new StartDateElement(date, beginOffset, endOffset);
    }

    @Override
    public void setEndDateElement(String name, int beginOffset, int endOffset) {
    }

    @Override
    public void setDosageElement(String dose, int beginOffset, int endOffset) {
        this.dosage = new DosageElement(dose, beginOffset, endOffset);
    }

    @Override
    public void setFrequencyElement(String name, int beginOffset, int endOffset) {
        this.frequency = new FrequencyElement(name, beginOffset, endOffset);
    }

    @Override
    public void setFrequencyUnitElement(String name, int beginOffset, int endOffset) {
        this.frequencyUnit = new FrequencyUnitElement(name, beginOffset, endOffset);
    }

    @Override
    public void setFormElement(String name, int beginOffset, int endOffset) {
        this.form = new FormElement(name, beginOffset, endOffset);
    }

    @Override
    public void setDurationElement(String name, int beginOffset, int endOffset) {
        this.duration = new DurationElement(name, beginOffset, endOffset);
    }

    @Override
    public void setRouteElement(String name, int beginOffset, int endOffset) {
        this.route = new RouteElement(name, beginOffset, endOffset);
    }

    @Override
    public void setDrugChangeStatusElement(String name, int beginOffset, int endOffset) {
        this.changeStatus = new DrugChangeStatusElement(name, beginOffset, endOffset);
    }

    @Override
    public void setConfidenceScoreElement(double score, int beginOffset, int endOffset) {
        this.confidence = new ConfidenceScoreElement(score, beginOffset, endOffset);
    }

    @Override
    public void setStrengthElement(String name, int beginOffset, int endOffset) {
        this.strength = new StrengthElement(name, beginOffset, endOffset);
    }

    @Override
    public String getPrimaryAssociatedCodeElement() {
        if (this.associatedCodePrimary != null) {
            return this.associatedCodePrimary.getCuiCode();
        }
        return null;
    }

    @Override
    public String getSecondaryAssociatedCodeElement() {
        if (this.associatedCodeSecondary != null) {
            return this.associatedCodeSecondary.getCuiCode();
        }
        return null;
    }

    @Override
    public String getStartDateElement() {
        if (this.startDate != null) {
            return this.startDate.getDate();
        }
        return "";
    }

    @Override
    public String getEndDateElement() {
        return this.endDate.toString();
    }

    @Override
    public String getDosageElement() {
        if (this.dosage != null) {
            return this.dosage.getDosage();
        }
        return "1.0";
    }

    @Override
    public String getFrequencyElement() {
        if (this.frequency != null) {
            return this.frequency.getFrequencyMention();
        }
        return "1.0";
    }

    @Override
    public String getFrequencyUnitElement() {
        if (this.frequencyUnit != null) {
            return this.frequencyUnit.getFrequencyUnitMention();
        }
        return null;
    }

    @Override
    public String getFormElement() {
        if (this.form != null) {
            return this.form.getFormMention();
        }
        return null;
    }

    @Override
    public String getDurationElement() {
        if (this.duration != null) {
            return this.duration.getDuration();
        }
        return null;
    }

    @Override
    public String getRouteElement() {
        if (this.route != null) {
            return this.route.getRouteMention();
        }
        return null;
    }

    @Override
    public String getDrugChangeStatusElement() {
        if (this.changeStatus != null) {
            return this.changeStatus.getDrugChangeStatus();
        }
        return "noChange";
    }

    @Override
    public String getStrengthElement() {
        if (this.strength != null) {
            return this.strength.getStrengthMention();
        }
        return "";
    }

    @Override
    public double getConfidenceScoreElement() {
        if (this.confidence != null) {
            return this.confidence.getConfidenceScoreElement();
        }
        return 0.0;
    }

    private String findStartDateElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DateAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            DateAnnotation da = (DateAnnotation)firItr.next();
            if (da.getBegin() != beginOffset) continue;
            return da.getCoveredText();
        }
        return null;
    }

    private String findEndDateElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsInSpanIterator(jcas, DateAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            DateAnnotation da = (DateAnnotation)firItr.next();
            if (da.getBegin() != beginOffset) continue;
            return da.getCoveredText();
        }
        return null;
    }

    private String findDosageElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DosagesAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            DosagesAnnotation da = (DosagesAnnotation)firItr.next();
            if (da.getBegin() != beginOffset) continue;
            int posSpace = da.getCoveredText().lastIndexOf(32);
            int posHyph = da.getCoveredText().lastIndexOf(45);
            String lastTerm = da.getCoveredText();
            int ofSpace = da.getCoveredText().indexOf("of");
            if (ofSpace > 0) {
                lastTerm = da.getCoveredText().substring(0, ofSpace).trim();
            }
            if (lastTerm.compareToIgnoreCase("one-half-tablet") == 0 || lastTerm.compareToIgnoreCase("one-half") == 0 || lastTerm.compareToIgnoreCase("1/2") == 0 || lastTerm.compareToIgnoreCase("half-tablet") == 0) {
                return "0.5";
            }
            if (lastTerm.compareToIgnoreCase("one-and-a-half") == 0) {
                return "1.5";
            }
            if (lastTerm.compareToIgnoreCase("one-quarter") == 0 || lastTerm.compareToIgnoreCase("one-fourth") == 0 || lastTerm.compareToIgnoreCase("1/4") == 0 || lastTerm.compareToIgnoreCase("a-fourth") == 0) {
                return ".25";
            }
            if (lastTerm.compareToIgnoreCase("one-third") == 0 || lastTerm.compareToIgnoreCase("thirds") == 0 || lastTerm.compareToIgnoreCase("1/3") == 0 || lastTerm.compareToIgnoreCase("a-third") == 0) {
                return ".33";
            }
            if (posSpace > 0) {
                lastTerm = lastTerm.substring(posSpace + 1);
            } else if (posHyph > 0) {
                lastTerm = lastTerm.substring(posHyph + 1);
            }
            return this.convertFromTextToNum(lastTerm);
        }
        return null;
    }

    private String findFormElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FormAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            FormAnnotation da = (FormAnnotation)firItr.next();
            if (da.getBegin() != beginOffset) continue;
            if (da.getCoveredText().compareToIgnoreCase("aerosol") == 0 || da.getCoveredText().compareToIgnoreCase("aerosols") == 0) {
                return "aerosol";
            }
            if (da.getCoveredText().compareToIgnoreCase("cream") == 0 || da.getCoveredText().compareToIgnoreCase("creams") == 0) {
                return "cream";
            }
            if (da.getCoveredText().compareToIgnoreCase("elixir") == 0 || da.getCoveredText().compareToIgnoreCase("elixirs") == 0) {
                return "elixir";
            }
            if (da.getCoveredText().compareToIgnoreCase("emulsion") == 0 || da.getCoveredText().compareToIgnoreCase("emulutions") == 0) {
                return "emulsion";
            }
            if (da.getCoveredText().compareToIgnoreCase("enema") == 0 || da.getCoveredText().compareToIgnoreCase("ememas") == 0) {
                return "enema";
            }
            if (da.getCoveredText().compareToIgnoreCase("gel") == 0 || da.getCoveredText().compareToIgnoreCase("gels") == 0) {
                return "gel";
            }
            if (da.getCoveredText().compareToIgnoreCase("implant") == 0 || da.getCoveredText().compareToIgnoreCase("implants") == 0) {
                return "implant";
            }
            if (da.getCoveredText().compareToIgnoreCase("inhalant") == 0 || da.getCoveredText().compareToIgnoreCase("inhalants") == 0) {
                return "inhalant";
            }
            if (da.getCoveredText().compareToIgnoreCase("injection") == 0 || da.getCoveredText().compareToIgnoreCase("injections") == 0) {
                return "injection";
            }
            if (da.getCoveredText().compareToIgnoreCase("liquid") == 0 || da.getCoveredText().compareToIgnoreCase("liquids") == 0) {
                return "liquid";
            }
            if (da.getCoveredText().compareToIgnoreCase("lotion") == 0 || da.getCoveredText().compareToIgnoreCase("lotions") == 0) {
                return "lotion";
            }
            if (da.getCoveredText().compareToIgnoreCase("lozenge") == 0 || da.getCoveredText().compareToIgnoreCase("lozenges") == 0) {
                return "lozenge";
            }
            if (da.getCoveredText().compareToIgnoreCase("ointment") == 0 || da.getCoveredText().compareToIgnoreCase("ointments") == 0) {
                return "ointment";
            }
            if (da.getCoveredText().compareToIgnoreCase("patch") == 0 || da.getCoveredText().compareToIgnoreCase("patches") == 0) {
                return "patch";
            }
            if (da.getCoveredText().compareToIgnoreCase("pill") == 0 || da.getCoveredText().compareToIgnoreCase("pills") == 0) {
                return "pill";
            }
            if (da.getCoveredText().compareToIgnoreCase("powder") == 0 || da.getCoveredText().compareToIgnoreCase("powders") == 0) {
                return "powder";
            }
            if (da.getCoveredText().compareToIgnoreCase("shampoo") == 0 || da.getCoveredText().compareToIgnoreCase("shampoos") == 0) {
                return "shampoo";
            }
            if (da.getCoveredText().compareToIgnoreCase("soap") == 0 || da.getCoveredText().compareToIgnoreCase("soaps") == 0) {
                return "soap";
            }
            if (da.getCoveredText().compareToIgnoreCase("solution") == 0 || da.getCoveredText().compareToIgnoreCase("solutions") == 0 || da.getCoveredText().compareToIgnoreCase("soln") == 0 || da.getCoveredText().compareToIgnoreCase("concentrate") == 0 || da.getCoveredText().compareToIgnoreCase("concentrat") == 0 || da.getCoveredText().compareToIgnoreCase("conc") == 0 || da.getCoveredText().compareToIgnoreCase("solu") == 0) {
                return "solution";
            }
            if (da.getCoveredText().compareToIgnoreCase("spray") == 0 || da.getCoveredText().compareToIgnoreCase("sprays") == 0 || da.getCoveredText().compareToIgnoreCase("nebulizers") == 0 || da.getCoveredText().compareToIgnoreCase("nebulizer") == 0) {
                return "spray";
            }
            if (da.getCoveredText().compareToIgnoreCase("suppository") == 0 || da.getCoveredText().compareToIgnoreCase("suppositories") == 0) {
                return "suppository";
            }
            if (da.getCoveredText().compareToIgnoreCase("syringe") == 0 || da.getCoveredText().compareToIgnoreCase("syrnge") == 0) {
                return "syringe";
            }
            if (da.getCoveredText().compareToIgnoreCase("syrup") == 0 || da.getCoveredText().compareToIgnoreCase("syrups") == 0) {
                return "syrup";
            }
            if (da.getCoveredText().compareToIgnoreCase("tablet") == 0 || da.getCoveredText().compareToIgnoreCase("tablets") == 0 || da.getCoveredText().compareToIgnoreCase("tab") == 0 || da.getCoveredText().compareToIgnoreCase("tabs") == 0) {
                return "tablet";
            }
            if (da.getCoveredText().compareToIgnoreCase("capsule") == 0 || da.getCoveredText().compareToIgnoreCase("capsule") == 0 || da.getCoveredText().compareToIgnoreCase("capsules") == 0 || da.getCoveredText().compareToIgnoreCase("cap") == 0 || da.getCoveredText().compareToIgnoreCase("caps") == 0) {
                return "capsule";
            }
            return null;
        }
        return null;
    }

    private String findFrequencyElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FrequencyAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            int lastSpace;
            FrequencyAnnotation da = (FrequencyAnnotation)firItr.next();
            if (da.getBegin() != beginOffset) continue;
            int posSpace = da.getCoveredText().indexOf(32);
            int posHyph = da.getCoveredText().indexOf(45);
            int lastPosHyph = da.getCoveredText().lastIndexOf(45);
            String firstTerm = da.getCoveredText();
            String lastTerm = da.getCoveredText();
            if (posSpace > 0) {
                firstTerm = da.getCoveredText().substring(0, posSpace);
            } else if (posHyph > 0) {
                firstTerm = firstTerm.substring(0, posHyph);
            }
            if (lastPosHyph > 0) {
                lastTerm = lastTerm.substring(lastPosHyph + 1, lastTerm.length());
            }
            if ((lastSpace = lastTerm.lastIndexOf(32)) > 0) {
                lastTerm = lastTerm.substring(0, lastSpace);
            }
            while ((lastSpace = lastTerm.lastIndexOf(32)) > 1) {
                lastTerm = lastTerm.substring(lastSpace + 1);
            }
            String returnFirstValue = this.convertFromTextToNum(firstTerm);
            String returnLastValue = this.convertFromTextToNum(lastTerm);
            try {
                if (new Double(returnFirstValue).intValue() < new Double(returnLastValue).intValue() && this.findMaxValue) {
                    return returnLastValue;
                }
                return returnFirstValue;
            }
            catch (NumberFormatException nfe) {
                return returnFirstValue;
            }
        }
        return null;
    }

    private String findFrequencyUnitElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FrequencyUnitAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            FrequencyUnitAnnotation da = (FrequencyUnitAnnotation)firItr.next();
            if (da.getBegin() != beginOffset || !((double)da.getPeriod() > this.holdLargestPeriod)) continue;
            this.holdLargestPeriod = da.getPeriod();
            int posHyph = da.getCoveredText().lastIndexOf(45);
            String lastTerm = da.getCoveredText();
            int szString = lastTerm.toString().length();
            if (posHyph > 0) {
                lastTerm = lastTerm.substring(posHyph + 1, szString);
            }
            if ((double)da.getPeriod() == 1.0) {
                return "day";
            }
            if ((double)da.getPeriod() == 2.0) {
                if (this.frequency != null && this.frequency.getBeginOffset() != beginOffset && this.frequency.getEndOffset() != endOffset) {
                    if ((this.dosage == null || this.dosage != null && this.convertFromTextToNum(this.dosage.getDosage()).compareTo("1") == 0 && this.dosage.getBeginOffset() != beginOffset && this.dosage.getEndOffset() != endOffset) && this.changeStatus != null && this.changeStatus.getDrugChangeStatus().compareTo("change") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decrease") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decreasefrom") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increase") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increasefrom") != 0) {
                        this.setFrequencyElement(this.frequency.getFrequencyMention(), this.frequency.getBeginOffset(), this.frequency.getEndOffset());
                    } else {
                        double updateFreq = new Double(this.frequency.getFrequencyMention()) * 2.0;
                        this.setFrequencyElement(String.valueOf(updateFreq), beginOffset, endOffset);
                    }
                } else {
                    this.setFrequencyElement("2.0", beginOffset, endOffset);
                }
                return "day";
            }
            if ((double)da.getPeriod() == 3.0) {
                if (this.frequency != null && this.frequency.getBeginOffset() != beginOffset && this.frequency.getEndOffset() != endOffset) {
                    if ((this.dosage == null || this.dosage != null && this.convertFromTextToNum(this.dosage.getDosage()).compareTo("1") == 0 && this.dosage.getBeginOffset() != beginOffset && this.dosage.getEndOffset() != endOffset) && this.changeStatus != null && this.changeStatus.getDrugChangeStatus().compareTo("change") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decrease") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decreasefrom") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increase") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increasefrom") != 0) {
                        this.setFrequencyElement(this.frequency.getFrequencyMention(), this.frequency.getBeginOffset(), this.frequency.getEndOffset());
                    } else {
                        double updateFreq = new Double(this.frequency.getFrequencyMention()) * 3.0;
                        this.setFrequencyElement(String.valueOf(updateFreq), beginOffset, endOffset);
                    }
                } else {
                    this.setFrequencyElement("3.0", beginOffset, endOffset);
                }
                return "day";
            }
            if ((double)da.getPeriod() == 4.0) {
                if (this.frequency != null && this.frequency.getBeginOffset() != beginOffset && this.frequency.getEndOffset() != endOffset) {
                    if ((this.dosage == null || this.dosage != null && this.convertFromTextToNum(this.dosage.getDosage()).compareTo("1") == 0 && this.dosage.getBeginOffset() != beginOffset && this.dosage.getEndOffset() != endOffset) && this.changeStatus != null && this.changeStatus.getDrugChangeStatus().compareTo("change") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decrease") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decreasefrom") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increase") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increasefrom") != 0) {
                        this.setFrequencyElement(this.frequency.getFrequencyMention(), this.frequency.getBeginOffset(), this.frequency.getEndOffset());
                    } else {
                        double updateFreq = new Double(this.frequency.getFrequencyMention()) * 4.0;
                        this.setFrequencyElement(String.valueOf(updateFreq), beginOffset, endOffset);
                    }
                } else {
                    this.setFrequencyElement("4.0", beginOffset, endOffset);
                }
                return "day";
            }
            if ((double)da.getPeriod() == 5.0) {
                if (this.frequency != null && this.frequency.getBeginOffset() != beginOffset && this.frequency.getEndOffset() != endOffset) {
                    if ((this.dosage == null || this.dosage != null && this.convertFromTextToNum(this.dosage.getDosage()).compareTo("1") == 0 && this.dosage.getBeginOffset() != beginOffset && this.dosage.getEndOffset() != endOffset) && this.changeStatus != null && this.changeStatus.getDrugChangeStatus().compareTo("change") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decrease") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decreasefrom") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increase") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increasefrom") != 0) {
                        this.setFrequencyElement(this.frequency.getFrequencyMention(), this.frequency.getBeginOffset(), this.frequency.getEndOffset());
                    } else {
                        double updateFreq = new Double(this.frequency.getFrequencyMention()) * 5.0;
                        this.setFrequencyElement(String.valueOf(updateFreq), beginOffset, endOffset);
                    }
                } else {
                    this.setFrequencyElement("5.0", beginOffset, endOffset);
                }
                return "day";
            }
            if ((double)da.getPeriod() == 6.0) {
                if (this.frequency != null && this.frequency.getBeginOffset() != beginOffset && this.frequency.getEndOffset() != endOffset) {
                    if ((this.dosage == null || this.dosage != null && this.convertFromTextToNum(this.dosage.getDosage()).compareTo("1") == 0 && this.dosage.getBeginOffset() != beginOffset && this.dosage.getEndOffset() != endOffset) && this.changeStatus != null && this.changeStatus.getDrugChangeStatus().compareTo("change") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decrease") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decreasefrom") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increase") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increasefrom") != 0) {
                        this.setFrequencyElement(this.frequency.getFrequencyMention(), this.frequency.getBeginOffset(), this.frequency.getEndOffset());
                    } else {
                        double updateFreq = new Double(this.frequency.getFrequencyMention()) * 6.0;
                        this.setFrequencyElement(String.valueOf(updateFreq), beginOffset, endOffset);
                    }
                } else {
                    this.setFrequencyElement("6.0", beginOffset, endOffset);
                }
                return "day";
            }
            if ((double)da.getPeriod() == 7.0) {
                if (this.frequency != null && this.frequency.getBeginOffset() != beginOffset && this.frequency.getEndOffset() != endOffset) {
                    if ((this.dosage == null || this.dosage != null && this.convertFromTextToNum(this.dosage.getDosage()).compareTo("1") == 0 && this.dosage.getBeginOffset() != beginOffset && this.dosage.getEndOffset() != endOffset) && this.changeStatus != null && this.changeStatus.getDrugChangeStatus().compareTo("change") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decrease") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decreasefrom") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increase") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increasefrom") != 0) {
                        this.setFrequencyElement(this.frequency.getFrequencyMention(), this.frequency.getBeginOffset(), this.frequency.getEndOffset());
                    } else {
                        double updateFreq = new Double(this.frequency.getFrequencyMention()) * 7.0;
                        this.setFrequencyElement(String.valueOf(updateFreq), beginOffset, endOffset);
                    }
                } else {
                    this.setFrequencyElement("7.0", beginOffset, endOffset);
                }
                return "day";
            }
            if ((double)da.getPeriod() == 8.0) {
                if (this.frequency != null && this.frequency.getBeginOffset() != beginOffset && this.frequency.getEndOffset() != endOffset) {
                    if ((this.dosage == null || this.dosage != null && this.convertFromTextToNum(this.dosage.getDosage()).compareTo("1") == 0 && this.dosage.getBeginOffset() != beginOffset && this.dosage.getEndOffset() != endOffset) && this.changeStatus != null && this.changeStatus.getDrugChangeStatus().compareTo("change") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decrease") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("decreasefrom") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increase") != 0 && this.changeStatus.getDrugChangeStatus().compareTo("increasefrom") != 0) {
                        this.setFrequencyElement(this.frequency.getFrequencyMention(), this.frequency.getBeginOffset(), this.frequency.getEndOffset());
                    } else {
                        double updateFreq = new Double(this.frequency.getFrequencyMention()) * 8.0;
                        this.setFrequencyElement(String.valueOf(updateFreq), beginOffset, endOffset);
                    }
                } else {
                    this.setFrequencyElement("8.0", beginOffset, endOffset);
                }
                return "day";
            }
            if (da.getPeriod() == new Float(0.5).floatValue()) {
                return "every-other-day";
            }
            if (da.getPeriod() == new Float(0.14).floatValue()) {
                return "week";
            }
            if (da.getPeriod() == new Float(0.03).floatValue()) {
                return "month";
            }
            if ((double)da.getPeriod() == 0.0) {
                return "as-needed";
            }
            return lastTerm;
        }
        return null;
    }

    private String findDurationElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DurationAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            DurationAnnotation da = (DurationAnnotation)firItr.next();
            if (da.getBegin() != beginOffset) continue;
            return da.getCoveredText();
        }
        return null;
    }

    private String findRouteElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, RouteAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            RouteAnnotation ra = (RouteAnnotation)firItr.next();
            if (ra.getBegin() != beginOffset) continue;
            if (new Integer(ra.getIntakeMethod()) == 2) {
                return "Enteral_Gastric";
            }
            if (new Integer(ra.getIntakeMethod()) == 1) {
                return "Enteral_Oral";
            }
            if (new Integer(ra.getIntakeMethod()) == 5) {
                return "Parenteral_Intra-arterial";
            }
            if (new Integer(ra.getIntakeMethod()) == 7) {
                return "Parenteral_Intracardiac";
            }
            if (new Integer(ra.getIntakeMethod()) == 6) {
                return "Parenteral_Intramuscular";
            }
            if (new Integer(ra.getIntakeMethod()) == 10) {
                return "Parenteral_Intraperitoneal";
            }
            if (new Integer(ra.getIntakeMethod()) == 9) {
                return "Parenteral_Intrathecal";
            }
            if (new Integer(ra.getIntakeMethod()) == 4) {
                return "Parenteral_Intravenous";
            }
            if (new Integer(ra.getIntakeMethod()) == 3) {
                return "Enteral_Rectal";
            }
            if (new Integer(ra.getIntakeMethod()) == 8) {
                return "Parenteral_Subcutaneous";
            }
            if (new Integer(ra.getIntakeMethod()) == 0) {
                return "Topical";
            }
            if (new Integer(ra.getIntakeMethod()) == 11) {
                return "Parenteral_Transdermal";
            }
            if (new Integer(ra.getIntakeMethod()) == 12) {
                return "Parenteral_Transmucosal";
            }
            return ra.getCoveredText();
        }
        return null;
    }

    private String findDrugChangeStatusElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DrugChangeStatusAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            DrugChangeStatusAnnotation dcsa = (DrugChangeStatusAnnotation)firItr.next();
            if (dcsa.getBegin() != beginOffset) continue;
            int posSpace = dcsa.getCoveredText().indexOf(32);
            int posHyph = dcsa.getCoveredText().indexOf(45);
            String firstTerm = dcsa.getCoveredText();
            if (posSpace > 0) {
                firstTerm = dcsa.getCoveredText().substring(0, posSpace);
            }
            if (posHyph > 0) {
                firstTerm = firstTerm.substring(0, posHyph);
            }
            return dcsa.getChangeStatus();
        }
        return null;
    }

    private String findStrengthElement(JCas jcas, int beginOffset, int endOffset) {
        FSIterator firItr = FSUtil.getAnnotationsIteratorInSpan(jcas, StrengthAnnotation.type, beginOffset, endOffset + 1);
        while (firItr.hasNext()) {
            StrengthAnnotation dcsa = (StrengthAnnotation)firItr.next();
            String strength = dcsa.getCoveredText();
            if (dcsa.getBegin() != beginOffset) continue;
            return this.parseRegex(strength);
        }
        return null;
    }

    private String parseRegex(String stringGlob) {
        if (!stringGlob.matches("[0-9]*[\\.]*[0-9]+\\s[a-zA-Z]+")) {
            if (stringGlob.matches("[0-9]*[\\.]*[0-9]+[-]+[a-zA-Z]+")) {
                stringGlob = stringGlob.replaceAll("-", " ");
            } else if (stringGlob.matches("[0-9]*[\\.]*[0-9]+[a-zA-Z]+")) {
                int intRegex = DrugMention.indexOfRegex(stringGlob, lookForAlpha);
                stringGlob = String.valueOf(stringGlob.substring(0, intRegex)) + " " + stringGlob.substring(intRegex);
            } else if (stringGlob.matches("[0-9]*[\\.]*[0-9]+[\\%]")) {
                int intRegex = DrugMention.indexOfRegex(stringGlob, lookForPercent);
                stringGlob = String.valueOf(stringGlob.substring(0, intRegex)) + " " + stringGlob.substring(intRegex);
            } else if (!stringGlob.matches("[0-9]*[\\.]*[0-9]+[\\s][\\%]") && stringGlob.matches("[0-9]*[\\.]*[0-9]+[-]\\%")) {
                stringGlob = stringGlob.replaceAll("-", "");
            }
        }
        return stringGlob.trim().replace('\n', ' ').replaceAll(",", "").replaceAll("-", "");
    }

    public int parseIntValue(Object strength) {
        String text = (String)strength;
        String strengthNumText = "";
        String subText = "";
        boolean containsNums = false;
        boolean doneHere = false;
        int textSize = text.length();
        int pos = 0;
        Object posInt = null;
        while (!doneHere && textSize > pos && textSize >= 1) {
            try {
                String numString = text.substring(pos, pos + 1);
                Integer posNum = Integer.decode(numString);
                int checkInt = posNum;
                if (checkInt >= 0 && checkInt <= 9) {
                    containsNums = true;
                    subText = text.substring(pos + 1, textSize);
                    ++pos;
                    strengthNumText = String.valueOf(strengthNumText) + numString;
                    continue;
                }
                return 0;
            }
            catch (NullPointerException npe) {
                return 0;
            }
            catch (NumberFormatException nfe) {
                if (!containsNums) {
                    return 0;
                }
                doneHere = true;
            }
        }
        return new Integer(strengthNumText);
    }

    public double parseDoubleValue(Object strength) {
        String text = (String)strength;
        String strengthNumText = "";
        String subText = "";
        boolean containsNums = false;
        boolean doneHere = false;
        int textSize = text.length();
        int pos = 0;
        Object posInt = null;
        while (!doneHere && textSize > pos && textSize >= 1) {
            try {
                String numString = text.substring(pos, pos + 1);
                if (numString.compareTo(".") == 0) {
                    subText = text.substring(pos + 1, textSize);
                    ++pos;
                    strengthNumText = String.valueOf(strengthNumText) + numString;
                    continue;
                }
                Integer posNum = Integer.decode(numString);
                int checkInt = posNum;
                if (checkInt >= 0 && checkInt <= 9) {
                    containsNums = true;
                    subText = text.substring(pos + 1, textSize);
                    ++pos;
                    strengthNumText = String.valueOf(strengthNumText) + numString;
                    continue;
                }
                return 0.0;
            }
            catch (NullPointerException npe) {
                return 0.0;
            }
            catch (NumberFormatException nfe) {
                if (!containsNums) {
                    return 0.0;
                }
                doneHere = true;
            }
        }
        return new Double(strengthNumText);
    }

    public String convertFromTextToNum(String firstTerm) {
        int space;
        int hyph = firstTerm.lastIndexOf(45);
        if (hyph > 0) {
            int lastHyph;
            int hyphChild = (firstTerm = firstTerm.substring(0, hyph)).lastIndexOf(45);
            if (hyphChild > 0) {
                firstTerm = firstTerm.substring(0, hyphChild);
            }
            if ((lastHyph = firstTerm.indexOf(45)) > 0) {
                firstTerm = firstTerm.substring(0, lastHyph);
            }
        }
        if ((space = firstTerm.indexOf(32)) > 0) {
            firstTerm = firstTerm.substring(0, space);
        }
        if (firstTerm.compareToIgnoreCase("first") == 0 || firstTerm.compareToIgnoreCase("one") == 0 || firstTerm.compareToIgnoreCase("daily") == 0 || firstTerm.compareToIgnoreCase("day") == 0 || firstTerm.compareToIgnoreCase("once") == 0) {
            return "1";
        }
        if (firstTerm.compareToIgnoreCase("twice") == 0 || firstTerm.compareToIgnoreCase("second") == 0 || firstTerm.compareToIgnoreCase("two") == 0) {
            return "2";
        }
        if (firstTerm.compareToIgnoreCase("third") == 0 || firstTerm.compareToIgnoreCase("three") == 0) {
            return "3";
        }
        if (firstTerm.compareToIgnoreCase("forth") == 0 || firstTerm.compareToIgnoreCase("four") == 0) {
            return "4";
        }
        if (firstTerm.compareToIgnoreCase("fifth") == 0 || firstTerm.compareToIgnoreCase("five") == 0) {
            return "5";
        }
        if (firstTerm.compareToIgnoreCase("six") == 0) {
            return "6";
        }
        if (firstTerm.compareToIgnoreCase("seven") == 0) {
            return "7";
        }
        if (firstTerm.compareToIgnoreCase("eight") == 0) {
            return "8";
        }
        if (firstTerm.compareToIgnoreCase("nine") == 0) {
            return "9";
        }
        if (firstTerm.compareToIgnoreCase("ten") == 0) {
            return "10";
        }
        if (firstTerm.compareToIgnoreCase("half") == 0 || firstTerm.compareToIgnoreCase("every-other-day") == 0) {
            return ".5";
        }
        if (firstTerm.compareToIgnoreCase("week") == 0 || firstTerm.compareToIgnoreCase("weekly") == 0) {
            return ".14";
        }
        if (firstTerm.compareToIgnoreCase("month") == 0 || firstTerm.compareToIgnoreCase("monthly") == 0) {
            return ".03";
        }
        if (firstTerm.compareToIgnoreCase("hour") == 0 || firstTerm.compareToIgnoreCase("hourly") == 0) {
            return "24";
        }
        return firstTerm;
    }

    public String convertToChangeStatus(String firstTerm) {
        if (firstTerm.compareToIgnoreCase("stop") == 0 || firstTerm.compareToIgnoreCase("stopped") == 0 || firstTerm.compareToIgnoreCase("past") == 0 || firstTerm.compareToIgnoreCase("stopping") == 0 || firstTerm.compareToIgnoreCase("discontinue") == 0 || firstTerm.compareToIgnoreCase("discontinued") == 0 || firstTerm.compareToIgnoreCase("DISCONTINUED MEDICATIONS") == 0 || firstTerm.compareToIgnoreCase("DISCONTINUE MEDICATIONS") == 0) {
            return "stop";
        }
        if (firstTerm.compareToIgnoreCase("new") == 0 || firstTerm.compareToIgnoreCase("new dose") == 0 || firstTerm.compareToIgnoreCase("start") == 0 || firstTerm.compareToIgnoreCase("started") == 0 || firstTerm.compareToIgnoreCase("new medication") == 0 || firstTerm.compareToIgnoreCase("NEW MEDICATIONS") == 0) {
            return "start";
        }
        if (firstTerm.compareToIgnoreCase("increase") == 0 || firstTerm.compareToIgnoreCase("increased") == 0) {
            return "increase";
        }
        if (firstTerm.compareToIgnoreCase("decrease") == 0 || firstTerm.compareToIgnoreCase("lower") == 0 || firstTerm.compareToIgnoreCase("decreased") == 0) {
            return "decrease";
        }
        if (firstTerm.compareToIgnoreCase("then") == 0 || firstTerm.compareToIgnoreCase("changed") == 0 || firstTerm.compareToIgnoreCase("change") == 0) {
            return "change";
        }
        if (firstTerm.compareToIgnoreCase("and") == 0 || firstTerm.compareToIgnoreCase("plus") == 0) {
            return "add";
        }
        return "noChange";
    }

    public int getDosageBegin() {
        return this.dosage.getBeginOffset();
    }

    public int getDosageEnd() {
        return this.dosage.getEndOffset();
    }

    public int getFrequencyBegin() {
        return this.frequency.getBeginOffset();
    }

    public int getFrequencyEnd() {
        return this.frequency.getEndOffset();
    }

    public int getFUBegin() {
        return this.frequencyUnit.getBeginOffset();
    }

    public int getFUENd() {
        return this.frequencyUnit.getEndOffset();
    }

    public int getFormBegin() {
        return this.form.getBeginOffset();
    }

    public int getFormEnd() {
        return this.form.getEndOffset();
    }

    public int getDuratationBegin() {
        return this.duration.getBeginOffset();
    }

    public int getDuratationEnd() {
        return this.duration.getEndOffset();
    }

    public int getRouteBegin() {
        return this.route.getBeginOffset();
    }

    public int getRouteEnd() {
        return this.route.getEndOffset();
    }

    public int getStrengthBegin() {
        return this.strength.getBeginOffset();
    }

    public int getStrengthEnd() {
        return this.strength.getEndOffset();
    }

    public int getChangeStatusBegin() {
        return this.changeStatus.getBeginOffset();
    }

    public int getChangeStatusEnd() {
        return this.changeStatus.getEndOffset();
    }

    public static int indexOfRegex(String lookIn, Pattern lookFor) {
        Matcher m = lookFor.matcher(lookIn);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }
}

