/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.drugner.ae;

import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.core.util.JCasUtil;
import edu.mayo.bmi.uima.core.util.ParamUtil;
import edu.mayo.bmi.uima.lookup.type.DrugLookupWindowAnnotation;
import edu.mayo.bmi.uima.lookup.type.LookupWindowAnnotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.TOP;

public class CopyDrugAnnotator
extends JTextAnnotator_ImplBase {
    private int iv_srcType;
    private int iv_segmentType = 0;
    public static final String PARAM_SEGMENTS_TO_SKIP = "sectionOverrideSet";
    private Set iv_skipSegmentsSet;
    private Constructor iv_destContr;
    private Map iv_getSetMap;

    @Override
    public void initialize(AnnotatorContext annotCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotCtx);
        try {
            String className = (String)annotCtx.getConfigParameterValue("srcDrugObjClass");
            Class<?> srcClass = Class.forName(className);
            this.iv_srcType = JCasUtil.getType(className);
            className = (String)annotCtx.getConfigParameterValue("destDrugObjClass");
            Class<?> destClass = Class.forName(className);
            Class[] constrArgs = new Class[]{JCas.class};
            this.iv_destContr = destClass.getConstructor(constrArgs);
            this.iv_skipSegmentsSet = ParamUtil.getStringParameterValuesSet(PARAM_SEGMENTS_TO_SKIP, annotCtx);
            Map<String, String> m = ParamUtil.getStringParameterValuesMap("dataDrugBindMap", annotCtx, "|");
            this.iv_getSetMap = new HashMap();
            for (String getterMethName : m.keySet()) {
                String setterMethName = m.get(getterMethName);
                Method getterMeth = srcClass.getMethod(getterMethName, null);
                Class[] setterArgs = new Class[]{getterMeth.getReturnType()};
                Method setterMeth = destClass.getMethod(setterMethName, setterArgs);
                this.iv_getSetMap.put(getterMeth, setterMeth);
            }
        }
        catch (Exception e) {
            throw new AnnotatorInitializationException(e);
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification rs) throws AnnotatorProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator srcObjItr = indexes.getAnnotationIndex(Segment.type).iterator();
        Segment segment = null;
        while (srcObjItr.hasNext()) {
            TOP srcObj = (TOP)srcObjItr.next();
            Object[] constrArgVals = new Object[]{jcas};
            try {
                TOP destObj = (TOP)this.iv_destContr.newInstance(constrArgVals);
                boolean okayToSkip = false;
                boolean segmentMissing = this.iv_skipSegmentsSet.isEmpty();
                if (!segmentMissing) {
                    Iterator getSkipSegs = this.iv_skipSegmentsSet.iterator();
                    segment = (Segment)srcObj;
                    while (getSkipSegs.hasNext() && !okayToSkip) {
                        if (!getSkipSegs.next().equals(segment.getId())) continue;
                        okayToSkip = true;
                    }
                }
                Iterator getterItr = this.iv_getSetMap.keySet().iterator();
                while (getterItr.hasNext() && (okayToSkip || segmentMissing)) {
                    Method getterMeth = (Method)getterItr.next();
                    Method setterMeth = (Method)this.iv_getSetMap.get(getterMeth);
                    Object val = getterMeth.invoke((Object)srcObj, null);
                    Object[] setterArgs = new Object[]{val};
                    setterMeth.invoke((Object)destObj, setterArgs);
                }
                if (okayToSkip) {
                    destObj.addToIndexes();
                    continue;
                }
                FSIterator lookupWindows = FSUtil.getAnnotationsInSpanIterator(jcas, LookupWindowAnnotation.type, segment.getBegin(), segment.getEnd());
                while (lookupWindows.hasNext()) {
                    LookupWindowAnnotation lookup = (LookupWindowAnnotation)lookupWindows.next();
                    DrugLookupWindowAnnotation drugLookup = new DrugLookupWindowAnnotation(jcas, lookup.getBegin(), lookup.getEnd());
                    drugLookup.addToIndexes();
                }
            }
            catch (Exception e) {
                throw new AnnotatorProcessException(e);
            }
        }
    }
}

