/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.drugner.ae;

import edu.mayo.bmi.fsm.drugner.machines.elements.DecimalStrengthFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.DosagesFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.DrugChangeStatusFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.DurationFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.FormFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.FractionStrengthFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.FrequencyFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.FrequencyUnitFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.RangeStrengthFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.RouteFSM;
import edu.mayo.bmi.fsm.drugner.machines.elements.StrengthFSM;
import edu.mayo.bmi.fsm.drugner.machines.util.SubSectionIndicatorFSM;
import edu.mayo.bmi.fsm.drugner.machines.util.SuffixStrengthFSM;
import edu.mayo.bmi.fsm.drugner.output.elements.BaseTokenImpl;
import edu.mayo.bmi.fsm.drugner.output.elements.DosageToken;
import edu.mayo.bmi.fsm.drugner.output.elements.DrugChangeStatusToken;
import edu.mayo.bmi.fsm.drugner.output.elements.DurationToken;
import edu.mayo.bmi.fsm.drugner.output.elements.FormToken;
import edu.mayo.bmi.fsm.drugner.output.elements.FrequencyToken;
import edu.mayo.bmi.fsm.drugner.output.elements.FrequencyUnitToken;
import edu.mayo.bmi.fsm.drugner.output.elements.RouteToken;
import edu.mayo.bmi.fsm.drugner.output.elements.StrengthToken;
import edu.mayo.bmi.fsm.drugner.output.util.SubSectionIndicator;
import edu.mayo.bmi.fsm.drugner.output.util.SuffixStrengthToken;
import edu.mayo.bmi.uima.cdt.type.DateAnnotation;
import edu.mayo.bmi.uima.core.fsm.adapters.ContractionTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.DecimalTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.IntegerTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.NewlineTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.PunctuationTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.SymbolTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.WordTokenAdapter;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.ContractionToken;
import edu.mayo.bmi.uima.core.type.IdentifiedAnnotation;
import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.NewlineToken;
import edu.mayo.bmi.uima.core.type.NumToken;
import edu.mayo.bmi.uima.core.type.OntologyConcept;
import edu.mayo.bmi.uima.core.type.PunctuationToken;
import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.type.SymbolToken;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.core.util.ParamUtil;
import edu.mayo.bmi.uima.drugner.DrugMention;
import edu.mayo.bmi.uima.drugner.type.ChunkAnnotation;
import edu.mayo.bmi.uima.drugner.type.DecimalStrengthAnnotation;
import edu.mayo.bmi.uima.drugner.type.DosagesAnnotation;
import edu.mayo.bmi.uima.drugner.type.DrugChangeStatusAnnotation;
import edu.mayo.bmi.uima.drugner.type.DrugMentionAnnotation;
import edu.mayo.bmi.uima.drugner.type.DurationAnnotation;
import edu.mayo.bmi.uima.drugner.type.FormAnnotation;
import edu.mayo.bmi.uima.drugner.type.FractionStrengthAnnotation;
import edu.mayo.bmi.uima.drugner.type.FrequencyAnnotation;
import edu.mayo.bmi.uima.drugner.type.FrequencyUnitAnnotation;
import edu.mayo.bmi.uima.drugner.type.RangeStrengthAnnotation;
import edu.mayo.bmi.uima.drugner.type.RouteAnnotation;
import edu.mayo.bmi.uima.drugner.type.StrengthAnnotation;
import edu.mayo.bmi.uima.drugner.type.SubSectionAnnotation;
import edu.mayo.bmi.uima.drugner.type.SuffixStrengthAnnotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public class DrugMentionAnnotator
extends JTextAnnotator_ImplBase {
    public static Logger iv_logger = Logger.getLogger(DrugMentionAnnotator.class);
    public static final String PARAM_SEGMENTS_MEDICATION_RELATED = "medicationRelatedSection";
    private FractionStrengthFSM iv_fractionFSM;
    private RangeStrengthFSM iv_rangeFSM;
    private SubSectionIndicatorFSM iv_subMedSectionFSM;
    private DosagesFSM iv_dosagesFSM;
    private SuffixStrengthFSM iv_suffixFSM;
    private DurationFSM iv_durationFSM;
    private RouteFSM iv_routeFSM;
    private FrequencyFSM iv_frequencyFSM;
    private DrugChangeStatusFSM iv_statusFSM;
    private DecimalStrengthFSM iv_decimalFSM;
    private StrengthFSM iv_strengthFSM;
    private FrequencyUnitFSM iv_frequencyUnitFSM;
    private FormFSM iv_formFSM;
    private static final int NERTypeIdentifier = 1;
    private static boolean handledRanges;
    private final String CANONICAL_VARIANT_ATTR = "canonicalATTR";
    private Set<String> iv_exclusionTagSet = null;
    private Set<String> iv_medicationRelatedSections = new HashSet<String>();

    @Override
    public void initialize(AnnotatorContext annotCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotCtx);
        try {
            this.iv_medicationRelatedSections = ParamUtil.getStringParameterValuesSet(PARAM_SEGMENTS_MEDICATION_RELATED, annotCtx);
        }
        catch (AnnotatorContextException e) {
            throw new AnnotatorInitializationException(e);
        }
        this.iv_fractionFSM = new FractionStrengthFSM();
        this.iv_suffixFSM = new SuffixStrengthFSM();
        this.iv_durationFSM = new DurationFSM();
        this.iv_routeFSM = new RouteFSM();
        this.iv_frequencyFSM = new FrequencyFSM();
        this.iv_dosagesFSM = new DosagesFSM();
        this.iv_rangeFSM = new RangeStrengthFSM();
        this.iv_statusFSM = new DrugChangeStatusFSM();
        this.iv_decimalFSM = new DecimalStrengthFSM();
        this.iv_strengthFSM = new StrengthFSM();
        this.iv_frequencyUnitFSM = new FrequencyUnitFSM();
        this.iv_formFSM = new FormFSM();
        this.iv_subMedSectionFSM = new SubSectionIndicatorFSM();
        iv_logger.info("Finite state machines loaded.");
    }

    @Override
    public void process(JCas jcas, ResultSpecification rs) throws AnnotatorProcessException {
        try {
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
            FSIterator baseTokenItr = indexes.getAnnotationIndex(BaseToken.type).iterator();
            ArrayList<edu.mayo.bmi.fsm.token.BaseToken> baseTokenList = new ArrayList<edu.mayo.bmi.fsm.token.BaseToken>();
            while (baseTokenItr.hasNext()) {
                BaseToken bta = (BaseToken)baseTokenItr.next();
                baseTokenList.add(this.adaptToFSMBaseToken(bta));
            }
            this.prepareSubSection(jcas, indexes, this.iv_subMedSectionFSM.execute(baseTokenList));
            while (segmentItr.hasNext()) {
                Segment seg = (Segment)segmentItr.next();
                if (!this.iv_medicationRelatedSections.contains(seg.getId())) continue;
                this.generateDrugMentions(jcas, seg);
            }
            this.generateUidValues(jcas);
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    private void generateUidValues(JCas jcas) {
        int uid = 0;
        FSIterator itr = jcas.getJFSIndexRepository().getAnnotationIndex(IdentifiedAnnotation.type).iterator();
        while (itr.hasNext()) {
            IdentifiedAnnotation idAnnot = (IdentifiedAnnotation)itr.next();
            idAnnot.setUid(uid);
            ++uid;
        }
    }

    private List sortSubSectionInd(Object[] holdOutSet) {
        ArrayList<Object> holdList = new ArrayList<Object>();
        int i = 0;
        while (i < holdOutSet.length - 1) {
            SubSectionIndicator hos1 = (SubSectionIndicator)holdOutSet[i];
            SubSectionIndicator hos2 = (SubSectionIndicator)holdOutSet[i + 1];
            if (hos1.getStartOffset() > hos2.getStartOffset()) {
                holdOutSet[i + 1] = hos1;
                holdOutSet[i] = hos2;
                this.sortSubSectionInd(holdOutSet);
            }
            ++i;
        }
        holdList.addAll(Arrays.asList(holdOutSet));
        return holdList;
    }

    private List sortAnnotations(Object[] holdOutSet) {
        ArrayList<Object> holdList = new ArrayList<Object>();
        int i = 0;
        while (i < holdOutSet.length - 1) {
            Annotation hos1 = (Annotation)holdOutSet[i];
            Annotation hos2 = (Annotation)holdOutSet[i + 1];
            if (hos1.getBegin() > hos2.getBegin()) {
                holdOutSet[i + 1] = hos1;
                holdOutSet[i] = hos2;
                this.sortAnnotations(holdOutSet);
            }
            ++i;
        }
        holdList.addAll(Arrays.asList(holdOutSet));
        return holdList;
    }

    private List findUniqueMentions(Object[] holdOutSet) {
        boolean isDuplicate = false;
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < holdOutSet.length) {
            int j = 0;
            while (j < holdOutSet.length) {
                iv_logger.debug("Comparing [" + ((Annotation)holdOutSet[i]).getCoveredText() + "] ==? [" + ((Annotation)holdOutSet[j]).getCoveredText() + "]");
                isDuplicate = this.isDuplicate(holdOutSet, i, j) || isDuplicate;
                ++j;
            }
            if (!isDuplicate) {
                iv_logger.debug("Adding NE: " + ((Annotation)holdOutSet[i]).getCoveredText());
                list.add(holdOutSet[i]);
            } else {
                iv_logger.debug("NOT Adding NE: " + ((Annotation)holdOutSet[i]).getCoveredText());
            }
            ++i;
            isDuplicate = false;
        }
        return list;
    }

    private boolean isDuplicate(Object[] neArray, int curIdx, int checkIdx) {
        if (curIdx == checkIdx || checkIdx > neArray.length) {
            iv_logger.debug("Are indices equal?:" + curIdx + "==" + checkIdx);
            return false;
        }
        Annotation ann1 = (Annotation)neArray[curIdx];
        Annotation ann2 = (Annotation)neArray[checkIdx];
        return ann1.getBegin() == ann2.getBegin() && ann1.getEnd() < ann2.getEnd();
    }

    private void prepareSubSection(JCas jcas, JFSIndexRepository indexes, Set subSectionIndSet) throws Exception {
        List sortedSubSecInds = this.sortSubSectionInd(subSectionIndSet.toArray());
        int i = 0;
        int endBodyOffset = 0;
        while (i < sortedSubSecInds.size()) {
            SubSectionIndicator ssi = (SubSectionIndicator)sortedSubSecInds.get(i);
            Segment segment = this.getSegmentContainingOffsets(jcas, ssi.getStartOffset(), ssi.getEndOffset());
            endBodyOffset = segment.getEnd();
            SubSectionAnnotation ssa = new SubSectionAnnotation(jcas);
            ssa.setBegin(ssi.getStartOffset());
            ssa.setSubSectionHeaderBegin(ssi.getStartOffset());
            ssa.setSubSectionHeaderEnd(ssi.getEndOffset());
            ssa.setSubSectionBodyBegin(ssi.getEndOffset() + 1);
            if (i + 1 < sortedSubSecInds.size()) {
                SubSectionIndicator nextSsi = (SubSectionIndicator)sortedSubSecInds.get(i + 1);
                endBodyOffset = this.getSubSectionAnnotationBodyEnd(segment, nextSsi);
            } else {
                endBodyOffset = this.getSubSectionAnnotationBodyEnd(segment, null);
            }
            ssa.setSubSectionBodyEnd(endBodyOffset);
            ssa.setEnd(endBodyOffset);
            ssa.addToIndexes();
            ++i;
            endBodyOffset = 0;
        }
    }

    private int getSubSectionAnnotationBodyEnd(Segment currSeg, SubSectionIndicator nextSsi) {
        if (nextSsi == null) {
            return currSeg.getEnd();
        }
        if (nextSsi.getStartOffset() > currSeg.getEnd()) {
            return currSeg.getEnd();
        }
        if (nextSsi.getStartOffset() < currSeg.getEnd()) {
            return nextSsi.getStartOffset() - 1;
        }
        return -1;
    }

    private Segment getSegmentContainingOffsets(JCas jcas, int start, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
        while (segmentItr.hasNext()) {
            Segment seg = (Segment)segmentItr.next();
            if (seg.getBegin() > start || seg.getEnd() < end) continue;
            return seg;
        }
        return null;
    }

    private void addAnnotations(JCas jcas, Set annotations, int type) {
        Iterator annItr = annotations.iterator();
        while (annItr.hasNext()) {
            Annotation ann = null;
            BaseTokenImpl oldAnn = (BaseTokenImpl)annItr.next();
            if (FractionStrengthAnnotation.type == type) {
                ann = new FractionStrengthAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
            } else if (DecimalStrengthAnnotation.type == type) {
                ann = new DecimalStrengthAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
            } else if (DrugChangeStatusAnnotation.type == type) {
                ann = new DrugChangeStatusAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
                ((DrugChangeStatusAnnotation)ann).setChangeStatus(((DrugChangeStatusToken)oldAnn).getDrugChangeStatus());
            } else if (RangeStrengthAnnotation.type == type) {
                ann = new RangeStrengthAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
            }
            if (ann == null) continue;
            ann.addToIndexes();
        }
    }

    private void executeFSMs(JCas jcas, List baseTokenList, List namedE, List wordTokenList) throws AnnotatorProcessException {
        try {
            StrengthAnnotation ma;
            int endSeg;
            int begSeg;
            Set fractionTokenSet = this.iv_fractionFSM.execute(baseTokenList);
            this.addAnnotations(jcas, fractionTokenSet, FractionStrengthAnnotation.type);
            Set decimalTokenSet = this.iv_decimalFSM.execute(baseTokenList);
            this.addAnnotations(jcas, decimalTokenSet, FractionStrengthAnnotation.type);
            Set statusTokenSet = this.iv_statusFSM.execute(baseTokenList);
            this.addAnnotations(jcas, statusTokenSet, DrugChangeStatusAnnotation.type);
            Set rangeTokenSet = this.iv_rangeFSM.execute(baseTokenList);
            this.addAnnotations(jcas, decimalTokenSet, RangeStrengthAnnotation.type);
            Set strengthTokenSet = this.iv_strengthFSM.execute(baseTokenList, rangeTokenSet);
            Iterator measurementTokenItr = strengthTokenSet.iterator();
            boolean begin = false;
            boolean previous = false;
            while (measurementTokenItr.hasNext()) {
                Iterator chkNE = namedE.iterator();
                Iterator newNE = wordTokenList.iterator();
                boolean neFound = false;
                Object ne = null;
                Object we = null;
                StrengthToken mt = (StrengthToken)measurementTokenItr.next();
                begSeg = mt.getStartOffset();
                endSeg = mt.getEndOffset();
                ma = new StrengthAnnotation(jcas, begSeg, endSeg);
                ma.addToIndexes();
            }
            Set decTokenSet = null;
            decTokenSet = this.iv_strengthFSM.execute(baseTokenList, decimalTokenSet, fractionTokenSet);
            for (StrengthToken mt : decTokenSet) {
                StrengthAnnotation ma2 = new StrengthAnnotation(jcas, mt.getStartOffset(), mt.getEndOffset());
                ma2.addToIndexes();
            }
            Set formTokenSet = this.iv_formFSM.execute(baseTokenList, new HashSet());
            for (FormToken mt : formTokenSet) {
                FormAnnotation ma3 = new FormAnnotation(jcas, mt.getStartOffset(), mt.getEndOffset());
                ma3.addToIndexes();
            }
            Set preTokenSet = this.iv_strengthFSM.execute(baseTokenList, decTokenSet);
            for (StrengthToken mt : preTokenSet) {
                begSeg = mt.getStartOffset();
                endSeg = mt.getEndOffset();
                ma = new StrengthAnnotation(jcas, begSeg, endSeg);
                ma.addToIndexes();
            }
            Set doseTokenSet = this.iv_dosagesFSM.execute(baseTokenList, formTokenSet, strengthTokenSet);
            Iterator dosTokenItr = doseTokenSet.iterator();
            Iterator formCheckItr = formTokenSet.iterator();
            Iterator strengthCheckItr = strengthTokenSet.iterator();
            boolean foundDosage = false;
            int begSegDose = 0;
            int endSegDose = 0;
            while (dosTokenItr.hasNext()) {
                DosageToken mt = (DosageToken)dosTokenItr.next();
                begSegDose = mt.getStartOffset();
                endSegDose = mt.getEndOffset();
                DosagesAnnotation ma4 = new DosagesAnnotation(jcas, begSegDose, endSegDose);
                ma4.addToIndexes();
            }
            Set suffixTokenSet = this.iv_suffixFSM.execute(baseTokenList, strengthTokenSet);
            for (SuffixStrengthToken mt : suffixTokenSet) {
                SuffixStrengthAnnotation ma5 = new SuffixStrengthAnnotation(jcas, mt.getStartOffset(), mt.getEndOffset());
                ma5.addToIndexes();
            }
            Set routeTokenSet = this.iv_routeFSM.execute(baseTokenList);
            boolean foundRoute = false;
            Iterator routeTokenItr = routeTokenSet.iterator();
            int begSegRT = 0;
            int endSegRT = 0;
            while (routeTokenItr.hasNext()) {
                RouteToken mt = (RouteToken)routeTokenItr.next();
                begSegRT = mt.getStartOffset();
                endSegRT = mt.getEndOffset();
                RouteAnnotation ma6 = new RouteAnnotation(jcas, begSegRT, endSegRT);
                ma6.setIntakeMethod(new Integer(mt.getFormMethod()).toString());
                ma6.addToIndexes();
            }
            Set frequencyUnitTokenSet = this.iv_frequencyUnitFSM.execute(baseTokenList);
            boolean foundFrequencyUnit = false;
            Iterator frequencyUnitTokenItr = frequencyUnitTokenSet.iterator();
            int begSegFUT = 0;
            int endSegFUT = 0;
            while (frequencyUnitTokenItr.hasNext()) {
                FrequencyUnitToken fut = (FrequencyUnitToken)frequencyUnitTokenItr.next();
                begSegFUT = fut.getStartOffset();
                endSegFUT = fut.getEndOffset();
                FrequencyUnitAnnotation ma7 = new FrequencyUnitAnnotation(jcas, begSegFUT, endSegFUT);
                ma7.setPeriod(new Float(fut.getFrequencyUnitQuantity()).floatValue());
                ma7.addToIndexes();
            }
            Set frequencyTokenSet = this.iv_frequencyFSM.execute(baseTokenList, frequencyUnitTokenSet, rangeTokenSet);
            boolean foundFrequency = false;
            Iterator frequencyTokenItr = frequencyTokenSet.iterator();
            int begSegFT = 0;
            int endSegFT = 0;
            while (frequencyTokenItr.hasNext()) {
                FrequencyToken ft = (FrequencyToken)frequencyTokenItr.next();
                begSegFT = ft.getStartOffset();
                endSegFT = ft.getEndOffset();
                FrequencyAnnotation ma8 = new FrequencyAnnotation(jcas, begSegFT, endSegFT);
                ma8.addToIndexes();
            }
            Set durationTokenSet = this.iv_durationFSM.execute(baseTokenList, rangeTokenSet);
            Iterator durationTokenItr = durationTokenSet.iterator();
            int begSegDU = 0;
            int endSegDU = 0;
            while (durationTokenItr.hasNext()) {
                DurationToken du = (DurationToken)durationTokenItr.next();
                begSegDU = du.getStartOffset();
                endSegDU = du.getEndOffset();
                DurationAnnotation ma9 = new DurationAnnotation(jcas, begSegDU, endSegDU);
                ma9.addToIndexes();
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    private void generateDrugMentions(JCas jcas, Segment seg) throws Exception {
        int begin = seg.getBegin();
        int end = seg.getEnd() + 1;
        NamedEntity nextNER = null;
        int nextNERPosition = 0;
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] validNeTypes = nArray;
        List allNEs = FSUtil.getAnnotationsInSpan(jcas, NamedEntity.type, begin, end, validNeTypes);
        List uniqueNEs = this.findUniqueMentions(allNEs.toArray());
        int lastNL = seg.getEnd();
        boolean lastOne = false;
        FSIterator newLineItr = FSUtil.getAnnotationsIteratorInSpan(jcas, NewlineToken.type, begin, end);
        int i = 0;
        while (i < uniqueNEs.size()) {
            NamedEntity thisNER = (NamedEntity)uniqueNEs.get(i);
            boolean hasNext = false;
            if (uniqueNEs.size() > i + 1) {
                nextNER = (NamedEntity)uniqueNEs.get(i + 1);
                nextNERPosition = nextNER.getBegin();
                hasNext = true;
            } else if (!uniqueNEs.isEmpty()) {
                nextNER = (NamedEntity)uniqueNEs.get(i);
                nextNERPosition = nextNER.getBegin();
                lastOne = true;
            }
            boolean foundLeftParen = false;
            boolean foundRightParen = false;
            foundRightParen = this.findCoveredTextInSpan(jcas, PunctuationToken.type, thisNER.getEnd(), thisNER.getEnd() + 3, new String[]{")", "/"});
            end = hasNext && !lastOne ? nextNERPosition : seg.getEnd();
            boolean hasNLEnd = true;
            boolean wrapItUp = false;
            while (hasNLEnd && !wrapItUp && end <= seg.getEnd() && (begin < end || !hasNext && begin <= end || foundLeftParen)) {
                if (begin == end) {
                    foundLeftParen = false;
                    ++end;
                }
                NewlineToken nl = null;
                if (hasNLEnd && newLineItr.hasNext()) {
                    nl = (NewlineToken)newLineItr.next();
                    hasNLEnd = true;
                }
                if (!hasNext && begin <= end || nextNERPosition < end) {
                    wrapItUp = true;
                }
                boolean findNextNL = false;
                if (lastNL <= thisNER.getBegin()) {
                    begin = thisNER.getBegin();
                }
                if (nl != null && thisNER.getBegin() >= nl.getEnd()) {
                    findNextNL = true;
                } else if (nl != null) {
                    lastNL = nl.getEnd();
                }
                if (!hasNext) {
                    findNextNL = false;
                    end = seg.getEnd();
                }
                if (findNextNL) continue;
                if (nextNER != null && (nextNER.getCoveredText().compareToIgnoreCase(thisNER.getCoveredText()) == 0 || foundRightParen || nextNER.getBegin() == thisNER.getEnd() + 2)) {
                    if (nl == null) {
                        if (!hasNext) {
                            end = seg.getEnd();
                        }
                    } else if (nextNER.getBegin() >= nl.getEnd() && hasNext) {
                        end = nextNERPosition;
                    }
                } else if (hasNLEnd && hasNext) {
                    foundLeftParen = this.findCoveredTextInSpan(jcas, PunctuationToken.type, nextNER.getBegin() - 1, nextNER.getBegin() + 1, new String[]{"(", "/"});
                    end = nl != null && nl.getEnd() > nextNER.getBegin() && !foundLeftParen ? nextNERPosition : nextNER.getBegin();
                } else {
                    end = hasNext ? nextNERPosition : seg.getEnd();
                }
                if (begin < end) {
                    this.findDrugAttributesInRange(jcas, begin, end);
                    List<Annotation> neTokenUpdatedList = this.getAnnotationsInSpan(jcas, NamedEntity.type, begin, end + 1);
                    if (!neTokenUpdatedList.isEmpty()) {
                        ArrayList<DrugMentionAnnotation> globalDrugNERList = new ArrayList<DrugMentionAnnotation>();
                        try {
                            this.generateDrugMentionsAndAnnotations(jcas, neTokenUpdatedList, begin, end, null, null, 0, globalDrugNERList);
                        }
                        catch (NumberFormatException nfe) {
                            iv_logger.info(nfe.getMessage());
                        }
                        catch (Exception e) {
                            iv_logger.info(e.getMessage());
                        }
                        globalDrugNERList.clear();
                    }
                }
                begin = end;
            }
            ++i;
        }
    }

    private boolean findCoveredTextInSpan(JCas jcas, int annotationType, int beginOffset, int endOffset, String[] searchStrs) {
        boolean foundCoveredText = false;
        FSIterator coveredTextIter = FSUtil.getAnnotationsIteratorInSpan(jcas, annotationType, beginOffset, endOffset);
        while (coveredTextIter.hasNext() && !foundCoveredText) {
            Annotation ann = (Annotation)coveredTextIter.next();
            int i = 0;
            while (i < searchStrs.length && !foundCoveredText) {
                foundCoveredText = searchStrs[i].equals(ann.getCoveredText());
                ++i;
            }
        }
        return foundCoveredText;
    }

    private List getAnnotationsInSpanWithAdaptToBaseTokenFSM(JCas jcas, int type, int begin, int end) throws Exception {
        List<Annotation> list = this.getAnnotationsInSpan(jcas, type, begin, end);
        int i = 0;
        while (i < list.size()) {
            list.add(i, (Annotation)((Object)this.adaptToFSMBaseToken((BaseToken)list.get(i))));
            list.remove(i + 1);
            ++i;
        }
        return list;
    }

    private List<Annotation> getAnnotationsInSpan(JCas jcas, int type, int begin, int end) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        FSIterator annItr = FSUtil.getAnnotationsIteratorInSpan(jcas, type, begin, end);
        while (annItr.hasNext()) {
            Annotation ann = (Annotation)annItr.next();
            list.add(ann);
        }
        return list;
    }

    private void findDrugAttributesInRange(JCas jcas, int begin, int end) throws Exception {
        List baseTokenList = this.getAnnotationsInSpanWithAdaptToBaseTokenFSM(jcas, BaseToken.type, begin, end + 1);
        List<Annotation> neTokenList = this.getAnnotationsInSpan(jcas, NamedEntity.type, begin, end + 1);
        List<Annotation> weTokenList = this.getAnnotationsInSpan(jcas, WordToken.type, begin, end + 1);
        this.executeFSMs(jcas, baseTokenList, neTokenList, weTokenList);
    }

    private void generateDrugMentionsAndAnnotations(JCas jcas, List<NamedEntity> nerTokenList, int begin, int end, DrugMentionAnnotation recurseNER, String[] relatedStatus, int countNER, List<DrugMentionAnnotation> globalDrugNER) throws Exception {
        Iterator<NamedEntity> uniqueNER = nerTokenList.iterator();
        DrugMentionAnnotation drugTokenAnt = null;
        NamedEntity tokenAnt = null;
        ArrayList<DrugMentionAnnotation> holdDrugNERArr = new ArrayList<DrugMentionAnnotation>();
        while (uniqueNER.hasNext()) {
            tokenAnt = uniqueNER.next();
            boolean isDrugNER = false;
            FSArray ocArr = tokenAnt.getOntologyConceptArr();
            if (ocArr != null) {
                int i = 0;
                while (i < ocArr.size() && !isDrugNER) {
                    OntologyConcept oc = (OntologyConcept)ocArr.get(i);
                    String scheme = oc.getCodingScheme();
                    if (scheme.compareTo("RXNORM") == 0) {
                        isDrugNER = true;
                    }
                    ++i;
                }
            }
            if (tokenAnt != null && (isDrugNER || relatedStatus != null)) {
                boolean keepNoChangeStatus = false;
                boolean maxExists = false;
                int maxOffsetEnd = 0;
                int holdRightEnd = end + 1;
                int holdLeftStart = begin;
                drugTokenAnt = new DrugMentionAnnotation(jcas, tokenAnt.getBegin(), tokenAnt.getEnd());
                tokenAnt.setTypeID(1);
                holdDrugNERArr.add(drugTokenAnt);
                FSIterator statusChangeItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DrugChangeStatusAnnotation.type, holdLeftStart, holdRightEnd);
                ArrayList<DrugChangeStatusAnnotation> holdStatusChanges = new ArrayList<DrugChangeStatusAnnotation>();
                while (statusChangeItr.hasNext()) {
                    FSIterator findSubSection = FSUtil.getAnnotationsIteratorInSpan(jcas, SubSectionAnnotation.type, holdLeftStart, holdRightEnd);
                    boolean isolate = false;
                    if (!findSubSection.hasNext()) {
                        DrugChangeStatusAnnotation dsa = (DrugChangeStatusAnnotation)statusChangeItr.next();
                        if (dsa.getChangeStatus().compareTo("maximum") != 0 && dsa.getEnd() < holdRightEnd) {
                            holdStatusChanges.add(dsa);
                            continue;
                        }
                        if (dsa.getChangeStatus().compareTo("maximum") != 0 || dsa.getEnd() >= holdRightEnd) continue;
                        maxExists = true;
                        maxOffsetEnd = dsa.getEnd();
                        continue;
                    }
                    boolean noWeirdError = true;
                    boolean pullOut = false;
                    while (!pullOut & !isolate && findSubSection.hasNext() && noWeirdError) {
                        try {
                            SubSectionAnnotation sub = (SubSectionAnnotation)findSubSection.next();
                            FSIterator findStartLF = FSUtil.getAnnotationsIteratorInSpan(jcas, NewlineToken.type, holdLeftStart, sub.getBegin() + 1);
                            FSIterator findEndLF = FSUtil.getAnnotationsIteratorInSpan(jcas, NewlineToken.type, sub.getEnd(), holdRightEnd);
                            if (findStartLF.hasNext() && findEndLF.hasNext()) {
                                while (findStartLF.hasNext()) {
                                    NewlineToken nta = (NewlineToken)findStartLF.next();
                                    int countSymbols = FSUtil.countAnnotationsInSpan(jcas, SymbolToken.type, nta.getEnd(), sub.getBegin());
                                    if (nta.getEnd() + countSymbols + 1 < sub.getBegin()) continue;
                                    isolate = true;
                                    holdRightEnd = sub.getBegin();
                                    end = sub.getBegin();
                                }
                                if (isolate) continue;
                                DrugChangeStatusAnnotation dsa = (DrugChangeStatusAnnotation)statusChangeItr.next();
                                holdStatusChanges.add(dsa);
                                pullOut = true;
                                sub.removeFromIndexes();
                                continue;
                            }
                            if (findEndLF.hasNext()) {
                                holdLeftStart = sub.getEnd();
                                continue;
                            }
                            if (sub.getBegin() > tokenAnt.getEnd()) {
                                end = sub.getBegin();
                                holdRightEnd = sub.getBegin();
                                sub.removeFromIndexes();
                                continue;
                            }
                            holdLeftStart = sub.getEnd();
                            holdRightEnd = tokenAnt.getBegin();
                        }
                        catch (NoSuchElementException nsee) {
                            noWeirdError = false;
                            iv_logger.info(nsee.getLocalizedMessage());
                        }
                    }
                }
                ArrayList<DrugChangeStatusAnnotation> modifiedOrderDrugStatusChanges = new ArrayList<DrugChangeStatusAnnotation>();
                Iterator sortStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                Iterator sortNextStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                if (sortNextStatusChanges.hasNext()) {
                    sortNextStatusChanges.next();
                }
                boolean skipNext = false;
                int checkSkippedOffsetBegin = 0;
                int checkSkippedOffsetEnd = 0;
                while (sortStatusChanges.hasNext()) {
                    DrugChangeStatusAnnotation hos1 = (DrugChangeStatusAnnotation)sortStatusChanges.next();
                    if (sortNextStatusChanges.hasNext()) {
                        DrugChangeStatusAnnotation hos2 = (DrugChangeStatusAnnotation)sortNextStatusChanges.next();
                        if (hos1.getBegin() == hos2.getBegin()) {
                            if (hos1.getEnd() >= hos2.getEnd()) {
                                skipNext = true;
                                checkSkippedOffsetBegin = hos2.getBegin();
                                checkSkippedOffsetEnd = hos2.getEnd();
                                hos2.removeFromIndexes();
                                modifiedOrderDrugStatusChanges.add(hos1);
                                continue;
                            }
                            iv_logger.info("found reverse case . . need to handle");
                            continue;
                        }
                        if (!skipNext) {
                            modifiedOrderDrugStatusChanges.add(hos1);
                            continue;
                        }
                        skipNext = false;
                        continue;
                    }
                    if (checkSkippedOffsetBegin != 0 && (checkSkippedOffsetBegin == hos1.getBegin() || checkSkippedOffsetEnd == hos1.getEnd())) continue;
                    modifiedOrderDrugStatusChanges.add(hos1);
                }
                Iterator orderedStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                Iterator orderedDrugStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                if (modifiedOrderDrugStatusChanges.size() > 0) {
                    int[] newSpan = new int[]{begin, end};
                    newSpan = this.statusChangePhraseGenerator(jcas, begin, end, maxExists, uniqueNER, orderedStatusChanges, modifiedOrderDrugStatusChanges, relatedStatus, drugTokenAnt, globalDrugNER, countNER);
                    begin = newSpan[0];
                    end = newSpan[1];
                    if (drugTokenAnt.getDrugChangeStatus() != null && drugTokenAnt.getDrugChangeStatus().equals("noChange") || drugTokenAnt.getDrugChangeStatus() != null && drugTokenAnt.getDrugChangeStatus().equals("change")) {
                        keepNoChangeStatus = true;
                        if (drugTokenAnt.getDrugChangeStatus().equals("change")) {
                            drugTokenAnt.setDrugChangeStatus("noChange");
                        }
                    }
                }
                DrugMention dm = new DrugMention(jcas, begin, end);
                boolean overrideStatus = false;
                boolean statusFound = false;
                if (!keepNoChangeStatus) {
                    JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                    FSIterator subSectionItr = indexes.getAnnotationIndex(SubSectionAnnotation.type).iterator();
                    String statusKey = null;
                    while (subSectionItr.hasNext() && !statusFound) {
                        FSIterator oneDrugChangeStatus;
                        SubSectionAnnotation ssid = (SubSectionAnnotation)subSectionItr.next();
                        if (ssid.getSubSectionBodyBegin() > tokenAnt.getBegin() || ssid.getSubSectionBodyEnd() < tokenAnt.getEnd()) continue;
                        boolean overrideDate = false;
                        FSIterator statusSpecialDateItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DateAnnotation.type, ssid.getEnd(), drugTokenAnt.getBegin());
                        while (statusSpecialDateItr.hasNext() && !overrideDate) {
                            DateAnnotation specialDate = (DateAnnotation)statusSpecialDateItr.next();
                            FSIterator findLF = FSUtil.getAnnotationsIteratorInSpan(jcas, NewlineToken.type, ssid.getEnd(), specialDate.getBegin());
                            if (findLF.hasNext()) continue;
                            drugTokenAnt.setStartDate(specialDate.getCoveredText());
                            overrideDate = true;
                        }
                        DrugChangeStatusAnnotation dsa = null;
                        if (orderedDrugStatusChanges.hasNext()) {
                            dsa = (DrugChangeStatusAnnotation)orderedDrugStatusChanges.next();
                        }
                        if (dsa != null && (dsa.getChangeStatus().compareTo("start") == 0 || dsa.getChangeStatus().compareTo("stop") == 0)) {
                            drugTokenAnt.setDrugChangeStatus(dsa.getChangeStatus());
                            continue;
                        }
                        statusKey = dm.convertToChangeStatus(ssid.getCoveredText());
                        if (ssid.getStatus() == 1) {
                            statusKey = "stop";
                        }
                        if (statusKey.compareTo("noChange") == 0 && (oneDrugChangeStatus = FSUtil.getAnnotationsIteratorInSpan(jcas, DrugChangeStatusAnnotation.type, ssid.getBegin(), ssid.getEnd() + 1)).hasNext()) {
                            dsa = (DrugChangeStatusAnnotation)oneDrugChangeStatus.next();
                            drugTokenAnt.setDrugChangeStatus(dsa.getChangeStatus());
                            statusKey = dsa.getChangeStatus();
                        }
                        drugTokenAnt.setStatus(ssid.getStatus());
                        dm.setDrugChangeStatusElement(statusKey, begin, end);
                        statusFound = true;
                    }
                    FSIterator statusSpecialChangeItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DrugChangeStatusAnnotation.type, begin - 20, drugTokenAnt.getBegin() + 1);
                    while (statusSpecialChangeItr.hasNext()) {
                        DrugChangeStatusAnnotation specialDsa = (DrugChangeStatusAnnotation)statusSpecialChangeItr.next();
                        if (specialDsa.getEnd() + 1 != drugTokenAnt.getBegin() || relatedStatus != null) continue;
                        drugTokenAnt.setDrugChangeStatus(specialDsa.getChangeStatus());
                        drugTokenAnt.setChangeStatusBegin(specialDsa.getBegin());
                        drugTokenAnt.setChangeStatusEnd(specialDsa.getEnd());
                        overrideStatus = true;
                    }
                }
                String strengthText = null;
                boolean onlyNeedOneStrength = false;
                if (!keepNoChangeStatus || drugTokenAnt.getStrength() == null) {
                    List<Annotation> holdStrength = this.getAnnotationsInSpan(jcas, StrengthAnnotation.type, begin, end + 1);
                    Iterator strengthItr = this.findUniqueMentions(holdStrength.toArray()).iterator();
                    double strengthValue = 0.0;
                    int holdStrengthBeginOffset = 0;
                    int holdStrengthEndOffset = 0;
                    while (strengthItr.hasNext() && !onlyNeedOneStrength) {
                        StrengthAnnotation sa = (StrengthAnnotation)strengthItr.next();
                        if (holdStrengthBeginOffset != sa.getBegin() && holdStrengthEndOffset != sa.getEnd() && relatedStatus != null) {
                            int spaceLocation;
                            double curStrengthValue = 0.0;
                            int hyphenLocation = sa.getCoveredText().indexOf("-");
                            String holdStrengthValue = sa.getCoveredText();
                            if (hyphenLocation > 0) {
                                holdStrengthValue = holdStrengthValue.substring(0, hyphenLocation);
                            }
                            if ((spaceLocation = holdStrengthValue.indexOf(" ")) > 0) {
                                holdStrengthValue = holdStrengthValue.substring(0, spaceLocation);
                            }
                            if (holdStrengthValue != null && holdStrengthValue.compareTo("") != 0) {
                                curStrengthValue = new Double(dm.parseDoubleValue(holdStrengthValue));
                            }
                            boolean findLowValue = true;
                            if (relatedStatus[0].compareTo("increase") == 0) {
                                if (curStrengthValue > strengthValue) {
                                    strengthValue = curStrengthValue;
                                    strengthText = dm.getStrengthElement();
                                }
                            } else if (relatedStatus[0].compareTo("decrease") == 0) {
                                if (findLowValue) {
                                    strengthValue = curStrengthValue;
                                }
                                if (curStrengthValue <= strengthValue) {
                                    strengthValue = curStrengthValue;
                                    strengthText = dm.getStrengthElement();
                                }
                                findLowValue = false;
                            } else if (relatedStatus[0].compareTo("add") == 0) {
                                strengthValue = curStrengthValue;
                                strengthText = dm.getStrengthElement();
                            }
                        } else {
                            strengthText = dm.getStrengthElement();
                            if (!maxExists) {
                                onlyNeedOneStrength = true;
                            } else if (maxOffsetEnd + 1 == sa.getBegin()) {
                                onlyNeedOneStrength = true;
                                strengthText = sa.getCoveredText();
                            }
                        }
                        holdStrengthBeginOffset = sa.getBegin();
                        holdStrengthEndOffset = sa.getEnd();
                    }
                }
                String doseText = null;
                if (!keepNoChangeStatus || drugTokenAnt.getDosage() == null) {
                    FSIterator dosageItr = FSUtil.getAnnotationsIteratorInSpan(jcas, DosagesAnnotation.type, begin, end + 1);
                    ArrayList<DosagesAnnotation> holdDosages = new ArrayList<DosagesAnnotation>();
                    double doseValue = 0.0;
                    int holdDoseBeginOffset = 0;
                    int holdDoseEndOffset = 0;
                    boolean onlyNeedOneDose = false;
                    while (dosageItr.hasNext() && !onlyNeedOneDose) {
                        DosagesAnnotation da = (DosagesAnnotation)dosageItr.next();
                        if (holdDoseBeginOffset != da.getBegin() && holdDoseEndOffset != da.getEnd() && relatedStatus != null) {
                            int removeComma = da.getCoveredText().indexOf(44);
                            String doseTextCheck = da.getCoveredText();
                            if (removeComma > 0) {
                                doseTextCheck = doseTextCheck.substring(0, removeComma);
                            }
                            double curDoseValue = new Double(dm.convertFromTextToNum(doseTextCheck));
                            boolean findLowValue = true;
                            if (relatedStatus[0].compareTo("increase") == 0) {
                                if (curDoseValue > doseValue) {
                                    doseValue = curDoseValue;
                                    doseText = dm.getDosageElement();
                                } else if (relatedStatus[0].compareTo("add") == 0) {
                                    doseValue = curDoseValue;
                                    doseText = dm.getDosageElement();
                                }
                            } else if (relatedStatus[0].compareTo("decrease") == 0) {
                                if (findLowValue) {
                                    doseValue = curDoseValue;
                                }
                                if (curDoseValue <= doseValue) {
                                    doseValue = curDoseValue;
                                    doseText = dm.getDosageElement();
                                }
                                findLowValue = false;
                            }
                            holdDosages.add(da);
                            holdDoseBeginOffset = da.getBegin();
                            holdDoseEndOffset = da.getEnd();
                            continue;
                        }
                        doseText = dm.getDosageElement();
                        if (maxExists) continue;
                        onlyNeedOneDose = true;
                    }
                }
                String frequencyText = null;
                if (!keepNoChangeStatus || drugTokenAnt.getFrequency() == null) {
                    FSIterator freqItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FrequencyAnnotation.type, begin, end + 1);
                    ArrayList holdFreqItr = new ArrayList();
                    while (freqItr.hasNext()) {
                        holdFreqItr.add(freqItr.next());
                    }
                    Iterator frequencyItr = this.sortAnnotations(holdFreqItr.toArray()).iterator();
                    ArrayList<FrequencyAnnotation> holdFrequency = new ArrayList<FrequencyAnnotation>();
                    double frequencyValue = 0.0;
                    int holdFrequencyBeginOffset = 0;
                    int holdFrequencyEndOffset = 0;
                    boolean onlyNeedOneFrequency = false;
                    while (frequencyItr.hasNext() && !onlyNeedOneFrequency) {
                        FrequencyAnnotation fa = (FrequencyAnnotation)frequencyItr.next();
                        if (dm.frequency != null && dm.frequency.getFrequencyMention() == null) {
                            double curFrequencyValue = new Double(dm.convertFromTextToNum(fa.getCoveredText()));
                            String curFreqValueText = new Double(curFrequencyValue).toString();
                            dm.setFrequencyElement(curFreqValueText, fa.getBegin(), fa.getEnd());
                            frequencyText = curFreqValueText;
                        }
                        onlyNeedOneFrequency = true;
                        holdFrequency.add(fa);
                        holdFrequencyBeginOffset = fa.getBegin();
                        holdFrequencyEndOffset = fa.getEnd();
                    }
                }
                boolean foundPRN = false;
                String frequencyUnitText = null;
                if (!keepNoChangeStatus || drugTokenAnt.getFrequencyUnit() == null) {
                    FSIterator frequencyUnitItr = FSUtil.getAnnotationsIteratorInSpan(jcas, FrequencyUnitAnnotation.type, begin, end + 1);
                    ArrayList<FrequencyUnitAnnotation> holdFrequencyUnit = new ArrayList<FrequencyUnitAnnotation>();
                    double frequencyUnitValue = 0.0;
                    int holdFrequencyUnitBeginOffset = 0;
                    int holdFrequencyUnitEndOffset = 0;
                    boolean onlyNeedOneFrequencyUnit = false;
                    while (frequencyUnitItr.hasNext() && !onlyNeedOneFrequencyUnit) {
                        FrequencyUnitAnnotation fua = (FrequencyUnitAnnotation)frequencyUnitItr.next();
                        if (holdFrequencyUnitBeginOffset != fua.getBegin() && holdFrequencyUnitEndOffset != fua.getEnd() && relatedStatus != null) {
                            double curFrequencyUnitValue = new Float(fua.getPeriod()).doubleValue();
                            boolean findLowValue = true;
                            if (relatedStatus[0].compareTo("increase") == 0) {
                                if (curFrequencyUnitValue > frequencyUnitValue) {
                                    frequencyUnitValue = curFrequencyUnitValue;
                                    frequencyUnitText = dm.getFrequencyUnitElement();
                                }
                            } else if (relatedStatus[0] == null || relatedStatus[0].compareTo("decrease") == 0) {
                                if (findLowValue) {
                                    frequencyUnitValue = curFrequencyUnitValue;
                                }
                                if (curFrequencyUnitValue <= frequencyUnitValue) {
                                    frequencyUnitValue = curFrequencyUnitValue;
                                    frequencyUnitText = dm.getFrequencyUnitElement();
                                }
                                findLowValue = false;
                            }
                        } else if ((double)fua.getPeriod() == 0.0) {
                            foundPRN = true;
                        } else {
                            frequencyUnitText = dm.getFrequencyUnitElement();
                            if (!maxExists) {
                                onlyNeedOneStrength = true;
                            }
                        }
                        holdFrequencyUnit.add(fua);
                        holdFrequencyUnitBeginOffset = fua.getBegin();
                        holdFrequencyUnitEndOffset = fua.getEnd();
                    }
                }
                if (recurseNER != null && recurseNER.getDrugChangeStatus() != null && relatedStatus[0] != null && dm.changeStatus == null) {
                    drugTokenAnt.setDrugChangeStatus(relatedStatus[0]);
                } else if (keepNoChangeStatus || dm.changeStatus != null && (dm.changeStatus.getDrugChangeStatus().equals("increasefrom") || dm.changeStatus.getDrugChangeStatus().equals("decreasefrom"))) {
                    drugTokenAnt.setDrugChangeStatus("noChange");
                } else if (dm.getDrugChangeStatusElement() != null && dm.getDrugChangeStatusElement().compareTo("") != 0 && dm.getDrugChangeStatusElement().compareTo("noChange") != 0 && !overrideStatus) {
                    FSIterator negateStatusChanges = FSUtil.getAnnotationsIteratorInSpan(jcas, SubSectionAnnotation.type, dm.changeStatus.getBeginOffset(), dm.changeStatus.getEndOffset() + 2);
                    if (!(negateStatusChanges.hasNext() && !statusFound || keepNoChangeStatus)) {
                        drugTokenAnt.setDrugChangeStatus(dm.getDrugChangeStatusElement());
                        drugTokenAnt.setChangeStatusBegin(dm.getChangeStatusBegin());
                        drugTokenAnt.setChangeStatusEnd(dm.getChangeStatusEnd());
                    } else {
                        drugTokenAnt.setDrugChangeStatus("noChange");
                    }
                } else if (relatedStatus != null && relatedStatus[0] != null) {
                    drugTokenAnt.setDrugChangeStatus(relatedStatus[0]);
                    drugTokenAnt.setChangeStatusBegin(new Integer(relatedStatus[1]));
                    drugTokenAnt.setChangeStatusEnd(new Integer(relatedStatus[2]));
                } else if (drugTokenAnt.getDrugChangeStatus() == null || drugTokenAnt.getDrugChangeStatus().compareTo("") == 0) {
                    drugTokenAnt.setDrugChangeStatus("noChange");
                }
                if (!keepNoChangeStatus) {
                    String relatedStatusString = null;
                    if (relatedStatus != null && relatedStatus[0] != null) {
                        relatedStatusString = relatedStatus[0];
                    }
                    float confidenceScore = this.alignDrugMentionAttributes(strengthText, dm, drugTokenAnt, recurseNER, relatedStatusString, statusFound, overrideStatus, maxExists, doseText, frequencyText, frequencyUnitText);
                    drugTokenAnt.setConfidence(confidenceScore);
                }
                if (foundPRN) {
                    drugTokenAnt.setDrugChangeStatus(drugTokenAnt.getDrugChangeStatus());
                }
                ChunkAnnotation ca = new ChunkAnnotation(jcas, begin, end);
                ca.addToIndexes();
                ca.setSentenceID(tokenAnt.getSentenceID());
                drugTokenAnt.addToIndexes();
                globalDrugNER.add(drugTokenAnt);
            }
            if (!isDrugNER) continue;
            countNER = globalDrugNER.size();
            FSArray drugNERArr = new FSArray(jcas, countNER);
            int i = 0;
            while (i < countNER) {
                drugNERArr.set(i, globalDrugNER.get(i));
                ++i;
            }
            tokenAnt.setDrugMentionArr(drugNERArr);
        }
    }

    private float alignDrugMentionAttributes(String strengthText, DrugMention dm, DrugMentionAnnotation drugTokenAnt, DrugMentionAnnotation recurseNER, String relatedStatus, boolean statusFound, boolean overrideStatus, boolean maxExists, String doseText, String frequencyText, String frequencyUnitText) {
        float keepScoreOfConfidence = 0.05f;
        if (dm.getStrengthElement() != null && dm.getStrengthElement() != "" && dm.getStrengthElement().compareTo("null") != 0) {
            keepScoreOfConfidence = 0.15f;
        }
        if (strengthText != null) {
            drugTokenAnt.setStrength(strengthText);
            drugTokenAnt.setStrengthBegin(dm.getStrengthBegin());
            drugTokenAnt.setStrengthEnd(dm.getStrengthEnd());
        } else if (recurseNER != null && recurseNER.getStrength() != null) {
            drugTokenAnt.setStrength(recurseNER.getStrength());
            drugTokenAnt.setStrengthBegin(recurseNER.getStrengthBegin());
            drugTokenAnt.setStrengthEnd(recurseNER.getStrengthEnd());
        } else if (dm.getStrengthElement() != null && dm.strength != null) {
            drugTokenAnt.setStrength(dm.getStrengthElement());
            drugTokenAnt.setStrengthBegin(dm.getStrengthBegin());
            drugTokenAnt.setStrengthEnd(dm.getStrengthEnd());
        }
        if (dm.getDosageElement() != null && dm.getDosageElement().compareTo("null") != 0 && doseText != null) {
            keepScoreOfConfidence += 0.05f;
        }
        if (doseText != null) {
            if (maxExists) {
                drugTokenAnt.setDosage("1.0");
            } else {
                drugTokenAnt.setDosage(doseText);
                drugTokenAnt.setDosageBegin(dm.getDosageBegin());
                drugTokenAnt.setDosageEnd(dm.getDosageEnd());
            }
        } else if (recurseNER != null && recurseNER.getDosage() != null) {
            drugTokenAnt.setDosage(recurseNER.getDosage());
            drugTokenAnt.setDosageBegin(recurseNER.getDosageBegin());
            drugTokenAnt.setDosageEnd(recurseNER.getDosageEnd());
        } else if (dm.getDosageElement() != null && dm.dosage != null) {
            drugTokenAnt.setDosage(dm.getDosageElement());
            drugTokenAnt.setDosageBegin(dm.getDosageBegin());
            drugTokenAnt.setDosageEnd(dm.getDosageEnd());
        }
        if (dm.getDurationElement() != null && dm.getDurationElement().compareTo("") != 0 && dm.getDurationElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.3f;
            drugTokenAnt.setDuration(dm.getDurationElement());
            drugTokenAnt.setDurationBegin(dm.getDuratationBegin());
            drugTokenAnt.setDurationEnd(dm.getDuratationEnd());
        }
        if (dm.getStartDateElement() != null && dm.getStartDateElement().compareTo("") != 0) {
            drugTokenAnt.setStartDate(dm.getStartDateElement());
        }
        if (dm.getFormElement() != null && dm.getFormElement().compareTo("") != 0 && dm.getFormElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.3f;
            drugTokenAnt.setForm(dm.getFormElement());
            drugTokenAnt.setFormBegin(dm.getFormBegin());
            drugTokenAnt.setFormEnd(dm.getFormEnd());
        } else if (recurseNER != null && recurseNER.getForm() != null) {
            drugTokenAnt.setForm(recurseNER.getForm());
            drugTokenAnt.setFormBegin(recurseNER.getFormBegin());
            drugTokenAnt.setFormEnd(recurseNER.getFormEnd());
        }
        if (dm.getFrequencyElement() != null && dm.getFrequencyElement().compareTo("") != 0 && dm.frequency != null && dm.getFrequencyElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.5f;
        }
        if (frequencyText != null) {
            if (maxExists) {
                drugTokenAnt.setFrequency("1.0");
            } else {
                drugTokenAnt.setFrequency(frequencyText);
            }
            drugTokenAnt.setFrequencyBegin(dm.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(dm.getFrequencyEnd());
        } else if (recurseNER != null && recurseNER.getFrequencyUnit() != null) {
            drugTokenAnt.setFrequency(recurseNER.getFrequency());
            drugTokenAnt.setFrequencyBegin(recurseNER.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(recurseNER.getFrequencyEnd());
        } else if (dm.getFrequencyElement() != null && dm.frequency != null) {
            drugTokenAnt.setFrequency(dm.getFrequencyElement());
            drugTokenAnt.setFrequencyBegin(dm.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(dm.getFrequencyEnd());
        }
        if (dm.getFrequencyUnitElement() != null && dm.getFrequencyUnitElement().compareTo("") != 0 && dm.frequencyUnit != null) {
            keepScoreOfConfidence *= 1.5f;
        }
        if (frequencyUnitText != null) {
            drugTokenAnt.setFrequencyUnit(frequencyUnitText);
            drugTokenAnt.setFuBegin(dm.getFUBegin());
            drugTokenAnt.setFuEnd(dm.getFUENd());
        } else if (recurseNER != null && recurseNER.getFrequencyUnit() != null) {
            drugTokenAnt.setFrequencyUnit(recurseNER.getFrequencyUnit());
            drugTokenAnt.setFuBegin(recurseNER.getFuBegin());
            drugTokenAnt.setFuEnd(recurseNER.getFuEnd());
        } else if (dm.getFrequencyElement() != null && dm.getFrequencyElement().compareTo("null") != 0 && dm.frequency != null) {
            drugTokenAnt.setFrequency(dm.getFrequencyElement());
            drugTokenAnt.setFrequencyBegin(dm.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(dm.getFrequencyEnd());
        }
        if (dm.getRouteElement() != null && dm.getRouteElement().compareTo("") != 0 && dm.getRouteElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.3f;
            drugTokenAnt.setRoute(dm.getRouteElement());
            drugTokenAnt.setRouteBegin(dm.getRouteBegin());
            drugTokenAnt.setRouteEnd(dm.getRouteEnd());
        } else if (recurseNER != null && recurseNER.getRoute() != null) {
            drugTokenAnt.setRoute(recurseNER.getRoute());
            drugTokenAnt.setRouteBegin(recurseNER.getRouteBegin());
            drugTokenAnt.setRouteEnd(recurseNER.getRouteEnd());
        }
        return keepScoreOfConfidence;
    }

    private int[] statusChangePhraseGenerator(JCas jcas, int begin, int end, boolean maxExists, Iterator uniqueNER, Iterator orderedStatusChanges, List holdStatusChanges, String[] relatedStatus, DrugMentionAnnotation drugTokenAnt, List globalDrugNER, int countNER) throws Exception {
        int[] checkSpan = new int[]{begin, end};
        handledRanges = false;
        boolean deferRight = false;
        if (orderedStatusChanges.hasNext() && !handledRanges) {
            Iterator nextStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
            DrugChangeStatusAnnotation nextDrugStatus = null;
            if (nextStatusChanges.hasNext()) {
                nextDrugStatus = (DrugChangeStatusAnnotation)nextStatusChanges.next();
            }
            DrugChangeStatusAnnotation drugStatus = (DrugChangeStatusAnnotation)orderedStatusChanges.next();
            if (nextStatusChanges.hasNext() && drugStatus.getChangeStatus().compareTo("stop") != 0) {
                nextDrugStatus = (DrugChangeStatusAnnotation)nextStatusChanges.next();
                if (drugStatus.getBegin() == nextDrugStatus.getBegin()) {
                    if (drugStatus.getEnd() < nextDrugStatus.getEnd()) {
                        drugStatus = nextDrugStatus;
                    } else {
                        nextDrugStatus = drugStatus;
                    }
                }
                if (!uniqueNER.hasNext()) {
                    if ((nextDrugStatus.getChangeStatus().compareTo("increase") == 0 || nextDrugStatus.getChangeStatus().compareTo("decrease") == 0 || nextDrugStatus.getChangeStatus().compareTo("change") == 0) && (drugStatus.getChangeStatus().compareTo("start") == 0 || drugStatus.getChangeStatus().compareTo("stop") == 0) || drugTokenAnt.getEnd() + 1 == drugStatus.getBegin()) {
                        drugStatus = nextDrugStatus;
                        deferRight = true;
                    }
                } else if (nextDrugStatus.getBegin() <= drugStatus.getEnd() + 2) {
                    if (orderedStatusChanges.hasNext() && nextDrugStatus.getBegin() != drugStatus.getBegin()) {
                        orderedStatusChanges.next();
                    } else if (!(nextDrugStatus.getChangeStatus().compareTo("increase") != 0 && nextDrugStatus.getChangeStatus().compareTo("decrease") != 0 && nextDrugStatus.getChangeStatus().compareTo("change") != 0 || drugStatus.getChangeStatus().compareTo("start") != 0 && drugStatus.getChangeStatus().compareTo("stop") != 0)) {
                        drugStatus = nextDrugStatus;
                    }
                }
                if (relatedStatus != null) {
                    end = nextDrugStatus.getBegin();
                }
            }
            if (drugStatus.getEnd() < end && !maxExists && (drugStatus.getEnd() != nextDrugStatus.getEnd() || drugStatus.getChangeStatus().compareTo("decrease") == 0 || drugStatus.getChangeStatus().compareTo("decreasefrom") == 0 || drugStatus.getChangeStatus().compareTo("increase") == 0 || drugStatus.getChangeStatus().compareTo("increasefrom") == 0) || drugStatus.getChangeStatus().compareTo("change") == 0) {
                checkSpan = this.generateAdditionalNER(jcas, drugTokenAnt, drugStatus, begin, end, countNER, globalDrugNER);
            }
        }
        return checkSpan;
    }

    private int[] generateAdditionalNER(JCas jcas, DrugMentionAnnotation tokenDrugNER, DrugChangeStatusAnnotation drugChangeStatus, int beginSpan, int endSpan, int count, List globalNER) throws Exception {
        boolean noPriorMention = false;
        boolean noPostMention = false;
        int originalEndSpan = endSpan;
        int originalBeginSpan = beginSpan;
        NamedEntity neAnnot = new NamedEntity(jcas, tokenDrugNER.getBegin(), tokenDrugNER.getEnd());
        int beginChunk = drugChangeStatus.getEnd();
        DrugMention compareDM = new DrugMention(jcas, beginChunk, endSpan);
        DrugMention priorDM = new DrugMention(jcas, beginSpan, drugChangeStatus.getBegin());
        if (priorDM.dosage == null && priorDM.strength == null && priorDM.frequency == null) {
            noPriorMention = true;
        }
        if (compareDM.dosage == null && compareDM.strength == null && compareDM.frequency == null) {
            noPostMention = true;
        }
        ++count;
        if (!noPriorMention) {
            if (priorDM.dosage != null) {
                tokenDrugNER.setDosage(priorDM.getDosageElement());
                tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
            }
            if (priorDM.strength != null) {
                tokenDrugNER.setStrength(priorDM.getStrengthElement());
                tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
            }
            if (priorDM.frequency != null) {
                tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
                tokenDrugNER.setFrequencyBegin(priorDM.getFrequencyBegin());
                tokenDrugNER.setFrequencyEnd(priorDM.getFrequencyEnd());
            }
        }
        neAnnot.setTypeID(1);
        int[] updatedSpan = new int[]{beginSpan, endSpan};
        ArrayList<NamedEntity> buildNewNER = new ArrayList<NamedEntity>();
        buildNewNER.add(neAnnot);
        if (drugChangeStatus.getChangeStatus().compareTo("decrease") == 0) {
            int endChunk = 0;
            int startChunk = 0;
            int midChunk = 0;
            if (noPriorMention) {
                startChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false)[0];
                midChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[0];
                endChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[1];
            }
            updatedSpan[0] = beginChunk;
            String[] changeStatusArray = new String[]{"decrease", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, midChunk, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                compareDM = new DrugMention(jcas, startChunk, endChunk);
                if (compareDM.dosage != null) {
                    tokenDrugNER.setDosage(compareDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(compareDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(compareDM.getDosageEnd());
                }
                if (compareDM.strength != null) {
                    tokenDrugNER.setStrength(compareDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(compareDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(compareDM.getStrengthEnd());
                }
                if (compareDM.frequency != null) {
                    tokenDrugNER.setFrequency(compareDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(compareDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(compareDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("noChange");
        } else if (drugChangeStatus.getChangeStatus().compareTo("decreasefrom") == 0) {
            if (noPriorMention) {
                beginChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[0];
            }
            String[] changeStatusArray = new String[]{"decrease", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                priorDM = new DrugMention(jcas, originalBeginSpan, beginChunk);
                if (priorDM.dosage != null) {
                    tokenDrugNER.setDosage(priorDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
                }
                if (priorDM.strength != null) {
                    tokenDrugNER.setStrength(priorDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
                }
                if (priorDM.frequency != null) {
                    tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(priorDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(priorDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("noChange");
        } else if (drugChangeStatus.getChangeStatus().compareTo("increase") == 0) {
            if (noPriorMention) {
                endSpan = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[0];
            }
            updatedSpan[0] = beginChunk;
            String[] changeStatusArray = new String[]{"increase", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                compareDM = new DrugMention(jcas, endSpan, originalEndSpan);
                if (compareDM.dosage != null) {
                    tokenDrugNER.setDosage(compareDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(compareDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(compareDM.getDosageEnd());
                }
                if (compareDM.strength != null) {
                    tokenDrugNER.setStrength(compareDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(compareDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(compareDM.getStrengthEnd());
                }
                if (compareDM.frequency != null) {
                    tokenDrugNER.setFrequency(compareDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(compareDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(compareDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("change");
        } else if (drugChangeStatus.getChangeStatus().compareTo("increasefrom") == 0) {
            int startChunk = 0;
            int endChunk = 0;
            int midChunk = 0;
            if (noPriorMention) {
                startChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false)[0];
                midChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false)[1];
                endChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[1];
            }
            String[] changeStatusArray = new String[]{"increase", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, startChunk, endChunk, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                priorDM = new DrugMention(jcas, originalBeginSpan, midChunk);
                if (priorDM.dosage != null) {
                    tokenDrugNER.setDosage(priorDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
                }
                if (priorDM.strength != null) {
                    tokenDrugNER.setStrength(priorDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
                }
                if (priorDM.frequency != null) {
                    tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(priorDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(priorDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("noChange");
        } else if (drugChangeStatus.getChangeStatus().compareTo("stop") == 0) {
            tokenDrugNER.setDrugChangeStatus(tokenDrugNER.getDrugChangeStatus());
        } else if (drugChangeStatus.getChangeStatus().compareTo("change") == 0 || drugChangeStatus.getChangeStatus().compareTo("add") == 0) {
            double strengthChange = 1.0;
            double dosageChange = 1.0;
            double frequencyChange = 1.0;
            if (noPriorMention) {
                int[] updateSpan = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false);
                compareDM = new DrugMention(jcas, endSpan, originalEndSpan);
                if (compareDM.dosage != null) {
                    tokenDrugNER.setDosage(compareDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(compareDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(compareDM.getDosageEnd());
                }
                if (compareDM.strength != null) {
                    tokenDrugNER.setStrength(compareDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(compareDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(compareDM.getStrengthEnd());
                }
                if (compareDM.frequency != null) {
                    tokenDrugNER.setFrequency(compareDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(compareDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(compareDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("change");
            if (compareDM.getStrengthElement() != null && compareDM.getStrengthElement().compareTo("") != 0 && compareDM != null) {
                strengthChange = new Double(compareDM.parseDoubleValue(compareDM.getStrengthElement()));
            } else if (priorDM.getStrengthElement() != null && priorDM.getStrengthElement().compareTo("") != 0 && priorDM.getStrengthElement().length() > 0) {
                int spacePosition = priorDM.getStrengthElement().indexOf(" ");
                strengthChange = spacePosition > 0 ? new Double(priorDM.parseDoubleValue(priorDM.getStrengthElement().substring(0, spacePosition))).doubleValue() : new Double(priorDM.parseDoubleValue(priorDM.getStrengthElement())).doubleValue();
            }
            if (compareDM.getDosageElement() != null && compareDM.getDosageElement().compareTo("") != 0) {
                dosageChange = new Double(compareDM.parseDoubleValue(compareDM.getDosageElement()));
            } else if (priorDM.getDosageElement() != null && priorDM.getDosageElement().compareTo("") != 0) {
                dosageChange = new Double(priorDM.parseDoubleValue(priorDM.getDosageElement()));
            }
            if (compareDM.getFrequencyElement() != null && compareDM.getFrequencyElement().compareTo("") != 0) {
                frequencyChange = new Double(compareDM.parseDoubleValue(compareDM.getFrequencyElement()));
            } else if (priorDM.getFrequencyElement() != null && priorDM.getFrequencyElement().compareTo("") != 0) {
                frequencyChange = new Double(priorDM.parseDoubleValue(priorDM.getFrequencyElement()));
            }
            double strengthBefore = 1.0;
            double dosageBefore = 1.0;
            double frequencyBefore = 1.0;
            if (priorDM.getStrengthElement() != null && priorDM.getStrengthElement().compareTo("") != 0 && priorDM.getStrengthElement().length() > 0) {
                strengthBefore = new Double(priorDM.parseDoubleValue(priorDM.getStrengthElement()));
                tokenDrugNER.setStrength(priorDM.getStrengthElement());
                tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
            } else if (tokenDrugNER.getStrength() != null && tokenDrugNER.getStrength().compareTo("") != 0 && tokenDrugNER.getStrength().length() > 0) {
                int spacePosition;
                boolean handledSeparator = false;
                int hyphPosition = tokenDrugNER.getStrength().indexOf(45);
                String hyphString = tokenDrugNER.getStrength();
                if (hyphPosition > 0) {
                    hyphString = tokenDrugNER.getStrength().substring(0, hyphPosition);
                    strengthBefore = new Double(compareDM.parseDoubleValue(compareDM.convertFromTextToNum(hyphString)));
                    handledSeparator = true;
                }
                if ((spacePosition = hyphString.indexOf(" ")) > 0) {
                    hyphString = hyphString.substring(0, spacePosition);
                    strengthBefore = new Double(priorDM.parseDoubleValue(priorDM.convertFromTextToNum(hyphString)));
                    handledSeparator = true;
                }
                if (!handledSeparator) {
                    strengthBefore = new Double(compareDM.parseDoubleValue(tokenDrugNER.getStrength()));
                }
            }
            if (priorDM.getDosageElement() != null && priorDM.getDosageElement().compareTo("") != 0 && priorDM.dosage != null) {
                dosageBefore = new Double(priorDM.getDosageElement());
                tokenDrugNER.setDosage(priorDM.getDosageElement());
                tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
            } else if (tokenDrugNER.getDosage() != null && tokenDrugNER.getDosage().compareTo("") != 0) {
                dosageBefore = new Double(compareDM.parseDoubleValue(tokenDrugNER.getDosage()));
            }
            if (priorDM.getFrequencyElement() != null && priorDM.getFrequencyElement().compareTo("") != 0) {
                frequencyBefore = new Double(priorDM.parseDoubleValue(priorDM.getFrequencyElement()));
                tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
            } else if (tokenDrugNER.getFrequency() != null && tokenDrugNER.getFrequency().compareTo("") != 0) {
                frequencyBefore = new Double(compareDM.parseDoubleValue(tokenDrugNER.getFrequency()));
            }
            if (drugChangeStatus.getChangeStatus().compareTo("add") == 0 && (strengthChange > 1.0 && strengthBefore > 1.0 || strengthChange == strengthBefore)) {
                FSIterator findLF = FSUtil.getAnnotationsIteratorInSpan(jcas, NewlineToken.type, neAnnot.getBegin(), beginChunk);
                if (!findLF.hasNext()) {
                    if (frequencyChange <= 1.0 && frequencyBefore > 1.0) {
                        tokenDrugNER.setFrequency("1.0");
                    }
                    String[] changeStatusArray = new String[]{"add", new Integer(0).toString(), new Integer(0).toString()};
                    this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
                }
            } else if (strengthChange * dosageChange * frequencyChange > strengthBefore * dosageBefore * frequencyBefore) {
                String[] changeStatusArray = new String[]{"increase", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
                this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            } else {
                String[] changeStatusArray = new String[]{"decrease", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
                this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            }
            tokenDrugNER.setDrugChangeStatus("change");
        }
        return updatedSpan;
    }

    private edu.mayo.bmi.fsm.token.BaseToken adaptToFSMBaseToken(BaseToken obj) throws Exception {
        if (obj instanceof WordToken) {
            WordToken wta = (WordToken)obj;
            return new WordTokenAdapter(wta);
        }
        if (obj instanceof NumToken) {
            NumToken nta = (NumToken)obj;
            if (nta.getNumType() == 1) {
                return new IntegerTokenAdapter(nta);
            }
            return new DecimalTokenAdapter(nta);
        }
        if (obj instanceof PunctuationToken) {
            PunctuationToken pta = (PunctuationToken)obj;
            return new PunctuationTokenAdapter(pta);
        }
        if (obj instanceof NewlineToken) {
            NewlineToken nta = (NewlineToken)obj;
            return new NewlineTokenAdapter(nta);
        }
        if (obj instanceof ContractionToken) {
            ContractionToken cta = (ContractionToken)obj;
            return new ContractionTokenAdapter(cta);
        }
        if (obj instanceof SymbolToken) {
            SymbolToken sta = (SymbolToken)obj;
            return new SymbolTokenAdapter(sta);
        }
        throw new Exception("No CDT adapter for class: " + obj.getClass());
    }

    private boolean findNextDrugEntityPost(int spanLength, int[][] elementSpan, NamedEntity nea, int endPhrase) {
        boolean patternFound = false;
        int l = 0;
        while (l < spanLength && !patternFound) {
            if (elementSpan[l][0] != -1 && elementSpan[l][0] > nea.getBegin() && elementSpan[l][0] < endPhrase) {
                patternFound = true;
            }
            ++l;
        }
        return patternFound;
    }

    private boolean findNextDrugEntityPre(int spanLength, int[][] elementSpan, NamedEntity nea, int priorDrugEnd) {
        boolean patternFound = false;
        int l = 0;
        while (l < spanLength && !patternFound) {
            if (elementSpan[l][0] != -1 && elementSpan[l][1] < nea.getBegin() && elementSpan[l][0] > priorDrugEnd) {
                patternFound = true;
            }
            ++l;
        }
        return patternFound;
    }

    private boolean findNextParenRelativeToNE(int spanLength, int[][] elementSpan, NamedEntity nea, int priorDrugEnd, int startOffset) {
        boolean patternFound = false;
        int l = startOffset;
        while (l < spanLength && !patternFound) {
            if (elementSpan[l][0] != -1 && elementSpan[l][0] < nea.getBegin() && elementSpan[l][1] > priorDrugEnd) {
                patternFound = true;
            }
            ++l;
        }
        return patternFound;
    }

    private boolean findNextParenRelativeToElement(int spanLength, int[][] elementSpan, Annotation nea, int parenEnd, int startOffset) {
        boolean patternFound = false;
        int l = startOffset;
        while (l < spanLength && !patternFound) {
            if (elementSpan[l][0] != -1 && elementSpan[l][0] < nea.getBegin() && elementSpan[l][1] == parenEnd && nea.getEnd() < elementSpan[l][1]) {
                patternFound = true;
            }
            ++l;
        }
        return patternFound;
    }

    private boolean hasMultipleDrugsInSpan(JCas jcas, int begin, int end) {
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] validNeTypes = nArray;
        int numDrugs = FSUtil.countAnnotationsInSpan(jcas, NamedEntity.type, begin, end, validNeTypes);
        return numDrugs > 1;
    }

    private boolean hasMultipleElementsInSpan(JCas jcas, int begin, int end) {
        int numElements = 0;
        numElements += FSUtil.isAnnotationPresentInSpan(jcas, StrengthAnnotation.type, begin, end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan(jcas, FrequencyAnnotation.type, begin, end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan(jcas, FrequencyUnitAnnotation.type, begin, end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan(jcas, DosagesAnnotation.type, begin, end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan(jcas, FormAnnotation.type, begin, end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan(jcas, RouteAnnotation.type, begin, end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan(jcas, DurationAnnotation.type, begin, end) ? 1 : 0;
        return (numElements += FSUtil.isAnnotationPresentInSpan(jcas, DrugChangeStatusAnnotation.type, begin, end) ? 1 : 0) > 1;
    }

    private int[] getSentenceSpanContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int[] span = new int[2];
        while (iter.hasNext()) {
            Sentence sa = (Sentence)iter.next();
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            span[0] = sa.getBegin();
            span[1] = sa.getEnd();
            break;
        }
        return span;
    }

    private void findFSMInRange(JCas jcas, int begin, int end) throws Exception {
        NamedEntity ne = null;
        WordToken we = null;
        FSIterator btaItr = FSUtil.getAnnotationsInSpanIterator(jcas, BaseToken.type, begin, end + 1);
        FSIterator neItr = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, begin, end + 1);
        FSIterator weItr = FSUtil.getAnnotationsInSpanIterator(jcas, WordToken.type, begin, end + 1);
        ArrayList<WordToken> weTokenList = new ArrayList<WordToken>();
        while (weItr.hasNext()) {
            we = (WordToken)weItr.next();
            weTokenList.add(we);
        }
        ArrayList<NamedEntity> neTokenList = new ArrayList<NamedEntity>();
        while (neItr.hasNext()) {
            ne = (NamedEntity)neItr.next();
            neTokenList.add(ne);
        }
        ArrayList<edu.mayo.bmi.fsm.token.BaseToken> baseTokenList = new ArrayList<edu.mayo.bmi.fsm.token.BaseToken>();
        while (btaItr.hasNext()) {
            BaseToken bta = (BaseToken)btaItr.next();
            baseTokenList.add(this.adaptToFSMBaseToken(bta));
        }
        this.executeFSMs(jcas, baseTokenList, neTokenList, weTokenList);
    }

    private int[] findOffsetsInPattern(JCas jcas, int begin, int end, int elementType, int[][] location, boolean highest) {
        int[] lastLocation;
        block7: {
            boolean wantMuliple;
            FSIterator neItr;
            block8: {
                block6: {
                    JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                    neItr = indexes.getAnnotationIndex(elementType).iterator();
                    lastLocation = new int[]{-1, -1};
                    wantMuliple = true;
                    if (elementType != StrengthAnnotation.type) break block6;
                    while (neItr.hasNext() && wantMuliple) {
                        StrengthAnnotation nea = (StrengthAnnotation)neItr.next();
                        if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                        if (!highest) {
                            wantMuliple = false;
                        }
                        lastLocation[0] = nea.getBegin();
                        lastLocation[1] = nea.getEnd();
                    }
                    break block7;
                }
                if (elementType != FrequencyAnnotation.type) break block8;
                while (neItr.hasNext() && wantMuliple) {
                    FrequencyAnnotation nea = (FrequencyAnnotation)neItr.next();
                    if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                    if (!highest) {
                        wantMuliple = false;
                    }
                    lastLocation[0] = nea.getBegin();
                    lastLocation[1] = nea.getEnd();
                }
                break block7;
            }
            if (elementType != DosagesAnnotation.type) break block7;
            while (neItr.hasNext() && wantMuliple) {
                DosagesAnnotation nea = (DosagesAnnotation)neItr.next();
                if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                if (!highest) {
                    wantMuliple = false;
                }
                lastLocation[0] = nea.getBegin();
                lastLocation[1] = nea.getEnd();
            }
        }
        return lastLocation;
    }

    private int[] getAdjustedWindowSpan(JCas jcas, int begin, int end, boolean highestRange) throws Exception {
        int[] spanStrength = new int[]{-1, -1};
        int[] spanFrequency = new int[]{-1, -1};
        int[] spanDose = new int[]{-1, -1};
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        int[] senSpan = new int[]{begin, end};
        int[][] strengthSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] freqSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] doseSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] parenthesisSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] statusSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        boolean drugSpanLength = false;
        int strengthSpanLength = 0;
        int freqSpanLength = 0;
        int doseSpanLength = 0;
        int beginSpan = senSpan[0];
        int endSpan = senSpan[1];
        freqSpanLength = this.findInPattern(jcas, beginSpan, endSpan, FrequencyAnnotation.type, freqSpan);
        doseSpanLength = this.findInPattern(jcas, beginSpan, endSpan, DosagesAnnotation.type, doseSpan);
        int parenthesisSpanLength = this.findInPattern(jcas, beginSpan, endSpan, PunctuationToken.type, parenthesisSpan);
        strengthSpanLength = this.findInPattern(jcas, beginSpan, endSpan, StrengthAnnotation.type, strengthSpan);
        spanStrength = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, StrengthAnnotation.type, strengthSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, StrengthAnnotation.type, strengthSpan, highestRange);
        spanFrequency = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, FrequencyAnnotation.type, strengthSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, FrequencyAnnotation.type, strengthSpan, highestRange);
        int[] nArray = spanDose = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, DosagesAnnotation.type, doseSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, DosagesAnnotation.type, doseSpan, highestRange);
        if (spanStrength[0] == -1 && spanFrequency[0] == -1 && spanDose[0] == -1) {
            return senSpan;
        }
        if (highestRange && spanStrength[0] != -1) {
            senSpan = spanStrength[0] > spanFrequency[0] ? spanStrength : spanFrequency;
        } else if (spanFrequency[0] != -1) {
            senSpan = spanStrength[0] < spanFrequency[0] ? spanStrength : spanFrequency;
        }
        return spanDose[0] > senSpan[0] ? spanDose : senSpan;
    }

    private int findInPattern(JCas jcas, int begin, int end, int elementType, int[][] location) {
        int counter;
        block14: {
            int[] lastLocation;
            FSIterator neItr;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block13: {
                                                JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                                                neItr = indexes.getAnnotationIndex(elementType).iterator();
                                                lastLocation = new int[]{-1, -1};
                                                counter = 0;
                                                if (elementType != StrengthAnnotation.type) break block13;
                                                while (neItr.hasNext()) {
                                                    StrengthAnnotation nea = (StrengthAnnotation)neItr.next();
                                                    lastLocation[0] = nea.getBegin();
                                                    lastLocation[1] = nea.getEnd();
                                                    if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                                    location[counter][0] = lastLocation[0];
                                                    location[counter][1] = lastLocation[1];
                                                    ++counter;
                                                }
                                                break block14;
                                            }
                                            if (elementType != FrequencyAnnotation.type) break block15;
                                            while (neItr.hasNext()) {
                                                FrequencyAnnotation nea = (FrequencyAnnotation)neItr.next();
                                                lastLocation[0] = nea.getBegin();
                                                lastLocation[1] = nea.getEnd();
                                                if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                                location[counter][0] = lastLocation[0];
                                                location[counter][1] = lastLocation[1];
                                                ++counter;
                                            }
                                            break block14;
                                        }
                                        if (elementType != FrequencyUnitAnnotation.type) break block16;
                                        while (neItr.hasNext()) {
                                            FrequencyUnitAnnotation nea = (FrequencyUnitAnnotation)neItr.next();
                                            lastLocation[0] = nea.getBegin();
                                            lastLocation[1] = nea.getEnd();
                                            if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                            location[counter][0] = lastLocation[0];
                                            location[counter][1] = lastLocation[1];
                                            ++counter;
                                        }
                                        break block14;
                                    }
                                    if (elementType != DosagesAnnotation.type) break block17;
                                    while (neItr.hasNext()) {
                                        DosagesAnnotation nea = (DosagesAnnotation)neItr.next();
                                        lastLocation[0] = nea.getBegin();
                                        lastLocation[1] = nea.getEnd();
                                        if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                        location[counter][0] = lastLocation[0];
                                        location[counter][1] = lastLocation[1];
                                        ++counter;
                                    }
                                    break block14;
                                }
                                if (elementType != RouteAnnotation.type) break block18;
                                while (neItr.hasNext()) {
                                    RouteAnnotation nea = (RouteAnnotation)neItr.next();
                                    lastLocation[0] = nea.getBegin();
                                    lastLocation[1] = nea.getEnd();
                                    if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                                    location[counter][0] = lastLocation[0];
                                    location[counter][1] = lastLocation[1];
                                    ++counter;
                                }
                                break block14;
                            }
                            if (elementType != FormAnnotation.type) break block19;
                            while (neItr.hasNext()) {
                                FormAnnotation nea = (FormAnnotation)neItr.next();
                                lastLocation[0] = nea.getBegin();
                                lastLocation[1] = nea.getEnd();
                                if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                location[counter][0] = lastLocation[0];
                                location[counter][1] = lastLocation[1];
                                ++counter;
                            }
                            break block14;
                        }
                        if (elementType != DurationAnnotation.type) break block20;
                        while (neItr.hasNext()) {
                            DurationAnnotation nea = (DurationAnnotation)neItr.next();
                            lastLocation[0] = nea.getBegin();
                            lastLocation[1] = nea.getEnd();
                            if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                            location[counter][0] = lastLocation[0];
                            location[counter][1] = lastLocation[1];
                            ++counter;
                        }
                        break block14;
                    }
                    if (elementType != DrugChangeStatusAnnotation.type) break block21;
                    while (neItr.hasNext()) {
                        DrugChangeStatusAnnotation nea = (DrugChangeStatusAnnotation)neItr.next();
                        lastLocation[0] = nea.getBegin();
                        lastLocation[1] = nea.getEnd();
                        if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                        location[counter][0] = lastLocation[0];
                        location[counter][1] = lastLocation[1];
                        ++counter;
                    }
                    break block14;
                }
                if (elementType != NamedEntity.type) break block22;
                while (neItr.hasNext()) {
                    NamedEntity nea = (NamedEntity)neItr.next();
                    if (nea.getTypeID() != 1 && nea.getTypeID() != 0) continue;
                    lastLocation[0] = nea.getBegin();
                    lastLocation[1] = nea.getEnd();
                    if (counter != 0 && lastLocation[0] == location[counter - 1][0] || nea.getBegin() < begin || nea.getEnd() > end) continue;
                    location[counter][0] = lastLocation[0];
                    location[counter][1] = lastLocation[1];
                    ++counter;
                }
                break block14;
            }
            if (elementType != PunctuationToken.type) break block14;
            while (neItr.hasNext()) {
                boolean foundPair = false;
                PunctuationToken nea = (PunctuationToken)neItr.next();
                if (nea.getCoveredText().compareTo("(") == 0) {
                    lastLocation[0] = nea.getBegin();
                } else if (nea.getCoveredText().compareTo(")") == 0) {
                    lastLocation[1] = nea.getEnd();
                    foundPair = true;
                }
                if (nea.getBegin() < begin || nea.getEnd() > end || !foundPair || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                location[counter][0] = lastLocation[0];
                location[counter][1] = lastLocation[1];
                ++counter;
            }
        }
        return counter;
    }
}

