/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.drugner.cc;

import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.DocumentID;
import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.OntologyConcept;
import edu.mayo.bmi.uima.core.type.Properties;
import edu.mayo.bmi.uima.core.type.Property;
import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.drugner.type.ChunkAnnotation;
import edu.mayo.bmi.uima.drugner.type.DrugMentionAnnotation;
import edu.mayo.bmi.uima.drugner.type.SubSectionAnnotation;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class ConsumeNamedEntityRecordModel
extends CasConsumer_ImplBase {
    private String iv_annotVerPropKey;
    protected ArrayList al = new ArrayList();
    File iv_outputDirectory;
    int keepTrackOfDupBegin = 0;
    int keepTrackOfDupEnd = 0;
    int milliWeek = 604800000;
    int milliDay = 86400000;
    private int iv_annotVer;
    private boolean gotValidDate = false;
    private boolean gotDup = false;
    private String vRevDate = null;
    private String vNoteDate = null;
    private String vClinicalNumber = null;
    private String clinicNumber = null;
    private String docLinkId = "";
    private String docRevision = "";
    private String iv_fileForInput = null;
    private String pathToDrugInclusions;
    private Set<String> iv_medicalSections = new HashSet<String>();
    private String drugHeaders = "clinicNumber,drug_mention_text,rxnorm_cui,local_date,note_date,dosage,strength,frequency,frequency_unit,duration,route,form,status,change_status,certainty,section|subsection|status,documentId_revision\n";
    private Boolean iv_useCurrentMedsSectionOnly = new Boolean("true");
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    private String fileForIO = new String("R:\\Dept\\projects\\Text\\DrugProfile\\data\\psychiatry\\goldStandard\\work.csv");

    @Override
    public void initialize() throws ResourceInitializationException {
        this.fileForIO = (String)this.getConfigParameterValue(PARAM_OUTPUTDIR);
        this.iv_outputDirectory = new File(this.fileForIO);
        this.iv_useCurrentMedsSectionOnly = (Boolean)this.getConfigParameterValue("useMedicationSectionOnly");
        this.pathToDrugInclusions = (String)this.getConfigParameterValue("filterGroupDrugs");
        this.iv_fileForInput = (String)this.getConfigParameterValue("locationForClinicRcdInput");
        String holdListMedSections = (String)this.getConfigParameterValue("listMedicationSection");
        StringTokenizer nextMedSection = new StringTokenizer(holdListMedSections, "|");
        while (nextMedSection.hasMoreTokens()) {
            this.iv_medicalSections.add(nextMedSection.nextToken());
        }
        if (!this.iv_outputDirectory.exists() || !this.iv_outputDirectory.isDirectory()) {
            if (!this.iv_outputDirectory.exists()) {
                new File(this.fileForIO).mkdir();
            } else {
                throw new ResourceInitializationException(new Exception("Parameter setting 'OutputDirectory' does not point to an existing directory."));
            }
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        this.vRevDate = "";
        this.vNoteDate = "";
        this.vClinicalNumber = "";
        this.gotValidDate = false;
        this.gotDup = false;
        this.clinicNumber = "";
        this.generateTokenNormForms(cas);
        this.assignNamedEntityFeats(cas);
    }

    private void storeAnnotationVersion(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            FSIterator itr = jcas.getJFSIndexRepository().getAnnotationIndex(Properties.type).iterator();
            if (itr == null || !itr.hasNext()) {
                return;
            }
            Properties props = (Properties)itr.next();
            FSArray propArr = props.getPropArr();
            FSArray newPropArr = new FSArray(jcas, propArr.size() + 1);
            int i = 0;
            while (i < propArr.size()) {
                newPropArr.set(i, propArr.get(i));
                ++i;
            }
            Property annotVerProp = new Property(jcas);
            annotVerProp.setKey(this.iv_annotVerPropKey);
            annotVerProp.setValue(String.valueOf(this.iv_annotVer));
            newPropArr.set(newPropArr.size() - 1, annotVerProp);
            props.setPropArr(newPropArr);
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }

    private void generateTokenNormForms(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas().getView("plaintext");
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator propertiesItr = indexes.getAnnotationIndex(Properties.type).iterator();
            while (propertiesItr.hasNext()) {
                Properties props = (Properties)propertiesItr.next();
                FSArray fsArr = props.getPropArr();
                int i = 0;
                while (i < fsArr.size()) {
                    if (fsArr.get(i) != null) {
                        Property fs = (Property)fsArr.get(i);
                        if (fs.getKey().compareTo("REV_DATE") == 0) {
                            this.gotValidDate = true;
                            this.vRevDate = fs.getValue();
                        } else if (fs.getKey().compareTo("NOTE_DATE") == 0) {
                            this.vNoteDate = fs.getValue();
                        } else if (fs.getKey().compareTo("CLINICAL_NUMBER") == 0) {
                            this.vClinicalNumber = fs.getValue().length() < 8 ? "0" + fs.getValue() : fs.getValue();
                        }
                    }
                    ++i;
                }
            }
            HashMap<Integer, DocumentID> abbrMap = new HashMap<Integer, DocumentID>();
            FSIterator docItr = indexes.getAnnotationIndex(DocumentID.type).iterator();
            while (docItr.hasNext()) {
                DocumentID doc = (DocumentID)docItr.next();
                if (this.gotValidDate) {
                    this.clinicNumber = this.vClinicalNumber;
                }
                abbrMap.put(new Integer(doc.getBegin()), doc);
            }
            FSIterator btaItr = indexes.getAnnotationIndex(BaseToken.type).iterator();
            while (btaItr.hasNext()) {
                BaseToken bta = (BaseToken)btaItr.next();
                String normForm = null;
                bta.setNormalizedForm(normForm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceProcessException(e);
        }
    }

    private void assignNamedEntityFeats(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas().getView("plaintext");
            boolean gotMeds = false;
            int trackMedOccur = 0;
            String medInfo = "";
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            HashSet<Segment> segmentSet = new HashSet<Segment>();
            FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
            while (segmentItr.hasNext()) {
                Segment s = (Segment)segmentItr.next();
                segmentSet.add(s);
            }
            FSIterator nerItr = indexes.getAnnotationIndex(DrugMentionAnnotation.type).iterator();
            while (nerItr.hasNext()) {
                DrugMentionAnnotation neAnnot = (DrugMentionAnnotation)nerItr.next();
                this.gotDup = false;
                for (Segment seg : segmentSet) {
                    if (this.keepTrackOfDupBegin == neAnnot.getBegin() && this.keepTrackOfDupEnd == neAnnot.getEnd()) {
                        this.gotDup = true;
                    }
                    if (neAnnot.getBegin() < seg.getBegin() || neAnnot.getEnd() > seg.getEnd() || this.gotDup) continue;
                    String segmentID = seg.getId();
                    System.err.println("Checking if segmentID [" + segmentID + "] is valid - NE[" + neAnnot.getCoveredText() + "]");
                    if (!this.iv_medicalSections.contains(segmentID) && this.iv_useCurrentMedsSectionOnly.booleanValue() || this.gotDup) continue;
                    this.keepTrackOfDupBegin = neAnnot.getBegin();
                    this.keepTrackOfDupEnd = neAnnot.getEnd();
                    String strengthTerm = neAnnot.getStrength();
                    String localDate = neAnnot.getStartDate();
                    String chunk = null;
                    boolean foundChunk = false;
                    FSIterator findChunk = indexes.getAnnotationIndex(ChunkAnnotation.type).iterator();
                    while (findChunk.hasNext() && !foundChunk) {
                        ChunkAnnotation ca = (ChunkAnnotation)findChunk.next();
                        if (neAnnot.getBegin() < ca.getBegin() || neAnnot.getEnd() > ca.getEnd()) continue;
                        chunk = ca.getCoveredText().replace('\n', ' ').replace(',', ';');
                        foundChunk = true;
                    }
                    String containedInSubSection = segmentID;
                    FSIterator subSectionItr = indexes.getAnnotationIndex(SubSectionAnnotation.type).iterator();
                    while (subSectionItr.hasNext()) {
                        SubSectionAnnotation ssAnnot = (SubSectionAnnotation)subSectionItr.next();
                        if (ssAnnot.getSubSectionBodyBegin() > neAnnot.getBegin() || ssAnnot.getSubSectionBodyEnd() < neAnnot.getEnd()) continue;
                        FSIterator textSpanInSs = FSUtil.getAnnotationsIteratorInSpan(jcas, WordToken.type, ssAnnot.getSubSectionHeaderBegin(), ssAnnot.getSubSectionHeaderEnd());
                        String subSectionHeaderName = "";
                        while (textSpanInSs.hasNext()) {
                            WordToken wta = (WordToken)textSpanInSs.next();
                            subSectionHeaderName = String.valueOf(subSectionHeaderName) + " " + wta.getCoveredText();
                        }
                        containedInSubSection = String.valueOf(containedInSubSection) + "|" + subSectionHeaderName + "|" + ssAnnot.getStatus();
                    }
                    gotMeds = true;
                    ++trackMedOccur;
                    Calendar calendar = Calendar.getInstance();
                    SimpleDateFormat format = new SimpleDateFormat("MM'/'dd'/'yyyy");
                    if (this.vRevDate != null && this.vRevDate.length() > 0) {
                        calendar.setTimeInMillis(new Long(this.vRevDate));
                    } else if (this.vNoteDate != null && this.vNoteDate.length() > 0) {
                        calendar.setTimeInMillis(new Long(this.vNoteDate));
                    }
                    String globalDate = format.format(calendar.getTime());
                    if (localDate == null || localDate.length() < 1) {
                        localDate = globalDate;
                    }
                    FSIterator neItr = FSUtil.getAnnotationsIteratorInSpan(jcas, NamedEntity.type, neAnnot.getBegin(), neAnnot.getEnd() + 1);
                    String neCui = "n/a";
                    String status = "n/a";
                    String rxNormCui = "n/a";
                    if (neItr.hasNext()) {
                        FSArray ocArr;
                        NamedEntity ne = (NamedEntity)neItr.next();
                        status = new Integer(ne.getStatus()).toString();
                        if (ne.getTypeID() == 1 && (ocArr = ne.getOntologyConceptArr()) != null) {
                            int i = 0;
                            while (i < ocArr.size()) {
                                OntologyConcept oc = (OntologyConcept)ocArr.get(i);
                                neCui = oc.getCode();
                                rxNormCui = oc.getOui();
                                ++i;
                            }
                        }
                    }
                    medInfo = String.valueOf(this.clinicNumber) + "," + neAnnot.getCoveredText() + "," + rxNormCui + ",\"" + neAnnot.getStartDate() + "\"," + globalDate + "," + neAnnot.getDosage() + "," + strengthTerm + "," + neAnnot.getFrequency() + "," + neAnnot.getFrequencyUnit() + "," + neAnnot.getDuration() + "," + neAnnot.getRoute() + "," + neAnnot.getForm() + "," + status + "," + neAnnot.getDrugChangeStatus() + "," + neAnnot.getConfidence() + "," + containedInSubSection + "," + this.docLinkId + "_" + this.docRevision + "," + chunk;
                    this.store(this.fileForIO, medInfo);
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }

    public static List load(String filename) throws FileNotFoundException, IOException {
        String[][] idDate = null;
        ArrayList<String[][]> listIDandDates = new ArrayList<String[][]>();
        File f = new File(filename);
        BufferedReader br = new BufferedReader(new FileReader(f));
        br.readLine();
        br.readLine();
        String line = br.readLine();
        int index = 0;
        while (line != null && line != "" && line.length() > 0) {
            int firstComma = line.indexOf(44);
            int lastComma = line.lastIndexOf(44);
            String id = line.substring(0, firstComma);
            String date = line.substring(lastComma + 1, line.indexOf("0:00"));
            idDate = new String[][]{{id}, {date}};
            listIDandDates.add(index, idDate);
            ++index;
            line = br.readLine();
        }
        br.close();
        return listIDandDates;
    }

    public void store(String filename, String lineToStore) throws FileNotFoundException, IOException {
        int howMany = 132;
        boolean skipDate = false;
        boolean preExists = true;
        File f = new File(filename = filename.endsWith(System.getProperty("file.separator")) ? String.valueOf(filename) + lineToStore.substring(0, lineToStore.indexOf(44)) + ".csv" : String.valueOf(filename) + "/" + lineToStore.substring(0, lineToStore.indexOf(44)) + ".csv");
        if (!f.exists()) {
            f.createNewFile();
            preExists = false;
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        br.readLine();
        br.close();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(howMany * 4);
        DataOutputStream dout = new DataOutputStream(bout);
        FileOutputStream fos = new FileOutputStream(filename, true);
        if (!preExists) {
            dout.writeBytes(this.drugHeaders);
        }
        if (!skipDate) {
            dout.writeBytes(String.valueOf(lineToStore) + '\n');
        }
        try {
            if (!skipDate) {
                bout.writeTo(fos);
                fos.flush();
            }
        }
        finally {
            fos.close();
        }
    }

    protected String parseStengthValue(Object strength) {
        String text = (String)strength;
        String strengthText = "";
        boolean containsNums = false;
        boolean doneHere = false;
        int textSize = text.length();
        int pos = 0;
        Object posInt = null;
        String strengthString = "";
        while (!doneHere && textSize > pos && textSize > 1) {
            try {
                strengthString = text.substring(pos, pos + 1);
                Integer posNum = Integer.decode(strengthString);
                int checkInt = posNum;
                if (checkInt >= 0 && checkInt <= 9) {
                    containsNums = true;
                } else {
                    strengthText = String.valueOf(strengthText) + strengthString;
                }
                ++pos;
            }
            catch (NullPointerException npe) {
                return null;
            }
            catch (NumberFormatException nfe) {
                if (!containsNums) {
                    doneHere = true;
                    continue;
                }
                ++pos;
                strengthText = String.valueOf(strengthText) + strengthString;
            }
        }
        return strengthText;
    }

    protected int parseIntValue(Object strength) {
        String text = (String)strength;
        String strengthNumText = "";
        String subText = "";
        boolean containsNums = false;
        boolean doneHere = false;
        int textSize = text.length();
        int pos = 0;
        Object posInt = null;
        while (!doneHere && textSize > pos && textSize > 1) {
            try {
                String numString = text.substring(pos, pos + 1);
                Integer posNum = Integer.decode(numString);
                int checkInt = posNum;
                if (checkInt >= 0 && checkInt <= 9) {
                    containsNums = true;
                    subText = text.substring(pos + 1, textSize);
                    ++pos;
                    strengthNumText = String.valueOf(strengthNumText) + numString;
                    continue;
                }
                return 0;
            }
            catch (NullPointerException npe) {
                return 0;
            }
            catch (NumberFormatException nfe) {
                if (!containsNums) {
                    return 0;
                }
                doneHere = true;
            }
        }
        if (strengthNumText != "") {
            return new Integer(strengthNumText);
        }
        return 0;
    }
}

