/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.lookup.algorithms.LookupAlgorithm;
import edu.mayo.bmi.lookup.vo.LookupHit;
import edu.mayo.bmi.lookup.vo.LookupToken;
import edu.mayo.bmi.lookup.vo.LookupTokenComparator;
import edu.mayo.bmi.uima.core.resource.FileResource;
import edu.mayo.bmi.uima.lookup.ae.LookupInitializer;
import edu.mayo.bmi.uima.lookup.ae.LookupParseUtilities;
import edu.mayo.bmi.uima.lookup.ae.LookupSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class DictionaryLookupAnnotator
extends JTextAnnotator_ImplBase {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private AnnotatorContext iv_context;
    private Set iv_lookupSpecSet = new HashSet();
    private Comparator iv_lookupTokenComparator = new LookupTokenComparator();
    private Map iv_dupMap = new HashMap();

    @Override
    public void initialize(AnnotatorContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(aContext);
        this.iv_context = aContext;
        try {
            this.configInit();
        }
        catch (AnnotatorContextException ace) {
            throw new AnnotatorConfigurationException(ace);
        }
    }

    private void configInit() throws AnnotatorContextException, AnnotatorConfigurationException {
        FileResource fResrc = (FileResource)this.iv_context.getResourceObject("LookupDescriptor");
        File descFile = fResrc.getFile();
        try {
            this.iv_logger.info("Parsing descriptor: " + descFile.getAbsolutePath());
            this.iv_lookupSpecSet = LookupParseUtilities.parseDescriptor(descFile, this.iv_context);
        }
        catch (Exception e) {
            throw new AnnotatorConfigurationException(e);
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        this.iv_dupMap.clear();
        try {
            for (LookupSpec ls : this.iv_lookupSpecSet) {
                LookupInitializer lInit = ls.getLookupInitializer();
                Iterator windowItr = lInit.getLookupWindowIterator(jcas);
                while (windowItr.hasNext()) {
                    Annotation window = (Annotation)windowItr.next();
                    List lookupTokensInWindow = this.constrainToWindow(window, lInit.getLookupTokenIterator(jcas));
                    Map ctxMap = lInit.getContextMap(jcas, window.getBegin(), window.getEnd());
                    this.performLookup(jcas, ls, lookupTokensInWindow, ctxMap);
                }
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    private void performLookup(JCas jcas, LookupSpec ls, List lookupTokenList, Map ctxMap) throws Exception {
        Collections.sort(lookupTokenList, this.iv_lookupTokenComparator);
        Collection lookupHitCol = null;
        LookupAlgorithm la = ls.getLookupAlgorithm();
        lookupHitCol = la.lookup(lookupTokenList, ctxMap);
        Collection uniqueHitCol = this.filterHitDups(lookupHitCol);
        ls.getLookupConsumer().consumeHits(jcas, uniqueHitCol.iterator());
    }

    private Collection filterHitDups(Collection lookupHitCol) {
        ArrayList<LookupHit> l = new ArrayList<LookupHit>();
        for (LookupHit lh : lookupHitCol) {
            if (this.isDuplicate(lh)) continue;
            l.add(lh);
        }
        return l;
    }

    private boolean isDuplicate(LookupHit lh) {
        MetaDataHit mdh = lh.getDictMetaDataHit();
        String offsetKey = this.getOffsetKey(lh);
        HashSet<MetaDataHit> mdhDuplicateSet = (HashSet<MetaDataHit>)this.iv_dupMap.get(offsetKey);
        if (mdhDuplicateSet != null) {
            for (MetaDataHit otherMdh : mdhDuplicateSet) {
                if (!mdh.equals(otherMdh)) continue;
                return true;
            }
        } else {
            mdhDuplicateSet = new HashSet<MetaDataHit>();
        }
        mdhDuplicateSet.add(mdh);
        this.iv_dupMap.put(offsetKey, mdhDuplicateSet);
        return false;
    }

    private List constrainToWindow(Annotation window, Iterator lookupTokenItr) throws Exception {
        ArrayList<LookupToken> ltObjectList = new ArrayList<LookupToken>();
        while (lookupTokenItr.hasNext()) {
            LookupToken lt = (LookupToken)lookupTokenItr.next();
            if (lt.getStartOffset() < window.getBegin() || lt.getEndOffset() > window.getEnd()) continue;
            ltObjectList.add(lt);
        }
        return ltObjectList;
    }

    private String getOffsetKey(LookupHit lh) {
        StringBuffer sb = new StringBuffer();
        sb.append(lh.getStartOffset());
        sb.append(',');
        sb.append(lh.getEndOffset());
        return sb.toString();
    }
}

