/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.DictionaryEngine;
import edu.mayo.bmi.lookup.algorithms.DirectPassThroughImpl;
import edu.mayo.bmi.lookup.algorithms.LookupAlgorithm;
import edu.mayo.bmi.lookup.phrasebuilder.VariantPhraseBuilderImpl;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.ContractionToken;
import edu.mayo.bmi.uima.core.type.NewlineToken;
import edu.mayo.bmi.uima.core.type.PunctuationToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.type.SymbolToken;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.lookup.ae.LookupAnnotationToJCasAdapter;
import edu.mayo.bmi.uima.lookup.ae.LookupInitializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class DirectLookupInitializerImpl
implements LookupInitializer {
    private final String CANONICAL_VARIANT_ATTR = "canonicalATTR";

    public DirectLookupInitializerImpl(AnnotatorContext aCtx, Properties props) {
    }

    @Override
    public LookupAlgorithm getLookupAlgorithm(DictionaryEngine dictEngine) throws AnnotatorInitializationException {
        String[] variantArr = new String[]{"canonicalATTR"};
        VariantPhraseBuilderImpl pb = new VariantPhraseBuilderImpl(variantArr, true);
        return new DirectPassThroughImpl(dictEngine, pb);
    }

    @Override
    public Iterator getLookupTokenIterator(JCas jcas) throws AnnotatorInitializationException {
        ArrayList<LookupAnnotationToJCasAdapter> ltList = new ArrayList<LookupAnnotationToJCasAdapter>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator btaItr = indexes.getAnnotationIndex(BaseToken.type).iterator();
        while (btaItr.hasNext()) {
            WordToken wta;
            String canonicalForm;
            BaseToken bta = (BaseToken)btaItr.next();
            if (bta instanceof NewlineToken || bta instanceof PunctuationToken || bta instanceof ContractionToken || bta instanceof SymbolToken) continue;
            LookupAnnotationToJCasAdapter lt = new LookupAnnotationToJCasAdapter(bta);
            if (bta instanceof WordToken && (canonicalForm = (wta = (WordToken)bta).getCanonicalForm()) != null) {
                lt.addStringAttribute("canonicalATTR", canonicalForm);
            }
            ltList.add(lt);
        }
        return ltList.iterator();
    }

    @Override
    public Iterator getLookupWindowIterator(JCas jcas) throws AnnotatorInitializationException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        return indexes.getAnnotationIndex(Sentence.type).iterator();
    }

    @Override
    public Map getContextMap(JCas jcas, int windowBegin, int windowEnd) {
        return new HashMap();
    }
}

