/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.DictionaryEngine;
import edu.mayo.bmi.lookup.algorithms.FirstTokenPermutationImpl;
import edu.mayo.bmi.lookup.algorithms.LookupAlgorithm;
import edu.mayo.bmi.lookup.phrasebuilder.VariantPhraseBuilderImpl;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.ContractionToken;
import edu.mayo.bmi.uima.core.type.NewlineToken;
import edu.mayo.bmi.uima.core.type.PunctuationToken;
import edu.mayo.bmi.uima.core.type.SymbolToken;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.core.util.JCasUtil;
import edu.mayo.bmi.uima.lookup.ae.LookupAnnotationToJCasAdapter;
import edu.mayo.bmi.uima.lookup.ae.LookupInitializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;

public class FirstTokenPermLookupInitializerImpl
implements LookupInitializer {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private final String TEXT_MFS_PRP_KEY = "textMetaFields";
    private final String MAX_P_LEVEL_PRP_KEY = "maxPermutationLevel";
    private final String WINDOW_ANNOT_PRP_KEY = "windowAnnotations";
    private final String EXC_TAGS_PRP_KEY = "exclusionTags";
    private final String CANONICAL_VARIANT_ATTR = "canonicalATTR";
    Properties iv_props;
    private int[] iv_annotTypeArr;
    private Set iv_exclusionTagSet = null;

    public FirstTokenPermLookupInitializerImpl(AnnotatorContext aCtx, Properties props) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        String tagStr;
        this.iv_props = props;
        String windowAnnots = this.iv_props.getProperty("windowAnnotations");
        if (windowAnnots != null) {
            String[] windowAnnotArr = windowAnnots.split("\\|");
            this.iv_annotTypeArr = new int[windowAnnotArr.length];
            int i = 0;
            while (i < windowAnnotArr.length) {
                this.iv_annotTypeArr[i] = JCasUtil.getType(windowAnnotArr[i]);
                ++i;
            }
        }
        if ((tagStr = this.iv_props.getProperty("exclusionTags")) != null) {
            this.iv_exclusionTagSet = new HashSet();
            String[] tagArr = tagStr.split(",");
            int i = 0;
            while (i < tagArr.length) {
                this.iv_exclusionTagSet.add(tagArr[i].toLowerCase());
                ++i;
            }
            this.iv_logger.info("Exclusion tagset loaded: " + this.iv_exclusionTagSet);
        }
    }

    @Override
    public LookupAlgorithm getLookupAlgorithm(DictionaryEngine dictEngine) throws AnnotatorInitializationException {
        String[] variantArr = new String[]{"canonicalATTR"};
        VariantPhraseBuilderImpl pb = new VariantPhraseBuilderImpl(variantArr, true);
        String textMetaFields = this.iv_props.getProperty("textMetaFields");
        String[] textMetaFieldNameArr = textMetaFields == null ? new String[]{} : textMetaFields.split("\\|");
        int maxPermutationLevel = Integer.parseInt(this.iv_props.getProperty("maxPermutationLevel"));
        return new FirstTokenPermutationImpl(dictEngine, pb, textMetaFieldNameArr, maxPermutationLevel);
    }

    private boolean isTagExcluded(String tag) {
        if (this.iv_exclusionTagSet == null || tag == null) {
            return false;
        }
        return this.iv_exclusionTagSet.contains(tag.toLowerCase());
    }

    @Override
    public Iterator getLookupTokenIterator(JCas jcas) throws AnnotatorInitializationException {
        ArrayList<LookupAnnotationToJCasAdapter> ltList = new ArrayList<LookupAnnotationToJCasAdapter>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator btaItr = indexes.getAnnotationIndex(BaseToken.type).iterator();
        while (btaItr.hasNext()) {
            WordToken wta;
            String canonicalForm;
            BaseToken bta = (BaseToken)btaItr.next();
            if (bta instanceof NewlineToken || bta instanceof PunctuationToken || bta instanceof ContractionToken || bta instanceof SymbolToken) continue;
            LookupAnnotationToJCasAdapter lt = new LookupAnnotationToJCasAdapter(bta);
            if (this.isTagExcluded(bta.getPartOfSpeech())) {
                lt.addStringAttribute("USE_FOR_LOOKUP", "false");
            } else {
                lt.addStringAttribute("USE_FOR_LOOKUP", "true");
            }
            if (bta instanceof WordToken && (canonicalForm = (wta = (WordToken)bta).getCanonicalForm()) != null) {
                lt.addStringAttribute("canonicalATTR", canonicalForm);
            }
            ltList.add(lt);
        }
        return ltList.iterator();
    }

    @Override
    public Iterator getLookupWindowIterator(JCas jcas) throws AnnotatorInitializationException {
        try {
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            String objClassName = this.iv_props.getProperty("windowAnnotations");
            int windowType = JCasUtil.getType(objClassName);
            return indexes.getAnnotationIndex(windowType).iterator();
        }
        catch (Exception e) {
            throw new AnnotatorInitializationException(e);
        }
    }

    @Override
    public Map getContextMap(JCas jcas, int windowBegin, int windowEnd) throws AnnotatorInitializationException {
        if (this.iv_annotTypeArr != null) {
            ArrayList list = new ArrayList();
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            int i = 0;
            while (i < this.iv_annotTypeArr.length) {
                FSIterator itr = indexes.getAnnotationIndex(this.iv_annotTypeArr[i]).iterator();
                list.addAll(this.constrainToWindow(windowBegin, windowEnd, itr));
                ++i;
            }
            HashMap m = new HashMap();
            m.put("WINDOW_ANNOTATIONS", list);
            return m;
        }
        return new HashMap();
    }

    private List constrainToWindow(int begin, int end, Iterator annotItr) {
        ArrayList<LookupAnnotationToJCasAdapter> list = new ArrayList<LookupAnnotationToJCasAdapter>();
        while (annotItr.hasNext()) {
            Annotation annot = (Annotation)annotItr.next();
            if (annot.getBegin() < begin || annot.getEnd() > end) continue;
            list.add(new LookupAnnotationToJCasAdapter(annot));
        }
        return list;
    }
}

