/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.lookup.vo.LookupHit;
import edu.mayo.bmi.uima.core.resource.LuceneIndexReaderResource;
import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.OntologyConcept;
import edu.mayo.bmi.uima.lookup.ae.BaseLookupConsumerImpl;
import edu.mayo.bmi.uima.lookup.ae.LookupConsumer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class OrangeBookFilterConsumerImpl
extends BaseLookupConsumerImpl
implements LookupConsumer {
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());
    private final String CODE_MF_PRP_KEY = "codeMetaField";
    private final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private final String LUCENE_FILTER_RESRC_KEY_PRP_KEY = "luceneFilterExtResrcKey";
    private Properties iv_props;
    private Searcher iv_searcher;
    private int iv_maxHits;

    public OrangeBookFilterConsumerImpl(AnnotatorContext aCtx, Properties props, int maxListSize) throws Exception {
        this.iv_props = props;
        this.iv_maxHits = maxListSize;
        String resrcName = this.iv_props.getProperty("luceneFilterExtResrcKey");
        LuceneIndexReaderResource resrc = (LuceneIndexReaderResource)aCtx.getResourceObject(resrcName);
        this.iv_searcher = new IndexSearcher(resrc.getIndexReader());
    }

    public OrangeBookFilterConsumerImpl(AnnotatorContext aCtx, Properties props) throws Exception {
        this.iv_props = props;
        String resrcName = this.iv_props.getProperty("luceneFilterExtResrcKey");
        LuceneIndexReaderResource resrc = (LuceneIndexReaderResource)aCtx.getResourceObject(resrcName);
        this.iv_searcher = new IndexSearcher(resrc.getIndexReader());
        this.iv_maxHits = Integer.MAX_VALUE;
    }

    @Override
    public void consumeHits(JCas jcas, Iterator lhItr) throws AnnotatorProcessException {
        Iterator hitsByOffsetItr = this.organizeByOffset(lhItr);
        while (hitsByOffsetItr.hasNext()) {
            Collection hitsAtOffsetCol = (Collection)hitsByOffsetItr.next();
            Iterator lhAtOffsetItr = hitsAtOffsetCol.iterator();
            int neBegin = -1;
            int neEnd = -1;
            HashSet<String> validCodeCol = new HashSet<String>();
            while (lhAtOffsetItr.hasNext()) {
                LookupHit lh = (LookupHit)lhAtOffsetItr.next();
                neBegin = lh.getStartOffset();
                neEnd = lh.getEndOffset();
                String text = jcas.getDocumentText().substring(lh.getStartOffset(), lh.getEndOffset());
                text = text.trim().toLowerCase();
                MetaDataHit mdh = lh.getDictMetaDataHit();
                String code = mdh.getMetaFieldValue(this.iv_props.getProperty("codeMetaField"));
                if (this.isValid("trade_name", text) || this.isValid("ingredient", text)) {
                    validCodeCol.add(code);
                    continue;
                }
                this.iv_logger.warn("Filtered out: " + text);
            }
            if (validCodeCol.size() <= 0) continue;
            FSArray ocArr = this.createOntologyConceptArr(jcas, validCodeCol);
            NamedEntity neAnnot = new NamedEntity(jcas);
            neAnnot.setTypeID(1);
            neAnnot.setBegin(neBegin);
            neAnnot.setEnd(neEnd);
            neAnnot.setDiscoveryTechnique(1);
            neAnnot.setOntologyConceptArr(ocArr);
            neAnnot.addToIndexes();
        }
    }

    private FSArray createOntologyConceptArr(JCas jcas, Collection validCodeCol) {
        FSArray ocArr = new FSArray(jcas, validCodeCol.size());
        int ocArrIdx = 0;
        for (String validCode : validCodeCol) {
            OntologyConcept oc = new OntologyConcept(jcas);
            oc.setCode(validCode);
            oc.setCodingScheme(this.iv_props.getProperty("codingScheme"));
            ocArr.set(ocArrIdx, oc);
            ++ocArrIdx;
        }
        return ocArr;
    }

    private boolean isValid(String fieldName, String str) throws AnnotatorProcessException {
        try {
            TermQuery q = new TermQuery(new Term(fieldName, str));
            TopDocs topDoc = this.iv_searcher.search((Query)q, this.iv_maxHits);
            ScoreDoc[] hits = topDoc.scoreDocs;
            return hits != null && hits.length > 0;
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }
}

