/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.lookup.ae;

import edu.mayo.bmi.dictionary.DictionaryException;
import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.dictionary.lucene.LuceneDictionaryImpl;
import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.lookup.ae.LookupConsumer;
import edu.mayo.bmi.uima.lookup.ae.UmlsToSnomedConsumerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.FSDirectory;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;

public class UmlsToSnomedLuceneConsumerImpl
extends UmlsToSnomedConsumerImpl
implements LookupConsumer {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private int iv_maxListSize;
    private final String SNOMED_MAPPING_PRP_KEY = "snomedCodeMappingField";
    private final String CUI_MAPPING_PRP_KEY = "cuiMappingField";
    private LuceneDictionaryImpl snomedLikeCodesIndex;

    public UmlsToSnomedLuceneConsumerImpl(AnnotatorContext aCtx, Properties properties) throws Exception {
        this(aCtx, properties, Integer.MAX_VALUE);
    }

    public UmlsToSnomedLuceneConsumerImpl(AnnotatorContext aCtx, Properties properties, int maxListSize) throws Exception {
        super(aCtx, properties);
        this.iv_maxListSize = maxListSize;
        String indexPath = null;
        String indexDirAbsPath = null;
        try {
            indexPath = "lookupresources/lookup/snomed-like_codes_sample";
            File indexDir = FileLocator.locateFile(indexPath);
            indexDirAbsPath = indexDir.getAbsolutePath();
            IndexReader indexReader = IndexReader.open(FSDirectory.open(indexDir));
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            String lookupFieldName = this.props.getProperty("cuiMappingField");
            this.snomedLikeCodesIndex = new LuceneDictionaryImpl(indexSearcher, lookupFieldName, this.iv_maxListSize);
            this.logger.info("Loaded Lucene index with " + indexReader.numDocs() + " entries.");
        }
        catch (IOException ioe) {
            this.logger.info("Lucene index: " + indexDirAbsPath);
            throw new DictionaryException(ioe);
        }
    }

    @Override
    protected Set getSnomedCodes(String umlsCode) throws DictionaryException {
        HashSet<String> codeSet = new HashSet<String>();
        String valueFieldName = this.props.getProperty("snomedCodeMappingField");
        Collection mdhCollection = this.snomedLikeCodesIndex.getEntries(umlsCode);
        for (MetaDataHit mdh : mdhCollection) {
            codeSet.add(mdh.getMetaFieldValue(valueFieldName));
        }
        return codeSet;
    }
}

