/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.pad.impl;

import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.lookup.ae.BaseLookupConsumerImpl;
import edu.mayo.bmi.uima.lookup.ae.LookupConsumer;
import edu.mayo.bmi.uima.pad.type.SubSection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;

public abstract class PADConsumerImpl
extends BaseLookupConsumerImpl
implements LookupConsumer {
    private static String revisionHeader = "showing";
    private static String indicationsHeader = "INDICATIONS:";
    private static int maxSubsectionSize = 300;

    @Override
    public abstract void consumeHits(JCas var1, Iterator var2) throws AnnotatorProcessException;

    protected List<WordToken> getTokenData(JCas jcas, Annotation locationTerm) {
        ArrayList<WordToken> list = new ArrayList<WordToken>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotItr = indexes.getAnnotationIndex(WordToken.type).iterator();
        while (annotItr.hasNext()) {
            WordToken ann = (WordToken)annotItr.next();
            if (ann.getBegin() < locationTerm.getBegin() || ann.getEnd() > locationTerm.getEnd()) continue;
            list.add(ann);
        }
        return list;
    }

    public String getSegmentIdContaining(Annotation ann, JCas jcas) {
        int begin = ann.getBegin();
        int end = ann.getEnd();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator secItr = indexes.getAnnotationIndex(SubSection.type).iterator();
        while (secItr.hasNext()) {
            SubSection sa = (SubSection)secItr.next();
            if (sa.getBegin() <= begin && end <= sa.getEnd()) {
                return String.valueOf(sa.getParentSectionId());
            }
            if (sa.getBegin() > begin || begin >= sa.getEnd()) continue;
            return String.valueOf(sa.getParentSectionId());
        }
        return "-1";
    }

    public int findOriginalReportSubSection(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator secItr = indexes.getAnnotationIndex(SubSection.type).iterator();
        while (secItr.hasNext()) {
            SubSection sa = (SubSection)secItr.next();
            if (!(sa.getStatus() == 1 & sa.getCoveredText().startsWith(revisionHeader))) continue;
            return sa.getSubSectionBodyBegin();
        }
        return 0;
    }

    public String getSubSectionStatus(Annotation ann, JCas jcas, int cutOff) {
        int begin = ann.getBegin();
        int end = ann.getEnd();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator secItr = indexes.getAnnotationIndex(SubSection.type).iterator();
        while (secItr.hasNext()) {
            SubSection sa = (SubSection)secItr.next();
            if (cutOff == 0 || cutOff > 0 && sa.getSubSectionBodyBegin() < cutOff) {
                if (sa.getSubSectionHeaderBegin() <= begin && sa.getSubSectionHeaderEnd() >= end) {
                    return "1";
                }
                if (sa.getBegin() <= begin && end <= sa.getEnd()) {
                    if (sa.getStatus() == 1 & sa.getCoveredText().startsWith(indicationsHeader) && sa.getBegin() > maxSubsectionSize) {
                        return "-1";
                    }
                    return String.valueOf(sa.getStatus());
                }
                if (sa.getBegin() <= begin && begin < sa.getEnd()) {
                    return String.valueOf(sa.getStatus());
                }
                if (begin >= sa.getSubSectionHeaderBegin() || end >= sa.getSubSectionHeaderEnd()) continue;
                return "1";
            }
            return "1";
        }
        return "-1";
    }
}

