/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.pos_tagger;

import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;

public class OpenNLPPOSCollectionReader
extends CollectionReader_ImplBase {
    public static final String POS_DATA_FILE_PARAM = "PosDataFile";
    public static final String LOAD_WORDS_ONLY_PARAM = "LoadWordsOnly";
    BufferedReader input;
    String line = null;
    boolean loadWordsOnly;

    @Override
    public void initialize() throws ResourceInitializationException {
        try {
            String posDataFile = (String)this.getConfigParameterValue(POS_DATA_FILE_PARAM);
            this.input = new BufferedReader(new FileReader(posDataFile));
            Boolean paramValue = (Boolean)this.getConfigParameterValue(LOAD_WORDS_ONLY_PARAM);
            this.loadWordsOnly = paramValue == null ? false : paramValue;
        }
        catch (FileNotFoundException fnfe) {
            throw new ResourceInitializationException(fnfe);
        }
    }

    @Override
    public void getNext(CAS cas) throws IOException, CollectionException {
        try {
            if (this.hasNext()) {
                JCas jCas = cas.getJCas();
                String[] tokens = this.line.split(" ");
                int wordStart = 0;
                int wordEnd = 0;
                int wordNumber = 0;
                StringBuffer documentText = new StringBuffer();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    int split = token.lastIndexOf("_");
                    if (split == token.length() - 1) {
                        split = token.substring(0, token.length() - 1).lastIndexOf("_");
                    }
                    if (split == -1) {
                        this.line = null;
                        throw new CollectionException("There is a problem in your training data: " + token + " does not conform to the format WORD_TAG.", null);
                    }
                    String word = token.substring(0, split);
                    wordEnd = wordStart + word.length();
                    BaseToken baseToken = new BaseToken(jCas, wordStart, wordEnd);
                    if (!this.loadWordsOnly) {
                        String tag = token.substring(split + 1);
                        baseToken.setPartOfSpeech(tag);
                    }
                    baseToken.setTokenNumber(wordNumber++);
                    baseToken.addToIndexes();
                    documentText.append(String.valueOf(word) + " ");
                    wordStart = wordEnd + 1;
                    ++n2;
                }
                Sentence sentence = new Sentence(jCas, 0, wordEnd);
                sentence.setSentenceNumber(0);
                sentence.addToIndexes();
                jCas.setDocumentText(documentText.toString());
            }
        }
        catch (CASException ce) {
            throw new CollectionException(ce);
        }
        this.line = null;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public Progress[] getProgress() {
        return null;
    }

    @Override
    public boolean hasNext() throws IOException, CollectionException {
        if (this.line == null) {
            this.line = this.input.readLine();
        }
        return this.line != null;
    }
}

