/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.pos_tagger;

import edu.mayo.bmi.uima.core.resource.FileLocator;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.Sentence;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.lang.english.PosTagger;
import opennlp.tools.postag.POSDictionary;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class POSTagger
extends JCasAnnotator_ImplBase {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String POS_MODEL_FILE_PARAM = "PosModelFile";
    public static final String TAG_DICTIONARY_PARAM = "TagDictionary";
    public static final String CASE_SENSITIVE_PARAM = "CaseSensitive";
    private PosTagger tagger;

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        String posModelPath = null;
        try {
            posModelPath = (String)uimaContext.getConfigParameterValue(POS_MODEL_FILE_PARAM);
            File posModelFile = FileLocator.locateFile(posModelPath);
            String modelFileAbsPath = posModelFile.getAbsolutePath();
            this.logger.info("POS tagger model file: " + modelFileAbsPath);
            boolean caseSensitive = (Boolean)uimaContext.getConfigParameterValue(CASE_SENSITIVE_PARAM);
            String tagDictionaryPath = (String)uimaContext.getConfigParameterValue(TAG_DICTIONARY_PARAM);
            POSDictionary tagDictionary = null;
            if (tagDictionaryPath != null && !tagDictionaryPath.trim().equals("")) {
                File tagDictFile = FileLocator.locateFile(tagDictionaryPath);
                String tagDictFileAbsPath = tagDictFile.getAbsolutePath();
                this.logger.info("POS tagger tag-dictionary: " + tagDictFileAbsPath);
                tagDictionary = new POSDictionary(tagDictFileAbsPath, caseSensitive);
            } else {
                this.logger.info("No POS tagger tag-dictionary.");
            }
            this.tagger = new PosTagger(modelFileAbsPath, tagDictionary);
        }
        catch (Exception e) {
            this.logger.info("POS tagger model: " + posModelPath);
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.logger.info("POSTaggerAnnotator process(JCas)");
        ArrayList<BaseToken> tokens = new ArrayList<BaseToken>();
        ArrayList<String> words = new ArrayList<String>();
        AnnotationIndex baseTokenIndex = jCas.getAnnotationIndex(BaseToken.type);
        FSIterator sentences = jCas.getAnnotationIndex(Sentence.type).iterator();
        while (sentences.hasNext()) {
            Sentence sentence = (Sentence)sentences.next();
            tokens.clear();
            words.clear();
            FSIterator tokenIterator = baseTokenIndex.subiterator(sentence);
            while (tokenIterator.hasNext()) {
                BaseToken token = (BaseToken)tokenIterator.next();
                tokens.add(token);
                words.add(token.getCoveredText());
            }
            List wordTagList = null;
            if (words.size() > 0) {
                wordTagList = this.tagger.tag(words);
            }
            try {
                int i = 0;
                while (i < tokens.size()) {
                    BaseToken token = (BaseToken)tokens.get(i);
                    String posTag = (String)wordTagList.get(i);
                    token.setPartOfSpeech(posTag);
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new AnalysisEngineProcessException("sentence being tagged is: '" + sentence.getCoveredText() + "'", null, e);
            }
        }
    }
}

