/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.pos_tagger.test;

import edu.mayo.bmi.uima.core.test.TestUtil;
import edu.mayo.bmi.uima.core.type.BaseToken;
import java.io.File;
import java.io.IOException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.junit.Assert;
import org.junit.Test;

public class OpenNLPPOSCollectionReaderTests {
    @Test
    public void testReader() throws ResourceInitializationException, IOException, CollectionException {
        CollectionReader collectionReader = TestUtil.getCR(new File("test/desc/OpenNLPPOSCollectionReader.xml"));
        AnalysisEngine analysisEngine = TestUtil.getAE(new File("test/desc/NullAnnotator.xml"));
        JCas jCas = analysisEngine.newJCas();
        collectionReader.getNext(jCas.getCas());
        BaseToken baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 0);
        Assert.assertEquals(0, baseToken.getBegin());
        Assert.assertEquals(1, baseToken.getEnd());
        Assert.assertEquals("A", baseToken.getCoveredText());
        Assert.assertEquals("A", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 1);
        Assert.assertEquals("farmer", baseToken.getCoveredText());
        Assert.assertEquals("B", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 2);
        Assert.assertEquals("went", baseToken.getCoveredText());
        Assert.assertEquals("CC", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 3);
        Assert.assertEquals("trotting", baseToken.getCoveredText());
        Assert.assertEquals("DDD", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 4);
        Assert.assertEquals("upon_A", baseToken.getCoveredText());
        Assert.assertEquals("E", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 5);
        Assert.assertEquals("his", baseToken.getCoveredText());
        Assert.assertEquals("EE", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 6);
        Assert.assertEquals(".", baseToken.getCoveredText());
        Assert.assertEquals(".", baseToken.getPartOfSpeech());
        CollectionException ce = null;
        jCas = analysisEngine.newJCas();
        try {
            collectionReader.getNext(jCas.getCas());
        }
        catch (CollectionException e) {
            ce = e;
        }
        Assert.assertNotNull(ce);
        jCas = analysisEngine.newJCas();
        collectionReader.getNext(jCas.getCas());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 0);
        Assert.assertEquals("A_", baseToken.getCoveredText());
        Assert.assertEquals("A", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 1);
        Assert.assertEquals("_", baseToken.getCoveredText());
        Assert.assertEquals("B", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 2);
        Assert.assertEquals("_B_", baseToken.getCoveredText());
        Assert.assertEquals("C", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 3);
        Assert.assertEquals("B", baseToken.getCoveredText());
        Assert.assertEquals("_", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 4);
        Assert.assertEquals("__", baseToken.getCoveredText());
        Assert.assertEquals("_", baseToken.getPartOfSpeech());
    }

    @Test
    public void testLoadWordsOnly() throws ResourceInitializationException, IOException, CollectionException {
        CollectionReader collectionReader = TestUtil.getCR(new File("test/desc/OpenNLPPOSCollectionReader2.xml"));
        AnalysisEngine analysisEngine = TestUtil.getAE(new File("test/desc/NullAnnotator.xml"));
        JCas jCas = analysisEngine.newJCas();
        collectionReader.getNext(jCas.getCas());
        BaseToken baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 0);
        Assert.assertEquals(0, baseToken.getBegin());
        Assert.assertEquals(1, baseToken.getEnd());
        Assert.assertEquals("A", baseToken.getCoveredText());
        Assert.assertNull(baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 1);
        Assert.assertEquals("farmer", baseToken.getCoveredText());
        Assert.assertNull(baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 2);
        Assert.assertEquals("went", baseToken.getCoveredText());
        Assert.assertNull(baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 3);
        Assert.assertEquals("trotting", baseToken.getCoveredText());
        Assert.assertNull(baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 4);
        Assert.assertEquals("upon_A", baseToken.getCoveredText());
        Assert.assertNull(baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 5);
        Assert.assertEquals("his", baseToken.getCoveredText());
        Assert.assertNull(baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 6);
        Assert.assertEquals(".", baseToken.getCoveredText());
        Assert.assertNull(baseToken.getPartOfSpeech());
        CollectionException ce = null;
        jCas = analysisEngine.newJCas();
        try {
            collectionReader.getNext(jCas.getCas());
        }
        catch (CollectionException e) {
            ce = e;
        }
        Assert.assertNotNull(ce);
    }
}

