/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.pos_tagger.test;

import edu.mayo.bmi.uima.core.test.TestUtil;
import edu.mayo.bmi.uima.core.type.BaseToken;
import java.io.File;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.junit.Assert;
import org.junit.Test;

public class POSTaggerTests {
    @Test
    public void testTagger() throws ResourceInitializationException {
        AnalysisEngine analysisEngine = TestUtil.getAE(new File("test/desc/POSTaggerAggregate.xml"));
        JCas jCas = TestUtil.processAE(analysisEngine, "A farmer went trotting upon his gray mare, Bumpety, bumpety, bump, With his daughter behind him, so rosy and fair, Lumpety, lumpety, lump.");
        BaseToken baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 0);
        Assert.assertEquals(0, baseToken.getBegin());
        Assert.assertEquals(1, baseToken.getEnd());
        Assert.assertEquals("A", baseToken.getCoveredText());
        Assert.assertEquals("DT", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 1);
        Assert.assertEquals(2, baseToken.getBegin());
        Assert.assertEquals(8, baseToken.getEnd());
        Assert.assertEquals("farmer", baseToken.getCoveredText());
        Assert.assertEquals("JJ", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 2);
        Assert.assertEquals("went", baseToken.getCoveredText());
        Assert.assertEquals("JJ", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 3);
        Assert.assertEquals("trotting", baseToken.getCoveredText());
        Assert.assertEquals("NN", baseToken.getPartOfSpeech());
        FSIterator baseTokenItr = jCas.getJFSIndexRepository().getAnnotationIndex(BaseToken.type).iterator();
        while (baseTokenItr.hasNext()) {
            baseToken = (BaseToken)baseTokenItr.next();
            Assert.assertNotNull(baseToken.getPartOfSpeech());
        }
    }

    private void printPosTags(JCas jCas) {
        int i = 0;
        while (i < TestUtil.getFeatureStructureSize(jCas, BaseToken.class)) {
            BaseToken baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, i);
            System.out.println(String.valueOf(baseToken.getCoveredText()) + " part of speech = " + baseToken.getPartOfSpeech());
            ++i;
        }
    }

    @Test
    public void testTagDictionary() throws ResourceInitializationException {
        AnalysisEngine analysisEngine = TestUtil.getAE(new File("test/desc/POSTaggerAggregate2.xml"));
        JCas jCas = TestUtil.processAE(analysisEngine, "Use of new biologic markers in the ovulation induction.");
        BaseToken baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 0);
        Assert.assertEquals("Use", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 1);
        Assert.assertEquals("of", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 2);
        Assert.assertEquals("new", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 3);
        Assert.assertEquals("biologic", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 4);
        Assert.assertEquals("markers", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 5);
        Assert.assertEquals("in", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 6);
        Assert.assertEquals("the", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 7);
        Assert.assertEquals("ovulation", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 8);
        Assert.assertEquals("induction", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 9);
        Assert.assertEquals(".", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        FSIterator baseTokenItr = jCas.getJFSIndexRepository().getAnnotationIndex(BaseToken.type).iterator();
        while (baseTokenItr.hasNext()) {
            baseToken = (BaseToken)baseTokenItr.next();
            Assert.assertNotNull(baseToken.getPartOfSpeech());
        }
        analysisEngine = TestUtil.getAE(new File("test/desc/POSTaggerAggregate2.xml"));
        jCas = TestUtil.processAE(analysisEngine, "use Of neW Biologic Markers IN The oVULation inductiOn.");
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 0);
        Assert.assertEquals("use", baseToken.getCoveredText());
        Assert.assertEquals("NN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 1);
        Assert.assertEquals("Of", baseToken.getCoveredText());
        Assert.assertEquals("CD", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 2);
        Assert.assertEquals("neW", baseToken.getCoveredText());
        Assert.assertEquals("JJ", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 3);
        Assert.assertEquals("Biologic", baseToken.getCoveredText());
        Assert.assertEquals("NN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 4);
        Assert.assertEquals("Markers", baseToken.getCoveredText());
        Assert.assertEquals("NNS", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 5);
        Assert.assertEquals("IN", baseToken.getCoveredText());
        Assert.assertEquals("VBP", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 6);
        Assert.assertEquals("The", baseToken.getCoveredText());
        Assert.assertEquals("DT", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 7);
        Assert.assertEquals("oVULation", baseToken.getCoveredText());
        Assert.assertEquals("NN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 8);
        Assert.assertEquals("inductiOn", baseToken.getCoveredText());
        Assert.assertEquals("NN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 9);
        Assert.assertEquals(".", baseToken.getCoveredText());
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        analysisEngine = TestUtil.getAE(new File("test/desc/POSTaggerAggregate3.xml"));
        jCas = TestUtil.processAE(analysisEngine, "use Of neW Biologic Markers IN The oVULation inductiOn.");
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 0);
        Assert.assertEquals("NN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 1);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 2);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 3);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 4);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 5);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 6);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 7);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 8);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
        baseToken = TestUtil.getFeatureStructureAtIndex(jCas, BaseToken.class, 9);
        Assert.assertEquals("IN", baseToken.getPartOfSpeech());
    }
}

