/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.pos_tagger.test;

import edu.mayo.bmi.uima.pos_tagger.TagDictionaryCreator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TagDictionaryCreatorTests {
    @Test
    public void testCreateTagDictionary() throws FileNotFoundException, IOException {
        BufferedReader input = new BufferedReader(new FileReader("test/data/unit-test-2lines-training-data.txt"));
        HashMap<String, Set<String>> tagDictionaryData = TagDictionaryCreator.createTagDictionary(input, true);
        Set<String> tags = tagDictionaryData.get("IL-2");
        Assert.assertEquals(3, tags.size());
        boolean nn = false;
        boolean cc = false;
        boolean in = false;
        for (String tag : tags) {
            if (tag.equals("NN")) {
                nn = true;
            }
            if (tag.equals("CC")) {
                cc = true;
            }
            if (!tag.equals("IN")) continue;
            in = true;
        }
        Assert.assertTrue(nn);
        Assert.assertTrue(cc);
        Assert.assertTrue(in);
        input = new BufferedReader(new FileReader("test/data/unit-test-2lines-training-data.txt"));
        tagDictionaryData = TagDictionaryCreator.createTagDictionary(input, false);
        tags = tagDictionaryData.get("il-2");
        Assert.assertEquals(3, tags.size());
        nn = false;
        cc = false;
        in = false;
        for (String tag : tags) {
            if (tag.equals("NN")) {
                nn = true;
            }
            if (tag.equals("CC")) {
                cc = true;
            }
            if (!tag.equals("IN")) continue;
            in = true;
        }
        Assert.assertTrue(nn);
        Assert.assertTrue(cc);
        Assert.assertTrue(in);
        tags = tagDictionaryData.get("surface");
        Assert.assertEquals("NN", tags.iterator().next());
    }

    @Test
    public void testMain() throws FileNotFoundException, IOException {
        String line;
        String[] args = new String[]{"test/data/unit-test-2lines-training-data.txt", "test/data/output/unit-test-2lines-tag-dictionary.txt", "true"};
        TagDictionaryCreator.main(args);
        BufferedReader input = new BufferedReader(new FileReader("test/data/output/unit-test-2lines-tag-dictionary.txt"));
        int lines = 0;
        while ((line = input.readLine()) != null) {
            ++lines;
            if (line.startsWith("IL-2 ")) {
                Assert.assertEquals("IL-2 CC IN NN", line);
            }
            if (!line.startsWith("requires ")) continue;
            Assert.assertEquals("requires VBZ", line);
        }
        Assert.assertEquals(36, lines);
    }
}

