/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.sideeffect.ae;

import edu.mayo.bmi.uima.sideeffect.type.PSESentenceFeature;
import edu.mayo.bmi.uima.sideeffect.type.SESentence;
import edu.mayo.bmi.uima.sideeffect.type.SideEffectAnnotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class SESentenceClassifierAnnotator
extends JTextAnnotator_ImplBase {
    svm_model model;
    Map<String, String> feaMap;

    @Override
    public void initialize(AnnotatorContext annotCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotCtx);
        try {
            String pathOfTrainedModel = (String)this.getContext().getConfigParameterValue("PathOfModel");
            this.model = svm.svm_load_model(pathOfTrainedModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.feaMap = new HashMap<String, String>();
        this.feaMap.put("nul", "0");
        this.feaMap.put("pre", "1");
        this.feaMap.put("bet", "1");
        this.feaMap.put("bpd", "2");
        this.feaMap.put("bdp", "3");
        this.feaMap.put("bap", "4");
        this.feaMap.put("bep", "5");
        this.feaMap.put("afp", "6");
        this.feaMap.put("any", "7");
    }

    @Override
    public void process(JCas jcas, ResultSpecification resSpec) throws AnnotatorProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator psfIter = indexes.getAnnotationIndex(PSESentenceFeature.type).iterator();
        HashSet<String> seSenSpans_ML = new HashSet<String>();
        while (psfIter.hasNext()) {
            PSESentenceFeature psf = (PSESentenceFeature)psfIter.next();
            svm_node[] x = new svm_node[psf.getFeatures().size()];
            int j = 0;
            while (j < psf.getFeatures().size()) {
                x[j] = new svm_node();
                x[j].index = j + 1;
                String nomFea = psf.getFeatures(j);
                x[j].value = Double.parseDouble(this.feaMap.get(nomFea));
                ++j;
            }
            double clsLabel = svm.svm_predict(this.model, x);
            if (clsLabel != 1.0) continue;
            String span = String.valueOf(Integer.toString(psf.getPseSen().getBegin())) + "|" + Integer.toString(psf.getPseSen().getEnd());
            seSenSpans_ML.add(span);
        }
        HashSet<String> seSenSpans_rule = new HashSet<String>();
        FSIterator seIter = indexes.getAnnotationIndex(SideEffectAnnotation.type).iterator();
        while (seIter.hasNext()) {
            SideEffectAnnotation se = (SideEffectAnnotation)seIter.next();
            String span = String.valueOf(Integer.toString(se.getSentence().getBegin())) + "|" + Integer.toString(se.getSentence().getEnd());
            seSenSpans_rule.add(span);
        }
        HashSet<String> seSenSpans = new HashSet<String>(seSenSpans_ML);
        seSenSpans.addAll(seSenSpans_rule);
        for (String s : seSenSpans) {
            String[] stk = s.split("\\|");
            int begin = Integer.parseInt(stk[0]);
            int end = Integer.parseInt(stk[1]);
            SESentence ses = new SESentence(jcas);
            ses.setBegin(begin);
            ses.setEnd(end);
            ses.addToIndexes();
        }
    }
}

