/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.sideeffect.ae;

import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.sideeffect.type.PSESentence;
import edu.mayo.bmi.uima.sideeffect.type.PSESentenceFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.StringArray;

public class SESentenceFeatureAnnotator
extends JTextAnnotator_ImplBase {
    private Map metaKeywords;
    private List metaKey;

    @Override
    public void initialize(AnnotatorContext annotCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotCtx);
        this.metaKey = new ArrayList();
        try {
            String metaKeywordsFileName = (String)annotCtx.getConfigParameterValue("MetaKeywordsFile");
            this.metaKeywords = this.readMetaKeywordsFromFile(metaKeywordsFileName, this.metaKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification resSpec) throws AnnotatorProcessException {
        String docName = DocumentIDAnnotationUtil.getDocumentID(jcas);
        System.out.println("---" + docName + "---");
        this.annotatePSESentenceFeatures(jcas);
    }

    private void annotatePSESentenceFeatures(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator pseSenIter = indexes.getAnnotationIndex(PSESentence.type).iterator();
        while (pseSenIter.hasNext()) {
            PSESentence ps = (PSESentence)pseSenIter.next();
            ArrayList fea = new ArrayList();
            fea.addAll(this.getLocationFeaturesFromMetaKeywords(jcas, ps));
            PSESentenceFeature psf = new PSESentenceFeature(jcas);
            StringArray feaArray = new StringArray(jcas, fea.size());
            int i = 0;
            while (i < fea.size()) {
                feaArray.set(i, (String)fea.get(i));
                ++i;
            }
            psf.setFeatures(feaArray);
            psf.setPseSen(ps);
            psf.addToIndexes();
        }
    }

    private List getLocationFeaturesFromMetaKeywords(JCas jcas, PSESentence ps) {
        ArrayList<String> feature = new ArrayList<String>();
        ArrayList<NamedEntity> drug = new ArrayList<NamedEntity>();
        ArrayList<NamedEntity> pse = new ArrayList<NamedEntity>();
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, ps.getBegin(), ps.getEnd() + 1);
        while (neIter.hasNext()) {
            NamedEntity n = (NamedEntity)neIter.next();
            if (n.getTypeID() == 1) {
                drug.add(n);
            }
            if (n.getTypeID() != 2 && n.getTypeID() != 3) continue;
            pse.add(n);
        }
        for (String mk : this.metaKey) {
            Set kwSet = (Set)this.metaKeywords.get(mk);
            Iterator kwIter = kwSet.iterator();
            String kw = "";
            int kwPos = -1;
            boolean foundKw = false;
            while (kwIter.hasNext()) {
                String pseSenText = ps.getCoveredText().toLowerCase();
                kwPos = pseSenText.indexOf(kw = (String)kwIter.next());
                if (kwPos == -1) continue;
                int kwB = kwPos - 1;
                int kwA = kwPos + kw.length();
                if (pseSenText.length() > kwA && (kwPos != 0 || !pseSenText.substring(kwA, kwA + 1).matches("\\W")) && (!pseSenText.substring(kwA, kwA + 1).matches("\\W") || !pseSenText.substring(kwB, kwB + 1).matches("\\W"))) continue;
                foundKw = true;
                break;
            }
            if (!foundKw) {
                feature.add("nul");
                continue;
            }
            int kwBegin = kwPos + ps.getBegin();
            int kwEnd = kwBegin + kw.length();
            boolean beforePse = false;
            boolean afterPse = false;
            boolean betweenPseAndDrug = false;
            boolean betweenDrugAndPse = false;
            for (NamedEntity pseNE : pse) {
                if (kwBegin > pseNE.getEnd()) {
                    for (NamedEntity drugNE : drug) {
                        if (kwEnd >= drugNE.getBegin()) continue;
                        betweenPseAndDrug = true;
                        break;
                    }
                }
                if (betweenPseAndDrug) break;
            }
            for (NamedEntity drugNE : drug) {
                if (kwBegin > drugNE.getEnd()) {
                    for (NamedEntity pseNE : pse) {
                        if (kwEnd >= pseNE.getBegin()) continue;
                        betweenDrugAndPse = true;
                        break;
                    }
                }
                if (betweenDrugAndPse) break;
            }
            if (!betweenPseAndDrug && !betweenDrugAndPse) {
                for (NamedEntity n : pse) {
                    if (kwEnd < n.getBegin()) {
                        beforePse = true;
                    }
                    if (kwBegin <= n.getEnd()) continue;
                    afterPse = true;
                }
            }
            if (mk.equals("SideEffectWord")) {
                feature.add("pre");
                continue;
            }
            if (betweenPseAndDrug && betweenDrugAndPse) {
                feature.add("bet");
                continue;
            }
            if (betweenPseAndDrug) {
                feature.add("bpd");
                continue;
            }
            if (betweenDrugAndPse) {
                feature.add("bdp");
                continue;
            }
            if (beforePse && afterPse) {
                feature.add("bap");
                continue;
            }
            if (beforePse) {
                feature.add("bep");
                continue;
            }
            if (afterPse) {
                feature.add("afp");
                continue;
            }
            feature.add("any");
        }
        return feature;
    }

    public Map readMetaKeywordsFromFile(String fileName, List key) throws IOException {
        String line;
        LinkedHashMap returnValues = new LinkedHashMap();
        File file = new File(fileName);
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            if (line.startsWith("//") || line.length() == 0) continue;
            String[] stk = line.trim().split("\\|");
            LinkedHashSet<String> keySet = new LinkedHashSet<String>();
            int i = 1;
            while (i < stk.length) {
                keySet.add(stk[i].trim());
                ++i;
            }
            key.add(stk[0].trim());
            returnValues.put(stk[0].trim(), keySet);
        }
        return returnValues;
    }

    private class SideEffect {
        String text;
        int begin;
        int end;

        private SideEffect() {
        }
    }
}

