/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.sideeffect.ae;

import edu.mayo.bmi.uima.core.resource.FileResource;
import edu.mayo.bmi.uima.core.type.NamedEntity;
import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.drugner.type.SubSectionAnnotation;
import edu.mayo.bmi.uima.sideeffect.type.SESentence;
import edu.mayo.bmi.uima.sideeffect.type.SideEffectAnnotation;
import edu.mayo.bmi.uima.sideeffect.util.PatternMatch;
import edu.mayo.bmi.uima.sideeffect.util.SEUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class SideEffectAnnotator
extends JTextAnnotator_ImplBase {
    private Map<String, String> keyDrugMap = new HashMap<String, String>();
    private Map<String, Set<String>> sideEffectMap = new HashMap<String, Set<String>>();
    private Set<String> setionsToIgnore = new HashSet<String>();
    private List<String> causeVerb = new ArrayList<String>();
    private List<String> causeWord1 = new ArrayList<String>();
    private List<String> causeWord2 = new ArrayList<String>();
    private List<String> discontVerb = new ArrayList<String>();
    private List<String> sideEffectWord = new ArrayList<String>();
    private List<String> noteVerb = new ArrayList<String>();
    private List<String> madeVerb = new ArrayList<String>();
    private List<String> afterWord = new ArrayList<String>();

    @Override
    public void initialize(AnnotatorContext annotCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotCtx);
        FileResource fResrc = null;
        try {
            fResrc = (FileResource)this.getContext().getResourceObject("sideEffectTable");
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
        }
        this.setMap(fResrc.getFile(), this.keyDrugMap, this.sideEffectMap);
        try {
            String[] str = (String[])this.getContext().getConfigParameterValue("sectionsToIgnore");
            int i = 0;
            while (i < str.length) {
                this.setionsToIgnore.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDrugCauseVerbPse");
            i = 0;
            while (i < str.length) {
                this.causeVerb.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfPseDueToDrug");
            i = 0;
            while (i < str.length) {
                this.causeWord1.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDrugDueToPse");
            i = 0;
            while (i < str.length) {
                this.causeWord2.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDiscontDrugBecausePse");
            i = 0;
            while (i < str.length) {
                this.discontVerb.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("sideEffectWord");
            i = 0;
            while (i < str.length) {
                this.sideEffectWord.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfNotePseWithDrug");
            i = 0;
            while (i < str.length) {
                this.noteVerb.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfDrugMadePse");
            i = 0;
            while (i < str.length) {
                this.madeVerb.add(str[i]);
                ++i;
            }
            str = (String[])this.getContext().getConfigParameterValue("hasPatternOfPseAfterDrug");
            i = 0;
            while (i < str.length) {
                this.afterWord.add(str[i]);
                ++i;
            }
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        String docName = DocumentIDAnnotationUtil.getDocumentID(jcas);
        System.out.println("---" + docName + " processed---");
        this.removeDuplicatedNEs(jcas);
        List<PotentialSideEffect> potentialSideEffectLst = this.getPotentialSideEffects(jcas);
        List<SideEffect> sideEffectLst = this.getSideEffectsWithPrioritizedRule(jcas, potentialSideEffectLst);
        this.annotateSideEffects(jcas, sideEffectLst);
    }

    private void removeDuplicatedNEs(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator neItr = indexes.getAnnotationIndex(NamedEntity.type).iterator();
        HashSet<String> spanSet = new HashSet<String>();
        ArrayList<NamedEntity> duplicatedNE = new ArrayList<NamedEntity>();
        while (neItr.hasNext()) {
            NamedEntity nea = (NamedEntity)neItr.next();
            String span = String.valueOf(Integer.toString(nea.getTypeID())) + "|" + Integer.toString(nea.getBegin()) + "|" + Integer.toString(nea.getEnd());
            if (spanSet.contains(span)) {
                duplicatedNE.add(nea);
            }
            spanSet.add(span);
        }
        for (NamedEntity ne : duplicatedNE) {
            ne.removeFromIndexes();
        }
    }

    private List<NamedEntity> getSideEffectNEs(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator neItr = indexes.getAnnotationIndex(NamedEntity.type).iterator();
        ArrayList<NamedEntity> l = new ArrayList<NamedEntity>();
        while (neItr.hasNext()) {
            NamedEntity nea = (NamedEntity)neItr.next();
            if (this.setionsToIgnore.contains(nea.getSegmentID()) || nea.getCertainty() == -1) continue;
            boolean addFlag = true;
            if (nea.getTypeID() != 3 && nea.getTypeID() != 2) continue;
            if (l.size() == 0) {
                l.add(nea);
                continue;
            }
            int i = 0;
            while (i < l.size()) {
                NamedEntity x = (NamedEntity)l.get(i);
                int j = SEUtil.contains(nea.getBegin(), nea.getEnd(), x.getBegin(), x.getEnd());
                if (j == 1) {
                    l.remove(i);
                    --i;
                } else if (j == 2) {
                    addFlag = false;
                    break;
                }
                ++i;
            }
            if (!addFlag) continue;
            l.add(nea);
        }
        return l;
    }

    private List<PotentialSideEffect> getPotentialSideEffects(JCas jcas) {
        List<NamedEntity> l = this.getSideEffectNEs(jcas);
        ArrayList<PotentialSideEffect> ll = new ArrayList<PotentialSideEffect>();
        int i = 0;
        while (i < l.size()) {
            int num;
            int[] previousSenSpan;
            NamedEntity ne = l.get(i);
            int[] senSpan = SEUtil.getSentenceSpanContainingGivenSpan(jcas, ne.getBegin(), ne.getEnd());
            String sentence = SEUtil.getSentenceTextContainingGivenSpan(jcas, ne.getBegin(), ne.getEnd()).trim();
            boolean foundDrug = false;
            FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, senSpan[0], senSpan[1] + 1);
            while (neIter.hasNext()) {
                NamedEntity n = (NamedEntity)neIter.next();
                if (n.getTypeID() != 1) continue;
                PotentialSideEffect pse = new PotentialSideEffect();
                pse.ne = ne;
                pse.sentence = sentence;
                pse.senBegin = senSpan[0];
                pse.senEnd = senSpan[1];
                pse.drug = n;
                ll.add(pse);
                foundDrug = true;
            }
            if (!foundDrug && !ne.getSegmentID().equals("20105") && SEUtil.isSpanInSameLine(jcas, (previousSenSpan = SEUtil.getSentenceSpanOfGivenSentenceNum(jcas, num = (num = SEUtil.getSentenceNumContainingGivenSpan(jcas, ne.getBegin(), ne.getEnd())) > 0 ? num - 1 : num))[0], senSpan[1])) {
                neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, previousSenSpan[0], previousSenSpan[1] + 1);
                while (neIter.hasNext()) {
                    NamedEntity n = (NamedEntity)neIter.next();
                    if (n.getTypeID() != 1) continue;
                    PotentialSideEffect pse = new PotentialSideEffect();
                    pse.ne = ne;
                    pse.sentence = String.valueOf(SEUtil.getSentenceTextContainingGivenSpan(jcas, n.getBegin(), n.getEnd())) + " " + sentence;
                    pse.senBegin = previousSenSpan[0];
                    pse.senEnd = senSpan[1];
                    pse.drug = n;
                    ll.add(pse);
                }
            }
            ++i;
        }
        return ll;
    }

    private List<SideEffect> getSideEffectsWithPrioritizedRule(JCas jcas, List<PotentialSideEffect> pseLst) {
        ArrayList<SideEffect> seLst = new ArrayList<SideEffect>();
        for (PotentialSideEffect pse : pseLst) {
            String input = this.getRegexInput(jcas, pse);
            SideEffect se = new SideEffect();
            if (this.isInAllergySection(jcas, pse)) {
                se.pse = pse;
                se.rule = "isInAllergySection";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugDueToPse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugDueToPse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugCausePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugCausePse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugMadePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugMadePse";
                seLst.add(se);
                continue;
            }
            if (this.hasWordOfSideEffect(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasWordOfSideEffect";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfPseDueToDrug(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfPseDueToDrug";
                seLst.add(se);
                continue;
            }
            if (this.hasSideEffectAsPse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasSideEffectAsPse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfNotePseWithDrug(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfNotePseWithDrug";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDiscontDrugBecausePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDiscontDrugBecausePse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfDrugDiscontBecausePse(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfDrugDiscontBecausePse";
                seLst.add(se);
                continue;
            }
            if (this.hasPatternOfPseAfterDrug(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "hasPatternOfPseAfterDrug";
                seLst.add(se);
                continue;
            }
            if (this.isInParenthesis(jcas, pse, input)) {
                se.pse = pse;
                se.rule = "isInParenthesis";
                seLst.add(se);
                continue;
            }
            if (!this.isInDictionary(jcas, pse)) continue;
            se.pse = pse;
            se.rule = "isInDictionary";
            seLst.add(se);
        }
        return seLst;
    }

    private void annotateSideEffects(JCas jcas, List<SideEffect> seLst) {
        int i = 0;
        while (i < seLst.size()) {
            SideEffect se = seLst.get(i);
            SideEffectAnnotation sea = new SideEffectAnnotation(jcas);
            sea.setSideEffect(se.pse.ne);
            if (se.pse.ne != null) {
                sea.setBegin(se.pse.ne.getBegin());
                sea.setEnd(se.pse.ne.getEnd());
            } else {
                sea.setBegin(se.pse.senBegin);
                sea.setEnd(se.pse.senEnd);
            }
            sea.setDrug(se.pse.drug);
            SESentence ses = new SESentence(jcas);
            ses.setBegin(se.pse.senBegin);
            ses.setEnd(se.pse.senEnd);
            sea.setSentence(ses);
            sea.addToIndexes();
            ++i;
        }
    }

    private void setMap(File file, Map<String, String> keyMap, Map<String, Set<String>> seMap) {
        try {
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = fileReader.readLine()) != null) {
                if (line.startsWith("//")) continue;
                line = line.toLowerCase();
                String[] str = line.split("\\|");
                String genericDrug = str[0].trim();
                String[] brandDrugs = str[1].split(",");
                String[] sideEffects = str[2].split(",");
                HashSet<String> seSet = new HashSet<String>();
                keyMap.put(genericDrug, genericDrug);
                int i = 0;
                while (i < brandDrugs.length) {
                    keyMap.put(brandDrugs[i].trim(), genericDrug);
                    ++i;
                }
                i = 0;
                while (i < sideEffects.length) {
                    seSet.add(sideEffects[i].trim());
                    ++i;
                }
                seMap.put(genericDrug, seSet);
            }
            fileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasPatternOfPseDueToDrug(JCas jcas, PotentialSideEffect pse, String input) {
        if (pse.drug.getCertainty() == -1) {
            return false;
        }
        PatternMatch pm = new PatternMatch("(<@PSE>).*(KW).*(<@DRUG>)", input, this.causeWord1);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(3));
    }

    private boolean hasPatternOfDrugDueToPse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW).*(<@PSE>)", input, this.causeWord2);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2)) || !pm.isDistantBetween(pm.mat.end(1), pm.mat.start(2));
    }

    private boolean hasPatternOfDiscontDrugBecausePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(KW).*(<@DRUG>).*(because|after).*(<@PSE>)", input, this.discontVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(3), pm.mat.start(4))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(2));
    }

    private boolean hasPatternOfDrugDiscontBecausePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW).*(because|after).*(<@PSE>)", input, this.discontVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(3), pm.mat.start(4))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(pm.mat.end(1), drugSpan[0]);
    }

    private boolean hasPatternOfNotePseWithDrug(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(KW).*(<@PSE>).*(with).*(<@DRUG>)", input, this.noteVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(3), pm.mat.start(4))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(3), pm.mat.start(4), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(4));
    }

    private boolean hasPatternOfDrugCausePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW).*(<@PSE>)", input, this.causeVerb);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(pm.mat.end(1), drugSpan[0]);
    }

    private boolean hasPatternOfDrugMadePse(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>).*(KW)\\s(him|her)\\s(<@PSE>)", input, this.madeVerb);
        if (!pm.mat.find()) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2), drugSpan) || !pm.isDistantBetween(pm.mat.end(1), drugSpan[0]);
    }

    private boolean hasWordOfSideEffect(JCas jcas, PotentialSideEffect pse, String input) {
        String pseStr = pse.ne.getCoveredText().replace('-', ' ').toLowerCase().trim();
        if (this.sideEffectWord.contains(pseStr)) {
            return false;
        }
        String pseSen = pse.sentence.replace('-', ' ').toLowerCase().trim();
        PatternMatch pm = new PatternMatch("(KW)", pseSen, this.sideEffectWord);
        if (!pm.mat.find()) {
            return false;
        }
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, pse.senBegin, pse.senEnd + 1);
        while (neIter.hasNext()) {
            NamedEntity ne = (NamedEntity)neIter.next();
            if (ne.getCoveredText().replace('-', ' ').toLowerCase().trim().indexOf(pm.mat.group(1)) == -1 || ne.getCertainty() != -1) continue;
            return false;
        }
        return true;
    }

    private boolean hasSideEffectAsPse(JCas jcas, PotentialSideEffect pse, String input) {
        if (input.matches(".*(dicussed|concerned).*")) {
            return false;
        }
        String str = pse.ne.getCoveredText().replace('-', ' ').toLowerCase().trim();
        if (!this.sideEffectWord.contains(str)) {
            return false;
        }
        return !input.matches(".*(<PSE>).*");
    }

    private boolean hasPatternOfPseAfterDrug(JCas jcas, PotentialSideEffect pse, String input) {
        if (input.matches(".*(check).*")) {
            return false;
        }
        PatternMatch pm = new PatternMatch("(<@PSE>).*(KW).*(<@DRUG>)", input, this.afterWord);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.isDrugBetween(pm.mat.end(1), pm.mat.start(2))) {
            return false;
        }
        if (pm.isPseBetween(pm.mat.end(2), pm.mat.start(3))) {
            return false;
        }
        int[] drugSpan = new int[]{-1, -1};
        return !pm.isDrugBetween(pm.mat.end(2), pm.mat.start(3), drugSpan) || !pm.isDistantBetween(drugSpan[1], pm.mat.start(3));
    }

    private boolean isInAllergySection(JCas jcas, PotentialSideEffect pse) {
        if (!pse.ne.getSegmentID().equals("20105")) {
            return false;
        }
        boolean inMedication = false;
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator saIter = indexes.getAnnotationIndex(Segment.type).iterator();
        block0: while (saIter.hasNext()) {
            Segment sa = (Segment)saIter.next();
            if (sa.getBegin() >= pse.ne.getBegin() || sa.getEnd() <= pse.ne.getEnd()) continue;
            FSIterator ssIter = FSUtil.getAnnotationsInSpanIterator(jcas, SubSectionAnnotation.type, sa.getBegin(), sa.getEnd());
            while (ssIter.hasNext()) {
                SubSectionAnnotation ss = (SubSectionAnnotation)ssIter.next();
                if (!ss.getCoveredText().toLowerCase().trim().startsWith("medication") || ss.getSubSectionHeaderBegin() >= pse.ne.getBegin() || ss.getSubSectionBodyEnd() <= pse.ne.getEnd()) continue;
                inMedication = true;
                continue block0;
            }
        }
        return inMedication;
    }

    private boolean isInParenthesis(JCas jcas, PotentialSideEffect pse, String input) {
        PatternMatch pm = new PatternMatch("(<@DRUG>)\\s(\\(.*<@PSE>.*\\))", input);
        if (!pm.mat.find()) {
            return false;
        }
        if (pm.mat.group(2).matches("\\(.*((for)|(treated with)).*\\)")) {
            return false;
        }
        if (pm.mat.group(2).matches("\\(.*(made|got).*\\)")) {
            return true;
        }
        return input.matches(".*trial.*");
    }

    private boolean isInDictionary(JCas jcas, PotentialSideEffect pse) {
        String pseStr;
        Set<String> seSet;
        String drug = pse.drug.getCoveredText().toLowerCase().trim();
        return this.keyDrugMap.containsKey(drug) && (seSet = this.sideEffectMap.get(this.keyDrugMap.get(drug))).contains(pseStr = pse.ne.getCoveredText().toLowerCase().trim());
    }

    private String getRegexInput(JCas jcas, PotentialSideEffect pse) {
        String str = pse.sentence.toLowerCase();
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator(jcas, NamedEntity.type, pse.senBegin, pse.senEnd + 1);
        while (neIter.hasNext()) {
            NamedEntity nea = (NamedEntity)neIter.next();
            if (nea.getTypeID() == 1) {
                String drug = "";
                drug = nea.getBegin() == pse.drug.getBegin() && nea.getEnd() == pse.drug.getEnd() ? "<@DRUG>" : "<DRUG>";
                str = str.replaceFirst(nea.getCoveredText().replaceAll("[\\<\\(\\[\\{\\\\^\\-\\=\\$\\!\\|\\]\\}\\)\\?\\*\\+\\.\\>]", "").toLowerCase(), drug);
                continue;
            }
            if (nea.getTypeID() != 2 && nea.getTypeID() != 3) continue;
            String ps = "";
            ps = nea.getBegin() == pse.ne.getBegin() && nea.getEnd() == pse.ne.getEnd() ? "<@PSE>" : "<PSE>";
            str = str.replaceFirst(nea.getCoveredText().replaceAll("[\\<\\(\\[\\{\\\\^\\-\\=\\$\\!\\|\\]\\}\\)\\?\\*\\+\\.\\>]", "").toLowerCase(), ps);
        }
        return str.trim();
    }

    private class PotentialSideEffect {
        NamedEntity ne;
        NamedEntity drug;
        String sentence;
        int senBegin;
        int senEnd;

        private PotentialSideEffect() {
        }
    }

    private class SideEffect {
        PotentialSideEffect pse;
        String rule;

        private SideEffect() {
        }
    }
}

