/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.sideeffect.cc;

import edu.mayo.bmi.uima.core.util.DocumentIDAnnotationUtil;
import edu.mayo.bmi.uima.sideeffect.type.SESentence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

public class SideEffectSentenceCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUT_FILE = "OutputFile";
    public static final String PARAM_DELIMITER = "Delimiter";
    private BufferedWriter iv_bw = null;
    private String iv_delimiter;

    @Override
    public void initialize() throws ResourceInitializationException {
        try {
            String filename = (String)this.getConfigParameterValue(PARAM_OUTPUT_FILE);
            File outFile = new File(filename);
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            this.iv_bw = new BufferedWriter(new FileWriter(outFile));
            this.iv_delimiter = (String)this.getConfigParameterValue(PARAM_DELIMITER);
        }
        catch (Exception ioe) {
            throw new ResourceInitializationException(ioe);
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            String docName = DocumentIDAnnotationUtil.getDocumentID(jcas);
            FSIterator ssIter = indexes.getAnnotationIndex(SESentence.type).iterator();
            while (ssIter.hasNext()) {
                SESentence ss = (SESentence)ssIter.next();
                String ssText = ss.getCoveredText().trim();
                String ssSpan = String.valueOf(Integer.toString(ss.getBegin())) + ":" + Integer.toString(ss.getEnd());
                String output = String.valueOf(docName) + this.iv_delimiter + ssText + this.iv_delimiter + ssSpan;
                this.iv_bw.write(String.valueOf(output) + "\n");
            }
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }

    @Override
    public void collectionProcessComplete(ProcessTrace arg0) throws ResourceProcessException, IOException {
        super.collectionProcessComplete(arg0);
        try {
            this.iv_bw.flush();
            this.iv_bw.close();
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }
}

