/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.termspotter.ae;

import edu.mayo.bmi.fsm.pad.machine.SubSectionPadIdFSM;
import edu.mayo.bmi.fsm.pad.output.SubSectionIndicator;
import edu.mayo.bmi.uima.core.fsm.adapters.ContractionTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.DecimalTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.IntegerTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.NewlineTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.PunctuationTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.SymbolTokenAdapter;
import edu.mayo.bmi.uima.core.fsm.adapters.WordTokenAdapter;
import edu.mayo.bmi.uima.core.resource.FileResource;
import edu.mayo.bmi.uima.core.type.BaseToken;
import edu.mayo.bmi.uima.core.type.ContractionToken;
import edu.mayo.bmi.uima.core.type.NewlineToken;
import edu.mayo.bmi.uima.core.type.NumToken;
import edu.mayo.bmi.uima.core.type.PunctuationToken;
import edu.mayo.bmi.uima.core.type.Segment;
import edu.mayo.bmi.uima.core.type.Sentence;
import edu.mayo.bmi.uima.core.type.SymbolToken;
import edu.mayo.bmi.uima.core.type.WordToken;
import edu.mayo.bmi.uima.core.util.FSUtil;
import edu.mayo.bmi.uima.pad.type.SubSection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class SubSectionAnnotator
extends JTextAnnotator_ImplBase {
    public static Logger iv_logger = Logger.getLogger(SubSectionAnnotator.class);
    private SubSectionPadIdFSM iv_subMedSectionFSM;
    private List<String> examTitleWords;
    private final String EXAM_TITLE_WORDS_FILE = "ExamTitleWordsFile";

    @Override
    public void initialize(AnnotatorContext aCtx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(aCtx);
        this.iv_subMedSectionFSM = new SubSectionPadIdFSM();
        try {
            FileResource resrcExamTitle = (FileResource)aCtx.getResourceObject("ExamTitleWordsFile");
            File examTitleWordsFile = resrcExamTitle.getFile();
            this.loadExamTitleWords(examTitleWordsFile);
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas jcas, ResultSpecification arg1) throws AnnotatorProcessException {
        try {
            this.createSubSections(jcas);
        }
        catch (CASException ce) {
            throw new AnnotatorProcessException(ce);
        }
        catch (IllegalAccessException iae) {
            throw new AnnotatorProcessException(iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new AnnotatorProcessException(nsfe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AnnotatorProcessException(cnfe);
        }
        catch (Exception e) {
            throw new AnnotatorProcessException(e);
        }
    }

    private void createSubSections(JCas jcas) throws Exception {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator subSectItr = indexes.getAnnotationIndex(BaseToken.type).iterator();
        ArrayList<edu.mayo.bmi.fsm.token.BaseToken> baseTokenList = new ArrayList<edu.mayo.bmi.fsm.token.BaseToken>();
        while (subSectItr.hasNext()) {
            BaseToken bta = (BaseToken)subSectItr.next();
            baseTokenList.add(this.adaptToBaseToken(bta));
        }
        this.prepareSubSection(jcas, indexes, this.iv_subMedSectionFSM.execute(baseTokenList));
        boolean CTTypeExam = this.findSubSectionExamTitle(jcas);
    }

    private void prepareSubSection(JCas jcas, JFSIndexRepository indexes, Set<?> subSectionTokenSet) throws Exception {
        Iterator<Object> subSectionTokenItr = this.sortSubSectionItr(subSectionTokenSet.toArray()).iterator();
        Iterator<Object> subSectionMatchTokenItr = this.sortSubSectionItr(subSectionTokenSet.toArray()).iterator();
        if (subSectionMatchTokenItr.hasNext()) {
            subSectionMatchTokenItr.next();
        }
        while (subSectionTokenItr.hasNext()) {
            boolean correctOrder = false;
            SubSectionIndicator subsectionNext = null;
            SubSectionIndicator subsectionThis = (SubSectionIndicator)subSectionTokenItr.next();
            while (subSectionMatchTokenItr.hasNext() && !correctOrder) {
                subsectionNext = (SubSectionIndicator)subSectionMatchTokenItr.next();
                if (subsectionThis.getStartOffset() >= subsectionNext.getStartOffset()) continue;
                correctOrder = true;
            }
            SubSection subsectionAnnotation = new SubSection(jcas, subsectionThis.getStartOffset(), subsectionThis.getEndOffset());
            subsectionAnnotation.setSubSectionBodyBegin(subsectionAnnotation.getEnd() + 1);
            boolean foundEnd = false;
            HashSet segmentSet = new HashSet();
            FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
            while (segmentItr.hasNext()) {
                segmentSet.add(segmentItr.next());
            }
            for (Segment segmentAnnotation : segmentSet) {
                if (segmentAnnotation.getBegin() <= subsectionThis.getStartOffset() && segmentAnnotation.getEnd() >= subsectionThis.getStartOffset()) {
                    FSIterator sentenceItr = FSUtil.getAnnotationsInSpanIterator(jcas, Sentence.type, segmentAnnotation.getBegin(), segmentAnnotation.getEnd());
                    Sentence sentenceAnnotation = null;
                    while (sentenceItr.hasNext() && !foundEnd) {
                        sentenceAnnotation = (Sentence)sentenceItr.next();
                        if (!foundEnd && subsectionNext != null) {
                            if (subsectionNext.getStartOffset() > subsectionThis.getStartOffset()) {
                                if (subsectionNext.getStartOffset() >= sentenceAnnotation.getEnd() && sentenceAnnotation.getEnd() > subsectionAnnotation.getEnd() && sentenceAnnotation.getBegin() != subsectionThis.getStartOffset()) {
                                    int newLineCount = 0;
                                    FSIterator baseItr = FSUtil.getAnnotationsInSpanIterator(jcas, BaseToken.type, sentenceAnnotation.getEnd(), subsectionNext.getStartOffset() - 1);
                                    while (baseItr.hasNext()) {
                                        BaseToken checkToken = (BaseToken)baseItr.next();
                                        if (!(checkToken instanceof NewlineToken) && !(checkToken instanceof SymbolToken)) continue;
                                        ++newLineCount;
                                    }
                                    if (sentenceAnnotation.getEnd() + 1 + newLineCount != subsectionNext.getStartOffset() && sentenceAnnotation.getEnd() + newLineCount != subsectionNext.getStartOffset()) continue;
                                    foundEnd = true;
                                    subsectionAnnotation.setSubSectionBodyEnd(sentenceAnnotation.getEnd());
                                    subsectionAnnotation.setStatus(subsectionThis.getStatus());
                                    subsectionAnnotation.setSubSectionHeaderBegin(subsectionAnnotation.getBegin());
                                    subsectionAnnotation.setSubSectionHeaderEnd(subsectionAnnotation.getEnd());
                                    subsectionAnnotation.setEnd(subsectionAnnotation.getSubSectionBodyEnd());
                                    subsectionAnnotation.setParentSectionId(segmentAnnotation.getId());
                                    continue;
                                }
                                if (subsectionNext.getEndOffset() != sentenceAnnotation.getEnd() && subsectionNext.getEndOffset() >= sentenceAnnotation.getEnd()) continue;
                                foundEnd = true;
                                subsectionAnnotation.setSubSectionBodyEnd(subsectionNext.getStartOffset());
                                subsectionAnnotation.setStatus(subsectionThis.getStatus());
                                subsectionAnnotation.setSubSectionHeaderBegin(subsectionAnnotation.getBegin());
                                subsectionAnnotation.setSubSectionHeaderEnd(subsectionAnnotation.getEnd());
                                subsectionAnnotation.setEnd(subsectionAnnotation.getSubSectionBodyEnd());
                                subsectionAnnotation.setParentSectionId(segmentAnnotation.getId());
                                continue;
                            }
                            if (subsectionThis.getStartOffset() > sentenceAnnotation.getEnd() || sentenceAnnotation.getEnd() <= subsectionNext.getEndOffset() || sentenceAnnotation.getEnd() + 1 != subsectionThis.getStartOffset() && sentenceAnnotation.getEnd() != subsectionThis.getStartOffset()) continue;
                            foundEnd = true;
                            subsectionAnnotation.setSubSectionBodyEnd(sentenceAnnotation.getEnd());
                            subsectionAnnotation.setStatus(subsectionThis.getStatus());
                            subsectionAnnotation.setSubSectionHeaderBegin(subsectionAnnotation.getBegin());
                            subsectionAnnotation.setSubSectionHeaderEnd(subsectionAnnotation.getEnd());
                            subsectionAnnotation.setEnd(subsectionAnnotation.getSubSectionBodyEnd());
                            subsectionAnnotation.setParentSectionId(segmentAnnotation.getId());
                            continue;
                        }
                        if (subsectionThis != null && !foundEnd && subsectionThis.getStartOffset() < sentenceAnnotation.getBegin() && subsectionThis.getStartOffset() >= segmentAnnotation.getBegin() && subsectionThis.getStartOffset() <= segmentAnnotation.getEnd()) {
                            foundEnd = true;
                            subsectionAnnotation.setSubSectionBodyEnd(sentenceAnnotation.getEnd());
                            subsectionAnnotation.setStatus(subsectionThis.getStatus());
                            subsectionAnnotation.setSubSectionHeaderBegin(subsectionAnnotation.getBegin());
                            subsectionAnnotation.setSubSectionHeaderEnd(subsectionAnnotation.getEnd());
                            subsectionAnnotation.setEnd(subsectionAnnotation.getSubSectionBodyEnd());
                            subsectionAnnotation.setParentSectionId(segmentAnnotation.getId());
                            continue;
                        }
                        if (subsectionThis == null || foundEnd || subsectionThis.getEndOffset() != sentenceAnnotation.getEnd()) continue;
                        foundEnd = true;
                        subsectionAnnotation.setSubSectionBodyEnd(sentenceAnnotation.getEnd());
                        subsectionAnnotation.setStatus(subsectionThis.getStatus());
                        subsectionAnnotation.setSubSectionHeaderBegin(subsectionAnnotation.getBegin());
                        subsectionAnnotation.setSubSectionHeaderEnd(subsectionAnnotation.getEnd());
                        subsectionAnnotation.setEnd(subsectionAnnotation.getSubSectionBodyEnd());
                        subsectionAnnotation.setParentSectionId(segmentAnnotation.getId());
                    }
                }
                if (!foundEnd) continue;
                subsectionAnnotation.addToIndexes();
            }
        }
        FSIterator segmentItrAgain = indexes.getAnnotationIndex(Segment.type).iterator();
        while (segmentItrAgain.hasNext()) {
            Segment segmentScope = (Segment)segmentItrAgain.next();
            FSIterator subSectionItr = FSUtil.getAnnotationsInSpanIterator(jcas, SubSection.type, segmentScope.getBegin(), segmentScope.getEnd());
            while (subSectionItr.hasNext()) {
                SubSection checkSubsection = (SubSection)subSectionItr.next();
                if (segmentScope.getEnd() < checkSubsection.getSubSectionBodyEnd() || checkSubsection.getBegin() < segmentScope.getBegin()) {
                    FSIterator sentenceSubSection = FSUtil.getAnnotationsInSpanIterator(jcas, Sentence.type, segmentScope.getBegin(), segmentScope.getEnd());
                    boolean foundModifiedEnd = false;
                    while (sentenceSubSection.hasNext() && !foundModifiedEnd) {
                        Sentence checkSentence = (Sentence)sentenceSubSection.next();
                        if (checkSentence.getBegin() < checkSubsection.getBegin() || checkSentence.getEnd() < checkSubsection.getEnd()) continue;
                        checkSubsection.setSubSectionBodyEnd(checkSentence.getEnd());
                        foundModifiedEnd = true;
                    }
                    continue;
                }
                if (subSectionItr.hasNext()) continue;
                checkSubsection.setSubSectionBodyEnd(segmentScope.getEnd() - 1);
                checkSubsection.setEnd(segmentScope.getEnd() - 1);
            }
        }
    }

    private List<Object> sortSubSectionItr(Object[] holdOutSet) {
        ArrayList<Object> holdList = new ArrayList<Object>();
        SubSectionIndicator tempSsi = null;
        int i = 0;
        while (i < holdOutSet.length - 1) {
            SubSectionIndicator hos1 = (SubSectionIndicator)holdOutSet[i];
            SubSectionIndicator hos2 = (SubSectionIndicator)holdOutSet[i + 1];
            if (hos1.getStartOffset() > hos2.getStartOffset()) {
                tempSsi = hos2;
                holdOutSet[i + 1] = hos1;
                holdOutSet[i] = tempSsi;
                this.sortSubSectionItr(holdOutSet);
            }
            ++i;
        }
        int j = 0;
        while (j < holdOutSet.length) {
            holdList.add(holdOutSet[j]);
            ++j;
        }
        return holdList;
    }

    private edu.mayo.bmi.fsm.token.BaseToken adaptToBaseToken(BaseToken bta) throws Exception {
        if (bta instanceof WordToken) {
            WordToken wta = (WordToken)bta;
            return new WordTokenAdapter(wta);
        }
        if (bta instanceof NumToken) {
            NumToken nta = (NumToken)bta;
            if (nta.getNumType() == 1) {
                return new IntegerTokenAdapter(nta);
            }
            return new DecimalTokenAdapter(nta);
        }
        if (bta instanceof PunctuationToken) {
            PunctuationToken pta = (PunctuationToken)bta;
            return new PunctuationTokenAdapter(pta);
        }
        if (bta instanceof NewlineToken) {
            NewlineToken nta = (NewlineToken)bta;
            return new NewlineTokenAdapter(nta);
        }
        if (bta instanceof ContractionToken) {
            ContractionToken cta = (ContractionToken)bta;
            return new ContractionTokenAdapter(cta);
        }
        if (bta instanceof SymbolToken) {
            SymbolToken sta = (SymbolToken)bta;
            return new SymbolTokenAdapter(sta);
        }
        throw new Exception("No CDT adapter for class: " + bta.getClass());
    }

    private void loadExamTitleWords(File examTypeWordsFile) throws FileNotFoundException, IOException {
        String line;
        if (this.examTitleWords == null) {
            this.examTitleWords = new ArrayList<String>();
        }
        FileReader fr = new FileReader(examTypeWordsFile);
        BufferedReader br = new BufferedReader(fr);
        while ((line = br.readLine()) != null) {
            String examTypeWord = line.trim();
            this.examTitleWords.add(examTypeWord);
        }
    }

    private boolean findSubSectionExamTitle(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator secItr = indexes.getAnnotationIndex(SubSection.type).iterator();
        boolean hasUSExam = false;
        boolean hasLowerExt = false;
        boolean hasSoloLowerExt = false;
        boolean hasCTExt = false;
        while (secItr.hasNext()) {
            SubSection sa = (SubSection)secItr.next();
            for (String entryExamTitle : this.examTitleWords) {
                String[] spanExamTitle = entryExamTitle.split(",");
                Integer lastOffset = new Integer(0);
                if (spanExamTitle.length >= 4) {
                    lastOffset = new Integer(spanExamTitle[3]);
                }
                if ((sa.getCoveredText().indexOf(spanExamTitle[0]) < new Integer(spanExamTitle[2]) || lastOffset != 0 && sa.getCoveredText().indexOf(spanExamTitle[0]) >= lastOffset) && (sa.getCoveredText().indexOf(spanExamTitle[0]) < new Integer(spanExamTitle[2]) || lastOffset != 0 && sa.getCoveredText().indexOf(spanExamTitle[0]) >= lastOffset)) continue;
                if (spanExamTitle[1].equals("US_EXAM")) {
                    hasUSExam = true;
                }
                if (spanExamTitle[1].equals("LOWER_EXT")) {
                    hasLowerExt = true;
                }
                if (spanExamTitle[1].equals("US_LOWER_SOLO")) {
                    hasSoloLowerExt = true;
                } else if (spanExamTitle[1].equals("CT_EXAM")) {
                    hasCTExt = true;
                }
                if (hasUSExam && hasSoloLowerExt) {
                    sa.setParentSectionId("US_LOWER_SOLO");
                    continue;
                }
                if (hasLowerExt) {
                    sa.setParentSectionId("US_LOWER_EXT");
                    continue;
                }
                if (hasSoloLowerExt) {
                    sa.setParentSectionId("US_EXAM_SOLO");
                    continue;
                }
                sa.setParentSectionId(spanExamTitle[1]);
            }
        }
        return hasCTExt;
    }
}

