/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.uima.termspotter.cc;

import edu.mayo.bmi.uima.core.cc.NonTerminalConsumer;
import edu.mayo.bmi.uima.pad.type.PADTerm;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class RadialogyTermLookup
extends CasConsumer_ImplBase
implements NonTerminalConsumer {
    public static final String PARAM_OUTPUTFILE = "outputFileName";
    private static final String[] RADIALOGY_TERMS = new String[]{"Cardiomegally", "Pulmonary venous hypertension", "Pleural Effusion", "Edema", "Heart failure"};
    private File iv_outputFile;
    private FileWriter iv_fileWriter;
    private String webServiceOut;

    @Override
    public void initialize() throws ResourceInitializationException {
        try {
            super.initialize();
            String outputFileName = (String)this.getConfigParameterValue(PARAM_OUTPUTFILE);
            this.iv_outputFile = new File(outputFileName);
            if (!this.iv_outputFile.exists()) {
                this.iv_outputFile.createNewFile();
            }
            if (!this.iv_outputFile.canWrite() || !this.iv_outputFile.exists()) {
                throw new ResourceInitializationException(new Exception("Parameter setting 'OutputFileName' is invalid."));
            }
            this.iv_fileWriter = new FileWriter(this.iv_outputFile);
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException(new Exception("Parameter setting 'OutputFileName' is invalid."));
        }
    }

    @Override
    public void processCas(CAS cas) throws ResourceProcessException {
        StringBuffer data = new StringBuffer();
        int[] foundTerms = new int[5];
        try {
            JCas jcas = cas.getJCas();
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator annotItr = indexes.getAnnotationIndex(PADTerm.type).iterator();
            while (annotItr.hasNext()) {
                PADTerm hft = (PADTerm)annotItr.next();
                String dictionaryTerm = hft.getHitDictionaryValue();
                this.storeTerm(dictionaryTerm, foundTerms);
            }
            this.converToCsvData(foundTerms, data);
            this.iv_fileWriter.write(String.valueOf(data.toString()) + "\n");
        }
        catch (CASException ce) {
            throw new ResourceProcessException(ce);
        }
        catch (IOException ioe) {
            throw new ResourceProcessException(ioe);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.iv_fileWriter.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void converToCsvData(int[] foundTerms, StringBuffer data) {
        int i = 0;
        while (i < foundTerms.length) {
            data.append(",");
            data.append(foundTerms[i]);
            ++i;
        }
        System.out.println("Radialogy term spotter" + data.toString());
        this.webServiceOut = data.toString();
    }

    private void storeTerm(String currentTerm, int[] foundTerms) {
        int i = 0;
        while (i < RADIALOGY_TERMS.length) {
            if (RADIALOGY_TERMS[i].compareToIgnoreCase(currentTerm) == 0 || RADIALOGY_TERMS[i].indexOf(currentTerm) >= 0 || currentTerm.indexOf(RADIALOGY_TERMS[i]) >= 0) {
                foundTerms[i] = 1;
                break;
            }
            ++i;
        }
    }

    @Override
    public String getOutputXml() {
        System.out.println("RadialogyTermLookup.getOutputXml():[" + this.webServiceOut + "]");
        return this.webServiceOut;
    }
}

