/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbCitation;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToCitation
extends Transformation {
    private static final String INFO = "Citation";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> out = ToCitation.GetCitation(in, conn, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToCitation.GetTestStr(args, "Colour");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToCitation.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToCitation.PrintResults(in, outs);
    }

    private static Vector<LexItem> GetCitation(LexItem in, Connection conn, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String inStr = in.GetSourceTerm();
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        Vector<LexItem> out = new Vector<LexItem>();
        try {
            Vector<InflectionRecord> factList = DbCitation.GetCitations(inStr, conn);
            for (int i = 0; i < factList.size(); ++i) {
                InflectionRecord record = factList.elementAt(i);
                String citation = record.GetCitationTerm();
                String unTerm = record.GetUninflectedTerm();
                long curCat = record.GetCategory();
                long curInfl = record.GetInflection();
                if (!InputFilter.IsLegal(inCat, curCat)) continue;
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = infoStr;
                }
                if (mutateFlag) {
                    String fs = GlobalBehavior.GetFieldSeparator();
                    mutate = inStr + fs + unTerm + fs + Category.ToName(curCat) + fs + Inflection.ToName(curInfl) + fs + citation + fs + record.GetEui() + fs;
                }
                LexItem temp = ToCitation.UpdateLexItem(in, citation, 38, curCat, Inflection.GetBitValue(0), details, mutate);
                out.addElement(temp);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return out;
    }
}

