/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class FileEventStream
implements EventStream {
    BufferedReader reader;
    String line;

    public FileEventStream(String string, String string2) throws IOException {
        this.reader = string2 == null ? new BufferedReader(new FileReader(string)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
    }

    public FileEventStream(String string) throws IOException {
        this(string, null);
    }

    public FileEventStream(File file) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
    }

    public boolean hasNext() {
        try {
            this.line = this.reader.readLine();
            return null != this.line;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return false;
        }
    }

    public Event nextEvent() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.line);
        String string = stringTokenizer.nextToken();
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return new Event(string, stringArray);
    }

    public static String toLine(Event event) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(event.getOutcome());
        String[] stringArray = event.getContext();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" " + stringArray[i]);
        }
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: FileEventStream eventfile [iterations cutoff]");
            System.exit(1);
        }
        int n = 0;
        String string = stringArray[n++];
        FileEventStream fileEventStream = new FileEventStream(string);
        int n2 = 100;
        int n3 = 5;
        if (n < stringArray.length) {
            n2 = Integer.parseInt(stringArray[n++]);
            n3 = Integer.parseInt(stringArray[n++]);
        }
        GISModel gISModel = GIS.trainModel(fileEventStream, n2, n3);
        new SuffixSensitiveGISModelWriter(gISModel, new File(string + ".bin.gz")).persist();
    }
}

