/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import opennlp.maxent.Context;
import opennlp.maxent.EvalParameters;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.Prior;
import opennlp.maxent.TObjectIndexHashMap;
import opennlp.maxent.UniformPrior;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

public final class GISModel
implements MaxentModel {
    private final TObjectIndexHashMap pmap;
    private final String[] ocNames;
    private DecimalFormat df;
    private EvalParameters evalParams;
    private Prior prior;

    public GISModel(Context[] contextArray, String[] stringArray, String[] stringArray2, int n, double d) {
        this(contextArray, stringArray, stringArray2, n, d, new UniformPrior());
    }

    public GISModel(Context[] contextArray, String[] stringArray, String[] stringArray2, int n, double d, Prior prior) {
        this.pmap = new TObjectIndexHashMap(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.pmap.put(stringArray[i], i);
        }
        this.ocNames = stringArray2;
        this.evalParams = new EvalParameters(contextArray, d, n, this.ocNames.length);
        this.prior = prior;
        prior.setLabels(this.ocNames, stringArray);
    }

    public final double[] eval(String[] stringArray) {
        return this.eval(stringArray, new double[this.evalParams.numOutcomes]);
    }

    public final double[] eval(String[] stringArray, float[] fArray) {
        return this.eval(stringArray, fArray, new double[this.evalParams.numOutcomes]);
    }

    public static double[] eval(int[] nArray, double[] dArray, EvalParameters evalParameters) {
        return GISModel.eval(nArray, null, dArray, evalParameters);
    }

    public static double[] eval(int[] nArray, float[] fArray, double[] dArray, EvalParameters evalParameters) {
        int n;
        Context[] contextArray = evalParameters.params;
        int[] nArray2 = new int[evalParameters.numOutcomes];
        double d = 1.0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            Context context = contextArray[nArray[i]];
            int[] nArray3 = context.getOutcomes();
            double[] dArray2 = context.getParameters();
            if (fArray != null) {
                d = fArray[i];
            }
            for (n = 0; n < nArray3.length; ++n) {
                int n2;
                int n3 = n2 = nArray3[n];
                nArray2[n3] = nArray2[n3] + 1;
                int n4 = n2;
                dArray[n4] = dArray[n4] + dArray2[n] * d;
            }
        }
        double d2 = 0.0;
        for (n = 0; n < evalParameters.numOutcomes; ++n) {
            dArray[n] = evalParameters.correctionParam != 0.0 ? Math.exp(dArray[n] * evalParameters.constantInverse + (1.0 - (double)nArray2[n] / evalParameters.correctionConstant) * evalParameters.correctionParam) : Math.exp(dArray[n] * evalParameters.constantInverse);
            d2 += dArray[n];
        }
        n = 0;
        while (n < evalParameters.numOutcomes) {
            int n5 = n++;
            dArray[n5] = dArray[n5] / d2;
        }
        return dArray;
    }

    public final double[] eval(String[] stringArray, double[] dArray) {
        return this.eval(stringArray, null, dArray);
    }

    public final double[] eval(String[] stringArray, float[] fArray, double[] dArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.pmap.get(stringArray[i]);
        }
        this.prior.logPrior(dArray, nArray, fArray);
        return GISModel.eval(nArray, fArray, dArray, this.evalParams);
    }

    public final String getBestOutcome(double[] dArray) {
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        return this.ocNames[n];
    }

    public final String getAllOutcomes(double[] dArray) {
        if (dArray.length != this.ocNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        if (this.df == null) {
            this.df = new DecimalFormat("0.0000");
        }
        StringBuffer stringBuffer = new StringBuffer(dArray.length * 2);
        stringBuffer.append(this.ocNames[0]).append("[").append(this.df.format(dArray[0])).append("]");
        for (int i = 1; i < dArray.length; ++i) {
            stringBuffer.append("  ").append(this.ocNames[i]).append("[").append(this.df.format(dArray[i])).append("]");
        }
        return stringBuffer.toString();
    }

    public final String getOutcome(int n) {
        return this.ocNames[n];
    }

    public int getIndex(String string) {
        for (int i = 0; i < this.ocNames.length; ++i) {
            if (!this.ocNames[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getNumOutcomes() {
        return this.evalParams.numOutcomes;
    }

    public final Object[] getDataStructures() {
        Object[] objectArray = new Object[]{this.evalParams.params, this.pmap, this.ocNames, new Integer((int)this.evalParams.correctionConstant), new Double(this.evalParams.correctionParam)};
        return objectArray;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: GISModel modelname < contexts");
            System.exit(1);
        }
        GISModel gISModel = new SuffixSensitiveGISModelReader(new File(stringArray[0])).getModel();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        DecimalFormat decimalFormat = new DecimalFormat(".###");
        String string = bufferedReader.readLine();
        while (string != null) {
            String[] stringArray2 = string.split(" ");
            double[] dArray = gISModel.eval(stringArray2);
            for (int i = 0; i < dArray.length; ++i) {
                System.out.print("[" + gISModel.getOutcome(i) + " " + decimalFormat.format(dArray[i]) + "] ");
            }
            System.out.println();
            string = bufferedReader.readLine();
        }
    }
}

