/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import opennlp.maxent.DataIndexer;
import opennlp.maxent.EvalParameters;
import opennlp.maxent.EventStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.MutableContext;
import opennlp.maxent.OnePassDataIndexer;
import opennlp.maxent.Prior;
import opennlp.maxent.UniformPrior;

class GISTrainer {
    private boolean useSimpleSmoothing = false;
    private boolean useSlackParameter = false;
    private boolean useGaussianSmoothing = false;
    private double sigma = 2.0;
    private double _smoothingObservation = 0.1;
    private boolean printMessages = false;
    private int numUniqueEvents;
    private int numPreds;
    private int numOutcomes;
    private int[][] contexts;
    private float[][] values;
    private int[] outcomeList;
    private int[] numTimesEventsSeen;
    private int[] predicateCounts;
    private int cutoff;
    private String[] outcomeLabels;
    private String[] predLabels;
    private MutableContext[] observedExpects;
    private MutableContext[] params;
    private MutableContext[] modelExpects;
    private Prior prior;
    private double cfObservedExpect;
    private double CFMOD;
    private final double NEAR_ZERO = 0.01;
    private final double LLThreshold = 1.0E-4;
    double[] modelDistribution;
    int[] numfeats;
    EvalParameters evalParams;

    GISTrainer() {
    }

    GISTrainer(boolean bl) {
        this();
        this.printMessages = bl;
    }

    public void setSmoothing(boolean bl) {
        this.useSimpleSmoothing = bl;
    }

    public void setSmoothingObservation(double d) {
        this._smoothingObservation = d;
    }

    public GISModel trainModel(EventStream eventStream, int n, int n2) {
        return this.trainModel(n, new OnePassDataIndexer(eventStream, n2), n2);
    }

    public GISModel trainModel(int n, DataIndexer dataIndexer, int n2) {
        return this.trainModel(n, dataIndexer, new UniformPrior(), n2);
    }

    public GISModel trainModel(int n, DataIndexer dataIndexer, Prior prior, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.display("Incorporating indexed data for training...  \n");
        this.contexts = dataIndexer.getContexts();
        this.values = dataIndexer.getValues();
        this.cutoff = n2;
        this.predicateCounts = dataIndexer.getPredCounts();
        this.numTimesEventsSeen = dataIndexer.getNumTimesEventsSeen();
        this.numUniqueEvents = this.contexts.length;
        this.prior = prior;
        int n7 = this.contexts[0].length;
        for (int i = 1; i < this.contexts.length; ++i) {
            if (this.contexts[i].length <= n7) continue;
            n7 = this.contexts[i].length;
        }
        this.display("done.\n");
        this.outcomeLabels = dataIndexer.getOutcomeLabels();
        this.outcomeList = dataIndexer.getOutcomeList();
        this.numOutcomes = this.outcomeLabels.length;
        this.predLabels = dataIndexer.getPredLabels();
        this.prior.setLabels(this.outcomeLabels, this.predLabels);
        this.numPreds = this.predLabels.length;
        this.display("\tNumber of Event Tokens: " + this.numUniqueEvents + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        float[][] fArray = new float[this.numPreds][this.numOutcomes];
        for (int i = 0; i < this.numUniqueEvents; ++i) {
            for (int j = 0; j < this.contexts[i].length; ++j) {
                if (this.values == null || this.values[i] == null) {
                    float[] fArray2 = fArray[this.contexts[i][j]];
                    int n8 = this.outcomeList[i];
                    fArray2[n8] = fArray2[n8] + (float)this.numTimesEventsSeen[i];
                    continue;
                }
                float[] fArray3 = fArray[this.contexts[i][j]];
                int n9 = this.outcomeList[i];
                fArray3[n9] = fArray3[n9] + (float)this.numTimesEventsSeen[i] * this.values[i][j];
            }
        }
        dataIndexer = null;
        double d = this._smoothingObservation;
        this.params = new MutableContext[this.numPreds];
        this.modelExpects = new MutableContext[this.numPreds];
        this.observedExpects = new MutableContext[this.numPreds];
        this.evalParams = new EvalParameters(this.params, 0.0, n7, this.numOutcomes);
        int[] nArray = new int[this.numOutcomes];
        int[] nArray2 = new int[this.numOutcomes];
        for (n6 = 0; n6 < this.numOutcomes; ++n6) {
            nArray2[n6] = n6;
        }
        n6 = 0;
        for (n5 = 0; n5 < this.numPreds; ++n5) {
            int[] nArray3;
            n6 = 0;
            if (this.useSimpleSmoothing) {
                n6 = this.numOutcomes;
                nArray3 = nArray2;
            } else {
                for (n4 = 0; n4 < this.numOutcomes; ++n4) {
                    if (!(fArray[n5][n4] > 0.0f) || this.predicateCounts[n5] <= n2) continue;
                    nArray[n6] = n4;
                    ++n6;
                }
                if (n6 == this.numOutcomes) {
                    nArray3 = nArray2;
                } else {
                    nArray3 = new int[n6];
                    for (n4 = 0; n4 < n6; ++n4) {
                        nArray3[n4] = nArray[n4];
                    }
                }
            }
            this.params[n5] = new MutableContext(nArray3, new double[n6]);
            this.modelExpects[n5] = new MutableContext(nArray3, new double[n6]);
            this.observedExpects[n5] = new MutableContext(nArray3, new double[n6]);
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = nArray3[n4];
                this.params[n5].setParameter(n4, 0.0);
                this.modelExpects[n5].setParameter(n4, 0.0);
                if (fArray[n5][n3] > 0.0f) {
                    this.observedExpects[n5].setParameter(n4, fArray[n5][n3]);
                    continue;
                }
                if (!this.useSimpleSmoothing) continue;
                this.observedExpects[n5].setParameter(n4, d);
            }
        }
        if (this.useSlackParameter) {
            n5 = 0;
            for (n4 = 0; n4 < this.numUniqueEvents; ++n4) {
                for (n3 = 0; n3 < this.contexts[n4].length; ++n3) {
                    int n10 = this.contexts[n4][n3];
                    if (this.modelExpects[n10].contains(this.outcomeList[n4])) continue;
                    n5 += this.numTimesEventsSeen[n4];
                }
                n5 += (n7 - this.contexts[n4].length) * this.numTimesEventsSeen[n4];
            }
            this.cfObservedExpect = n5 == 0 ? Math.log(0.01) : Math.log(n5);
        }
        fArray = null;
        this.display("...done.\n");
        this.modelDistribution = new double[this.numOutcomes];
        this.numfeats = new int[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(n);
        return new GISModel(this.params, this.predLabels, this.outcomeLabels, n7, this.evalParams.correctionParam);
    }

    private void findParameters(int n) {
        double d = 0.0;
        double d2 = 0.0;
        this.display("Performing " + n + " iterations.\n");
        for (int i = 1; i <= n; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            d2 = this.nextIteration();
            if (i > 1) {
                if (d > d2) {
                    System.err.println("Model Diverging: loglikelihood decreased");
                    break;
                }
                if (d2 - d < 1.0E-4) break;
            }
            d = d2;
        }
        this.observedExpects = null;
        this.modelExpects = null;
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    private double gaussianUpdate(int n, int n2, int n3, double d) {
        double d2 = this.params[n].getParameters()[n2];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.modelExpects[n].getParameters()[n2];
        double d6 = this.observedExpects[n].getParameters()[n2];
        for (int i = 0; i < 50; ++i) {
            double d7 = d5 * Math.exp(d * d4);
            double d8 = d7 + (d2 + d4) / this.sigma - d6;
            double d9 = d7 * d + 1.0 / this.sigma;
            if (d9 == 0.0) break;
            d3 = d4 - d8 / d9;
            if (Math.abs(d3 - d4) < 1.0E-6) {
                d4 = d3;
                break;
            }
            d4 = d3;
        }
        return d4;
    }

    private double nextIteration() {
        int n;
        int[] nArray;
        int n2;
        double d = 0.0;
        this.CFMOD = 0.0;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.numUniqueEvents; ++n2) {
            int n5;
            int n6;
            if (this.values != null) {
                this.prior.logPrior(this.modelDistribution, this.contexts[n2], this.values[n2]);
                GISModel.eval(this.contexts[n2], this.values[n2], this.modelDistribution, this.evalParams);
            } else {
                this.prior.logPrior(this.modelDistribution, this.contexts[n2]);
                GISModel.eval(this.contexts[n2], this.modelDistribution, this.evalParams);
            }
            for (n6 = 0; n6 < this.contexts[n2].length; ++n6) {
                n5 = this.contexts[n2][n6];
                if (this.predicateCounts[n5] < this.cutoff) continue;
                nArray = this.modelExpects[n5].getOutcomes();
                for (n = 0; n < nArray.length; ++n) {
                    int n7 = nArray[n];
                    this.modelExpects[n5].updateParameter(n, this.modelDistribution[n7] * (double)this.numTimesEventsSeen[n2]);
                }
                if (!this.useSlackParameter) continue;
                for (n = 0; n < this.numOutcomes; ++n) {
                    if (this.modelExpects[n5].contains(n)) continue;
                    this.CFMOD += this.modelDistribution[n] * (double)this.numTimesEventsSeen[n2];
                }
            }
            if (this.useSlackParameter) {
                this.CFMOD += (this.evalParams.correctionConstant - (double)this.contexts[n2].length) * (double)this.numTimesEventsSeen[n2];
            }
            d += Math.log(this.modelDistribution[this.outcomeList[n2]]) * (double)this.numTimesEventsSeen[n2];
            n3 += this.numTimesEventsSeen[n2];
            if (!this.printMessages) continue;
            n6 = 0;
            for (n5 = 1; n5 < this.numOutcomes; ++n5) {
                if (!(this.modelDistribution[n5] > this.modelDistribution[n6])) continue;
                n6 = n5;
            }
            if (n6 != this.outcomeList[n2]) continue;
            n4 += this.numTimesEventsSeen[n2];
        }
        this.display(".");
        for (n2 = 0; n2 < this.numPreds; ++n2) {
            double[] dArray = this.observedExpects[n2].getParameters();
            double[] dArray2 = this.modelExpects[n2].getParameters();
            nArray = this.params[n2].getOutcomes();
            for (n = 0; n < nArray.length; ++n) {
                if (this.useGaussianSmoothing) {
                    this.params[n2].updateParameter(n, this.gaussianUpdate(n2, n, n3, this.evalParams.correctionConstant));
                } else {
                    if (dArray2[n] == 0.0) {
                        System.err.println("Model expects == 0 for " + this.predLabels[n2] + " " + this.outcomeLabels[n]);
                    }
                    this.params[n2].updateParameter(n, Math.log(dArray[n]) - Math.log(dArray2[n]));
                }
                this.modelExpects[n2].setParameter(n, 0.0);
            }
        }
        if (this.CFMOD > 0.0 && this.useSlackParameter) {
            this.evalParams.correctionParam += this.cfObservedExpect - Math.log(this.CFMOD);
        }
        this.display(". loglikelihood=" + d + "\t" + (double)n4 / (double)n3 + "\n");
        return d;
    }

    private void display(String string) {
        if (this.printMessages) {
            System.out.print(string);
        }
    }
}

