/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.ComparablePredicate;
import opennlp.maxent.Context;
import opennlp.maxent.GISModel;

public abstract class GISModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected int CORRECTION_CONSTANT;
    protected double CORRECTION_PARAM;
    protected String[] PRED_LABELS;

    public GISModelWriter(GISModel gISModel) {
        Object[] objectArray = gISModel.getDataStructures();
        this.PARAMS = (Context[])objectArray[0];
        TObjectIntHashMap tObjectIntHashMap = (TObjectIntHashMap)objectArray[1];
        this.OUTCOME_LABELS = (String[])objectArray[2];
        this.CORRECTION_CONSTANT = (Integer)objectArray[3];
        this.CORRECTION_PARAM = (Double)objectArray[4];
        this.PRED_LABELS = new String[tObjectIntHashMap.size()];
        tObjectIntHashMap.forEachEntry(new TObjectIntProcedure(){

            public boolean execute(Object object, int n) {
                GISModelWriter.this.PRED_LABELS[n] = (String)object;
                return true;
            }
        });
    }

    protected abstract void writeUTF(String var1) throws IOException;

    protected abstract void writeInt(int var1) throws IOException;

    protected abstract void writeDouble(double var1) throws IOException;

    protected abstract void close() throws IOException;

    public void persist() throws IOException {
        int n;
        this.writeUTF("GIS");
        this.writeInt(this.CORRECTION_CONSTANT);
        this.writeDouble(this.CORRECTION_PARAM);
        this.writeInt(this.OUTCOME_LABELS.length);
        for (int i = 0; i < this.OUTCOME_LABELS.length; ++i) {
            this.writeUTF(this.OUTCOME_LABELS[i]);
        }
        ComparablePredicate[] comparablePredicateArray = this.sortValues();
        List list = this.compressOutcomes(comparablePredicateArray);
        this.writeInt(list.size());
        for (n = 0; n < list.size(); ++n) {
            List list2 = (List)list.get(n);
            this.writeUTF(list2.size() + ((ComparablePredicate)list2.get(0)).toString());
        }
        this.writeInt(this.PARAMS.length);
        for (n = 0; n < comparablePredicateArray.length; ++n) {
            this.writeUTF(comparablePredicateArray[n].name);
        }
        for (n = 0; n < comparablePredicateArray.length; ++n) {
            for (int i = 0; i < comparablePredicateArray[n].params.length; ++i) {
                this.writeDouble(comparablePredicateArray[n].params[i]);
            }
        }
        this.close();
    }

    protected ComparablePredicate[] sortValues() {
        Object[] objectArray = new ComparablePredicate[this.PARAMS.length];
        int n = 0;
        for (int i = 0; i < this.PARAMS.length; ++i) {
            int[] nArray = this.PARAMS[i].getOutcomes();
            int n2 = nArray.length;
            int[] nArray2 = nArray;
            double[] dArray = this.PARAMS[i].getParameters();
            n += n2;
            objectArray[i] = new ComparablePredicate(this.PRED_LABELS[i], nArray2, dArray);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected List compressOutcomes(ComparablePredicate[] comparablePredicateArray) {
        ComparablePredicate comparablePredicate = comparablePredicateArray[0];
        ArrayList arrayList = new ArrayList();
        ArrayList<ComparablePredicate> arrayList2 = new ArrayList<ComparablePredicate>();
        for (int i = 0; i < comparablePredicateArray.length; ++i) {
            if (comparablePredicate.compareTo(comparablePredicateArray[i]) == 0) {
                arrayList2.add(comparablePredicateArray[i]);
                continue;
            }
            comparablePredicate = comparablePredicateArray[i];
            arrayList.add(arrayList2);
            arrayList2 = new ArrayList();
            arrayList2.add(comparablePredicateArray[i]);
        }
        arrayList.add(arrayList2);
        return arrayList;
    }
}

