/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.tokenize.TokenizerME;

public class Tokenizer
extends TokenizerME {
    public Tokenizer(String name) throws IOException {
        super(new SuffixSensitiveGISModelReader(new File(name)).getModel());
        this.setAlphaNumericOptimization(true);
    }

    public Tokenizer(MaxentModel model) throws IOException {
        super(model);
        this.setAlphaNumericOptimization(true);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage:  java opennlp.tools.english.Tokenizer model < sentences");
            System.exit(1);
        }
        Tokenizer tokenizer = new Tokenizer(args[0]);
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                System.out.println();
            } else {
                String[] tokens = tokenizer.tokenize(line);
                if (tokens.length > 0) {
                    System.out.print(tokens[0]);
                }
                int tn = tokens.length;
                for (int ti = 1; ti < tn; ++ti) {
                    System.out.print(" " + tokens[ti]);
                }
                System.out.println();
            }
            line = inReader.readLine();
        }
    }
}

