/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotDeletionPolicy
implements IndexDeletionPolicy {
    private IndexCommit lastCommit;
    private IndexDeletionPolicy primary;
    private String snapshot;

    public SnapshotDeletionPolicy(IndexDeletionPolicy primary) {
        this.primary = primary;
    }

    @Override
    public synchronized void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.primary.onInit(this.wrapCommits(commits));
        this.lastCommit = commits.get(commits.size() - 1);
    }

    @Override
    public synchronized void onCommit(List<? extends IndexCommit> commits) throws IOException {
        this.primary.onCommit(this.wrapCommits(commits));
        this.lastCommit = commits.get(commits.size() - 1);
    }

    public synchronized IndexCommit snapshot() {
        if (this.lastCommit == null) {
            throw new IllegalStateException("no index commits to snapshot !");
        }
        if (this.snapshot != null) {
            throw new IllegalStateException("snapshot is already set; please call release() first");
        }
        this.snapshot = this.lastCommit.getSegmentsFileName();
        return this.lastCommit;
    }

    public synchronized void release() {
        if (this.snapshot == null) {
            throw new IllegalStateException("snapshot was not set; please call snapshot() first");
        }
        this.snapshot = null;
    }

    private List<IndexCommit> wrapCommits(List<? extends IndexCommit> commits) {
        int count = commits.size();
        ArrayList<IndexCommit> myCommits = new ArrayList<IndexCommit>(count);
        for (int i = 0; i < count; ++i) {
            myCommits.add(new MyCommitPoint(commits.get(i)));
        }
        return myCommits;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyCommitPoint
    extends IndexCommit {
        IndexCommit cp;

        MyCommitPoint(IndexCommit cp) {
            this.cp = cp;
        }

        @Override
        public String getSegmentsFileName() {
            return this.cp.getSegmentsFileName();
        }

        @Override
        public Collection<String> getFileNames() throws IOException {
            return this.cp.getFileNames();
        }

        @Override
        public Directory getDirectory() {
            return this.cp.getDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            SnapshotDeletionPolicy snapshotDeletionPolicy = SnapshotDeletionPolicy.this;
            synchronized (snapshotDeletionPolicy) {
                if (SnapshotDeletionPolicy.this.snapshot == null || !SnapshotDeletionPolicy.this.snapshot.equals(this.getSegmentsFileName())) {
                    this.cp.delete();
                }
            }
        }

        @Override
        public boolean isDeleted() {
            return this.cp.isDeleted();
        }

        @Override
        public long getVersion() {
            return this.cp.getVersion();
        }

        @Override
        public long getGeneration() {
            return this.cp.getGeneration();
        }

        @Override
        public Map<String, String> getUserData() throws IOException {
            return this.cp.getUserData();
        }

        @Override
        public boolean isOptimized() {
            return this.cp.isOptimized();
        }
    }
}

