/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImplMBean;

public class AnalysisEngineManagementImpl
implements AnalysisEngineManagementImplMBean,
AnalysisEngineManagement {
    private static final long serialVersionUID = 1988620286191379887L;
    private static final Pattern RESERVED_CHAR_PATTERN = Pattern.compile("[\",=:*?]");
    static final DecimalFormat format = new DecimalFormat("0.##");
    private static Set usedRootNames = new HashSet();
    private String name;
    private long numProcessed;
    private long markedAnalysisTime;
    private long markedBatchProcessCompleteTime;
    private long markedCollectionProcessCompleteTime;
    private long markedServiceCallTime;
    private long analysisTime;
    private long batchProcessCompleteTime;
    private long collectionProcessCompleteTime;
    private long serviceCallTime;
    private Map components = new HashMap();
    private String uniqueMBeanName;

    public void reportAnalysisTime(long time) {
        this.analysisTime += time;
    }

    public void reportBatchProcessCompleteTime(long time) {
        this.batchProcessCompleteTime += time;
    }

    public void reportCollectionProcessCompleteTime(long time) {
        this.collectionProcessCompleteTime += time;
    }

    public void reportServiceCallTime(long time) {
        this.serviceCallTime += time;
    }

    public void incrementCASesProcessed() {
        ++this.numProcessed;
    }

    public long getBatchProcessCompleteTime() {
        return this.batchProcessCompleteTime;
    }

    public long getCollectionProcessCompleteTime() {
        return this.collectionProcessCompleteTime;
    }

    public long getAnalysisTime() {
        return this.analysisTime;
    }

    public long getServiceCallTime() {
        return this.serviceCallTime;
    }

    public void mark() {
        this.markedAnalysisTime = this.analysisTime;
        this.markedBatchProcessCompleteTime = this.batchProcessCompleteTime;
        this.markedCollectionProcessCompleteTime = this.collectionProcessCompleteTime;
        this.markedServiceCallTime = this.serviceCallTime;
        for (AnalysisEngineManagementImpl component : this.components.values()) {
            component.mark();
        }
    }

    public long getBatchProcessCompleteTimeSinceMark() {
        return this.batchProcessCompleteTime - this.markedBatchProcessCompleteTime;
    }

    public long getCollectionProcessCompleteTimeSinceMark() {
        return this.collectionProcessCompleteTime - this.markedCollectionProcessCompleteTime;
    }

    public long getAnalysisTimeSinceMark() {
        return this.analysisTime - this.markedAnalysisTime;
    }

    public long getServiceCallTimeSinceMark() {
        return this.serviceCallTime - this.markedServiceCallTime;
    }

    public long getNumberOfCASesProcessed() {
        return this.numProcessed;
    }

    public String getCASesPerSecond() {
        if (this.analysisTime == 0L) {
            return "0";
        }
        float docsPerSecond = (float)this.numProcessed / (float)this.analysisTime * 1000.0f;
        return format.format(docsPerSecond);
    }

    public Map getComponents() {
        return Collections.unmodifiableMap(this.components);
    }

    public void addComponent(String key, AnalysisEngineManagementImpl component) {
        this.components.put(key, component);
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueMBeanName() {
        return this.uniqueMBeanName;
    }

    public void resetStats() {
        this.numProcessed = 0L;
        this.analysisTime = 0L;
        this.batchProcessCompleteTime = 0L;
        this.collectionProcessCompleteTime = 0L;
        this.serviceCallTime = 0L;
        this.markedAnalysisTime = 0L;
        this.markedBatchProcessCompleteTime = 0L;
        this.markedCollectionProcessCompleteTime = 0L;
        this.markedServiceCallTime = 0L;
        for (AnalysisEngineManagementImpl component : this.components.values()) {
            component.resetStats();
        }
    }

    public void setName(String aName, UimaContextAdmin aContext, String aCustomPrefix) {
        String prefix;
        this.name = aName;
        if (aCustomPrefix == null) {
            prefix = "org.apache.uima:";
        } else {
            prefix = aCustomPrefix;
            if (!prefix.endsWith(":") && !prefix.endsWith(",")) {
                prefix = prefix + ",";
            }
        }
        AnalysisEngineManagementImpl rootMBean = (AnalysisEngineManagementImpl)aContext.getRootContext().getManagementInterface();
        if (rootMBean.getUniqueMBeanName() == null) {
            String baseRootName = rootMBean.getName();
            if (baseRootName == null) {
                baseRootName = "CPE";
            }
            String rootName = baseRootName;
            int i = 2;
            while (usedRootNames.contains(rootName)) {
                rootName = baseRootName + " " + i++;
            }
            usedRootNames.add(rootName);
            rootMBean.uniqueMBeanName = prefix + "name=" + AnalysisEngineManagementImpl.escapeValue(rootName);
        }
        if (rootMBean != this) {
            String rootName = rootMBean.getUniqueMBeanName();
            rootName = rootName.substring(prefix.length() + "name=".length());
            prefix = prefix + "p0=";
            prefix = rootName.endsWith("\"") ? prefix + rootName.substring(0, rootName.length() - 1) + " Components\"," : prefix + rootName + " Components,";
            this.uniqueMBeanName = AnalysisEngineManagementImpl.makeMBeanName(prefix, aContext.getQualifiedContextName().substring(1), 1);
        }
    }

    private static String makeMBeanName(String prefix, String contextName, int depth) {
        int firstSlash = contextName.indexOf(47);
        if (firstSlash == contextName.length() - 1) {
            return prefix + "name=" + AnalysisEngineManagementImpl.escapeValue(contextName.substring(0, contextName.length() - 1));
        }
        String newPrefix = prefix + "p" + depth + "=" + AnalysisEngineManagementImpl.escapeValue(contextName.substring(0, firstSlash) + " Components") + ",";
        return AnalysisEngineManagementImpl.makeMBeanName(newPrefix, contextName.substring(firstSlash + 1), depth + 1);
    }

    private static String escapeValue(String value) {
        if (RESERVED_CHAR_PATTERN.matcher(value).find()) {
            StringBuffer buf = new StringBuffer();
            buf.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\"' || c == '\\' || c == '?' || c == '*') {
                    buf.append('\\');
                }
                buf.append(c);
            }
            buf.append('\"');
            return buf.toString();
        }
        return value;
    }
}

