/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.impl.EmptyCasIterator;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.XMLInputSource;

public class PearAnalysisEngineWrapper
extends AnalysisEngineImplBase {
    private static Map cachedResourceManagers = Collections.synchronizedMap(new WeakHashMap(4));
    private AnalysisEngine ae = null;

    private Map createRMmap(StringPair sp, ResourceManager rm) {
        HashMap<StringPair, ResourceManager> result = new HashMap<StringPair, ResourceManager>(4);
        result.put(sp, rm);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "createRMmap", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_create_RM_map", new Object[]{sp.classPath, sp.dataPath});
        return result;
    }

    private ResourceManager createRM(StringPair sp, PackageBrowser pkgBrowser) throws MalformedURLException {
        ResourceManager rsrcMgr = UIMAFramework.newDefaultResourceManager();
        rsrcMgr.setExtensionClassPath(sp.classPath, true);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "createRM", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_set_classpath__CONFIG", new Object[]{sp.classPath, pkgBrowser.getRootDirectory().getName()});
        if (sp.dataPath != null) {
            rsrcMgr.setDataPath(sp.dataPath);
            UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "createRM", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_set_datapath__CONFIG", new Object[]{sp.dataPath, pkgBrowser.getRootDirectory().getName()});
        }
        return rsrcMgr;
    }

    public boolean initialize(ResourceSpecifier aSpecifier, Map aAdditionalParams) throws ResourceInitializationException {
        if (!(aSpecifier instanceof PearSpecifier)) {
            return false;
        }
        PearSpecifier pearSpec = (PearSpecifier)aSpecifier;
        String pearRootDirPath = pearSpec.getPearPath();
        try {
            ResourceManager innerRM;
            File pearRootDir = new File(pearRootDirPath);
            PackageBrowser pkgBrowser = new PackageBrowser(pearRootDir);
            Properties props = pkgBrowser.getComponentEnvVars();
            Iterator<Object> keyIterator = props.keySet().iterator();
            Properties systemProps = System.getProperties();
            while (keyIterator.hasNext()) {
                String systemPropValue;
                String key = (String)keyIterator.next();
                String value = (String)props.get(key);
                if (systemProps.containsKey(key) && !(systemPropValue = (String)systemProps.get(key)).equals(value)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_system_var_already_set__WARNING", new Object[]{key + "=" + systemPropValue, key + "=" + value, pkgBrowser.getRootDirectory().getName()});
                }
                System.setProperty(key, value);
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_set_system_var__CONFIG", new Object[]{key + "=" + value, pkgBrowser.getRootDirectory().getName()});
            }
            ResourceManager applicationRM = this.getResourceManager();
            String classPath = pkgBrowser.buildComponentClassPath();
            String dataPath = pkgBrowser.getComponentDataPath();
            StringPair sp = new StringPair(classPath, dataPath);
            Map c1 = (Map)cachedResourceManagers.get(applicationRM);
            if (null == c1) {
                innerRM = this.createRM(sp, pkgBrowser);
                cachedResourceManagers.put(applicationRM, this.createRMmap(sp, innerRM));
            } else {
                innerRM = (ResourceManager)c1.get(sp);
                if (null == innerRM) {
                    innerRM = this.createRM(sp, pkgBrowser);
                    c1.put(sp, innerRM);
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_add_RM_map", new Object[]{sp.classPath, sp.dataPath});
                }
            }
            XMLInputSource in = new XMLInputSource(pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            this.ae = UIMAFramework.produceAnalysisEngine(specifier, innerRM, null);
        }
        catch (IOException ex) {
            throw new ResourceInitializationException(ex);
        }
        catch (InvalidXMLException ex) {
            throw new ResourceInitializationException(ex);
        }
        super.initialize(aSpecifier, aAdditionalParams);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_successful__CONFIG", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        return true;
    }

    public AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return (AnalysisEngineMetaData)this.getMetaData();
    }

    public ResourceMetaData getMetaData() {
        return this.ae.getMetaData();
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        this.ae.batchProcessComplete();
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.ae.collectionProcessComplete();
    }

    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINE, this.getClass().getName(), "processAndOutputNewCASes", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_begin__FINE", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        this.ae.process(aCAS);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINE, this.getClass().getName(), "processAndOutputNewCASes", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_end__FINE", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        return new EmptyCasIterator();
    }

    public void destroy() {
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "destroy", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_destroyed__CONFIG", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        this.ae.destroy();
    }

    public void setResultSpecification(ResultSpecification resultSpec) {
        this.ae.setResultSpecification(resultSpec);
    }

    public void batchProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        this.ae.batchProcessComplete(trace);
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        this.ae.collectionProcessComplete(trace);
    }

    public ResultSpecification createResultSpecification() {
        return this.ae.createResultSpecification();
    }

    public ResultSpecification createResultSpecification(TypeSystem typeSystem) {
        return this.ae.createResultSpecification(typeSystem);
    }

    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        return this.ae.getProcessingResourceMetaData();
    }

    public synchronized CAS newCAS() throws ResourceInitializationException {
        return this.ae.newCAS();
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        this.ae.typeSystemInit(typeSystem);
    }

    private static class StringPair {
        private String classPath;
        private String dataPath;

        public StringPair(String classPath, String dataPath) {
            this.classPath = classPath;
            this.dataPath = dataPath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.classPath == null ? 0 : this.classPath.hashCode());
            result = 31 * result + (this.dataPath == null ? 0 : this.dataPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringPair other = (StringPair)obj;
            if (this.classPath == null ? other.classPath != null : !this.classPath.equals(other.classPath)) {
                return false;
            }
            return !(this.dataPath == null ? other.dataPath != null : !this.dataPath.equals(other.dataPath));
        }
    }
}

