/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.impl.CASImpl;

public class CASSerializer
implements Serializable {
    static final long serialVersionUID = -7972011651957420295L;
    public int[] heapArray = null;
    public int[] heapMetaData = null;
    public String[] stringTable;
    public int[] fsIndex;
    public byte[] byteHeapArray;
    public short[] shortHeapArray;
    public long[] longHeapArray;

    public void addNoMetaData(CASImpl casImpl) {
        this.addCAS(casImpl, false);
    }

    public void addCAS(CASImpl cas) {
        this.addCAS(cas, true);
    }

    public void addCAS(CASImpl cas, boolean addMetaData) {
        this.fsIndex = cas.getIndexedFSs();
        int heapSize = cas.getHeap().getCellsUsed();
        this.heapArray = new int[heapSize];
        System.arraycopy(cas.getHeap().heap, 0, this.heapArray, 0, heapSize);
        if (addMetaData) {
            this.heapMetaData = cas.getHeap().getMetaData();
        }
        this.stringTable = this.stringArrayListToArray(cas.getStringTable());
        int byteHeapSize = cas.getByteHeap().getSize();
        this.byteHeapArray = new byte[byteHeapSize];
        System.arraycopy(cas.getByteHeap().heap, 0, this.byteHeapArray, 0, byteHeapSize);
        int shortHeapSize = cas.getShortHeap().getSize();
        this.shortHeapArray = new short[shortHeapSize];
        System.arraycopy(cas.getShortHeap().heap, 0, this.shortHeapArray, 0, shortHeapSize);
        int longHeapSize = cas.getLongHeap().getSize();
        this.longHeapArray = new long[longHeapSize];
        System.arraycopy(cas.getLongHeap().heap, 0, this.longHeapArray, 0, longHeapSize);
    }

    public void addCAS(CASImpl cas, OutputStream ostream) {
        try {
            int i;
            DataOutputStream dos = new DataOutputStream(ostream);
            this.fsIndex = cas.getIndexedFSs();
            byte[] uima = new byte[]{85, 73, 77, 65};
            ByteBuffer buf = ByteBuffer.wrap(uima);
            int key = buf.asIntBuffer().get();
            int version = 1;
            dos.writeInt(key);
            dos.writeInt(version);
            int heapSize = cas.getHeap().getCellsUsed();
            dos.writeInt(heapSize);
            for (int i2 = 0; i2 < heapSize; ++i2) {
                dos.writeInt(cas.getHeap().heap[i2]);
            }
            int[] refheap = new int[cas.getStringHeap().refHeapPos];
            for (int i3 = 0; i3 < refheap.length; ++i3) {
                refheap[i3] = cas.getStringHeap().refHeap[i3];
            }
            int stringHeapLength = cas.getStringHeap().charHeapPos;
            int stringListLength = 0;
            for (int i4 = 0; i4 < refheap.length; i4 += 3) {
                int ref = refheap[i4 + 2];
                if (ref == 0) continue;
                stringListLength += 1 + ((String)cas.getStringHeap().stringList.get(ref)).length();
            }
            int stringTotalLength = stringHeapLength + stringListLength;
            if (stringHeapLength == 0 && stringListLength > 0) {
                ++stringTotalLength;
            }
            dos.writeInt(stringTotalLength);
            if (stringTotalLength > 0) {
                if (cas.getStringHeap().charHeapPos > 0) {
                    dos.writeChars(String.valueOf(cas.getStringHeap().stringHeap, 0, cas.getStringHeap().charHeapPos));
                } else if (stringListLength > 0) {
                    dos.writeChar(0);
                }
                if (stringListLength > 0) {
                    int pos = cas.getStringHeap().charHeapPos > 0 ? cas.getStringHeap().charHeapPos : 1;
                    for (i = 0; i < refheap.length; i += 3) {
                        int ref = refheap[i + 2];
                        if (ref == 0) continue;
                        refheap[i + 0] = pos;
                        dos.writeChars((String)cas.getStringHeap().stringList.get(ref));
                        dos.writeChar(0);
                        pos += 1 + ((String)cas.getStringHeap().stringList.get(ref)).length();
                    }
                }
                if (stringTotalLength % 2 != 0) {
                    dos.writeChar(0);
                }
            }
            int refheapsz = (refheap.length - 3) / 3 * 2;
            dos.writeInt(++refheapsz);
            dos.writeInt(0);
            for (i = 3; i < refheap.length; i += 3) {
                dos.writeInt(refheap[i + 0]);
                dos.writeInt(refheap[i + 1]);
            }
            dos.writeInt(this.fsIndex.length);
            for (i = 0; i < this.fsIndex.length; ++i) {
                dos.writeInt(this.fsIndex[i]);
            }
            int byteheapsz = cas.getByteHeap().getSize();
            dos.writeInt(byteheapsz);
            for (int i5 = 0; i5 < cas.getByteHeap().getSize(); ++i5) {
                dos.writeByte(cas.getByteHeap().heap[i5]);
            }
            int align = (4 - byteheapsz % 4) % 4;
            for (int i6 = 0; i6 < align; ++i6) {
                dos.writeByte(0);
            }
            int shortheapsz = cas.getShortHeap().getSize();
            dos.writeInt(shortheapsz);
            for (int i7 = 0; i7 < cas.getShortHeap().getSize(); ++i7) {
                dos.writeShort(cas.getShortHeap().heap[i7]);
            }
            if (shortheapsz % 2 != 0) {
                dos.writeShort(0);
            }
            int longheapsz = cas.getLongHeap().getSize();
            dos.writeInt(longheapsz);
            for (int i8 = 0; i8 < cas.getLongHeap().getSize(); ++i8) {
                dos.writeLong(cas.getLongHeap().heap[i8]);
            }
        }
        catch (IOException e) {
            CASRuntimeException exception = new CASRuntimeException("BLOB_SERIALIZATION", new String[]{e.getMessage()});
            throw exception;
        }
    }

    private String[] stringArrayListToArray(ArrayList arrayList) {
        int max = arrayList.size();
        String[] ar = new String[max];
        for (int i = 0; i < max; ++i) {
            ar[i] = (String)arrayList.get(i);
        }
        return ar;
    }

    int[] getHeapMetadata() {
        return this.heapMetaData;
    }

    int[] getHeapArray() {
        return this.heapArray;
    }

    String[] getStringTable() {
        return this.stringTable;
    }

    int[] getFSIndex() {
        return this.fsIndex;
    }

    byte[] getByteArray() {
        return this.byteHeapArray;
    }

    short[] getShortArray() {
        return this.shortHeapArray;
    }

    long[] getLongArray() {
        return this.longHeapArray;
    }
}

