/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSConstraint;
import org.apache.uima.cas.FSFloatConstraint;
import org.apache.uima.cas.FSIntConstraint;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FSStringConstraint;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.impl.ConjunctiveConstraint;
import org.apache.uima.cas.impl.DisjunctiveConstraint;
import org.apache.uima.cas.impl.EmbeddedConstraint;
import org.apache.uima.cas.impl.FSFloatConstraintImpl;
import org.apache.uima.cas.impl.FSIntConstraintImpl;
import org.apache.uima.cas.impl.FSStringConstraintImpl;
import org.apache.uima.cas.impl.FSTypeConstraintImpl;
import org.apache.uima.cas.impl.FloatConstraint;
import org.apache.uima.cas.impl.IntConstraint;
import org.apache.uima.cas.impl.StringConstraint;

public class ConstraintFactoryImpl
extends ConstraintFactory {
    public FSTypeConstraint createTypeConstraint() {
        return new FSTypeConstraintImpl();
    }

    public FSIntConstraint createIntConstraint() {
        return new FSIntConstraintImpl();
    }

    public FSFloatConstraint createFloatConstraint() {
        return new FSFloatConstraintImpl();
    }

    public FSStringConstraint createStringConstraint() {
        return new FSStringConstraintImpl();
    }

    public FSMatchConstraint embedConstraint(FeaturePath featPath, FSConstraint constraint) {
        ArrayList<String> path = new ArrayList<String>();
        for (int i = 0; i < featPath.size(); ++i) {
            path.add(featPath.getFeature(i).getShortName());
        }
        if (constraint instanceof FSMatchConstraint) {
            return new EmbeddedConstraint(path, constraint);
        }
        if (constraint instanceof FSIntConstraint) {
            return new IntConstraint(path, (FSIntConstraint)constraint);
        }
        if (constraint instanceof FSFloatConstraint) {
            return new FloatConstraint(path, (FSFloatConstraint)constraint);
        }
        if (constraint instanceof FSStringConstraint) {
            return new StringConstraint(path, (FSStringConstraint)constraint);
        }
        return null;
    }

    public FSMatchConstraint embedConstraint(ArrayList path, FSConstraint constraint) {
        if (constraint instanceof FSMatchConstraint) {
            return new EmbeddedConstraint(path, constraint);
        }
        if (constraint instanceof FSIntConstraint) {
            return new IntConstraint(path, (FSIntConstraint)constraint);
        }
        if (constraint instanceof FSFloatConstraint) {
            return new FloatConstraint(path, (FSFloatConstraint)constraint);
        }
        if (constraint instanceof FSStringConstraint) {
            return new StringConstraint(path, (FSStringConstraint)constraint);
        }
        return null;
    }

    public FSMatchConstraint and(FSMatchConstraint c1, FSMatchConstraint c2) {
        return new ConjunctiveConstraint(c1, c2);
    }

    public FSMatchConstraint or(FSMatchConstraint c1, FSMatchConstraint c2) {
        return new DisjunctiveConstraint(c1, c2);
    }
}

